/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVDU
extends ICCommand {
    private static final String VOX_GETVDU_CMD = "VOX.getvdu";
    private static final String ERROR_PREAMBLE = "ICGetVDU:";
    List<String> names;
    String vdu_Id;

    public GetVDU(String name) {
        this.names = new ArrayList<String>();
        this.names.add(name);
    }

    public GetVDU(List<String> names) {
        this.names = names;
    }

    @Override
    protected String getCommand(String reqID) {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            if (this.vdu_Id.length() > 0) {
                StringBuffer sb = new StringBuffer("[VOX.getvdu(\"" + this.vdu_Id + "\"");
                for (String name : this.names) {
                    sb.append(",\"" + this.convertVariableToICFormat(name) + "\",");
                }
                sb.append(")][" + reqID + "]");
                return sb.toString();
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    @Override
    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    private String convertVariableNameToDDFormat(String name) {
        name = name.replaceAll("\\.\\.", "__DOTDOT__");
        return name.replaceAll("\\.", "__DOT__").replaceAll("\\+", "__PLUS__").replaceAll("\\*", "__STAR__").replaceAll("\\!", "__MARK__");
    }

    @Override
    protected Object parseResponse(String response) throws SCERuntimeException {
        String error = "";
        StringTokenizer st = new StringTokenizer(response, "(,)", true);
        if (st.hasMoreTokens()) {
            st.nextToken();
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        if (!error.equals(",")) {
            this.setError(error);
        }
        String retValue = "";
        String value = "";
        st.nextToken();
        st.nextToken();
        while (st.hasMoreTokens()) {
            IComplexVariable vduCache;
            IVariableField field;
            String name = st.nextToken().replaceAll("\"", "");
            st.nextToken();
            if (!st.hasMoreTokens()) continue;
            value = st.nextToken();
            while (!value.endsWith("\"")) {
                value = value + st.nextToken();
            }
            retValue = value = value.replaceAll("\"", "");
            IVariable tmp = this.session.getVariable("vdu_cache");
            if (tmp != null && (field = (vduCache = tmp.getComplexVariable()).getField(this.convertVariableNameToDDFormat(name))) != null) {
                field.setValue(value);
            }
            if (!st.nextToken().equals(")")) continue;
            return retValue;
        }
        return retValue;
    }
}

