/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.GetVox;
import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class InvokeWorkflow
extends ICCommand {
    private static final String VOX_WORKFLOW_TR2_CMD = "VOX.tr2";
    private static final String VOX_WORKFLOW_TR1_CMD = "VOX.tr1";
    private static final String ERROR_PREAMBLE = "ICInvokeWorkflow:";
    String workflowName;
    int timeout;
    List inputs;
    List outputs;
    String vdu_Id;

    public InvokeWorkflow(String workflowName, int timeout, List inputs, List outputs) {
        this.workflowName = workflowName;
        this.timeout = timeout;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    protected String getCommand(String reqID) {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            String cmd = VOX_WORKFLOW_TR2_CMD;
            if (this.timeout == 0) {
                cmd = VOX_WORKFLOW_TR1_CMD;
            }
            if (this.vdu_Id.length() > 0) {
                String retString = new String("[" + cmd + this.workflowName + "(\"" + this.vdu_Id + "\"");
                if (this.inputs != null) {
                    Iterator i = this.inputs.iterator();
                    while (i.hasNext()) {
                        IVariableField inputVar = this.session.getVariableField(new VariableName((String)i.next()));
                        retString = retString + ",\"" + inputVar.getStringValue() + "\"";
                    }
                }
                retString = retString + ")][" + reqID + "]";
                return retString;
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected int getTimeout() {
        return this.timeout;
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        String retvdu_Id;
        if (this.getTimeout() == 0) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(response, "[(,)]");
        String error = "";
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        if ((retvdu_Id = error.replaceAll("\"", "")).compareTo(this.vdu_Id) != 0) {
            this.setError(error.replaceAll("\"", ""));
        }
        if (this.outputs != null) {
            for (String name : this.outputs) {
                String[] splitNames = name.split(":");
                VariableName varName = new VariableName(name);
                IVariableField outputVar = this.session.getVariableField(varName);
                if (outputVar == null) {
                    this.session.throwRTException("IC InvokeWorkflow error: variable: " + name + " does not exist");
                }
                GetVox getVox = null;
                getVox = splitNames == null || splitNames[0] == null || splitNames[0].equals(name) ? new GetVox(name) : new GetVox(splitNames[1]);
                String value = (String)getVox.executeCommand(this.session);
                outputVar.setValue(value);
            }
        }
        return null;
    }
}

