/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.datetime;

import com.avaya.runtime.platforms.Toolkit;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IEvaluatable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class SetDatetimeVar
extends Debugging
implements IEvaluatable {
    private String srcDateVarName;
    private String destDateVarName;
    private String destTimeVarName;

    public SetDatetimeVar(String srcDateVarName, String destDateVarName, String destTimeVarName) {
        this.srcDateVarName = srcDateVarName;
        this.destDateVarName = destDateVarName;
        this.destTimeVarName = destTimeVarName;
    }

    public void evaluate(IRuntimeSession session) {
        IVariable ddTimeVar;
        SimpleDateFormat format;
        if (session.isTraceEnabled()) {
            session.getTraceOutput().writeln(2, "Set datetime object value to DD variables.");
        }
        String localString = Toolkit.getCurrentLanguageLocalization((SCESession)session);
        String[] langCountry = localString.split("-");
        Locale locale = new Locale(langCountry[0], langCountry[1]);
        IVariableField srcDateVarField = session.getVariableField(new VariableName(this.srcDateVarName));
        Object value = srcDateVarField.getObjectValue();
        if (!(value instanceof Date)) {
            session.getTraceOutput().writeln(4, this.srcDateVarName + " does not contain date object.");
            return;
        }
        Date date = (Date)value;
        Calendar calendar = Calendar.getInstance(locale);
        calendar.setTime(date);
        IVariable ddDateVar = null;
        if (this.destDateVarName != null) {
            ddDateVar = session.getVariable(this.destDateVarName);
        }
        IVariableField field = null;
        if (ddDateVar != null) {
            IComplexVariable complexVariable = ddDateVar.getComplexVariable();
            field = complexVariable.getField("year");
            if (field != null) {
                field.setValue(calendar.get(1));
            }
            if ((field = complexVariable.getField("month")) != null) {
                format = new SimpleDateFormat("MMMMMMMM", locale);
                field.setValue(format.format(date));
            }
            if ((field = complexVariable.getField("monthinyear")) != null) {
                field.setValue(calendar.get(2) + 1);
            }
            if ((field = complexVariable.getField("dayofmonth")) != null) {
                field.setValue(calendar.get(5));
            }
            if ((field = complexVariable.getField("dayofweek")) != null) {
                format = new SimpleDateFormat("EEEEEEEEE", locale);
                field.setValue(format.format(date));
            }
            if ((field = complexVariable.getField("dayofweeknum")) != null) {
                field.setValue(calendar.get(7));
            }
            if ((field = complexVariable.getField("dayofyear")) != null) {
                field.setValue(calendar.get(6));
            }
        }
        if (this.destTimeVarName != null && (ddTimeVar = session.getVariable(this.destTimeVarName)) != null) {
            IComplexVariable complexVariable = ddTimeVar.getComplexVariable();
            field = complexVariable.getField("hour");
            if (field != null) {
                field.setValue(calendar.get(11));
            }
            if ((field = complexVariable.getField("minute")) != null) {
                field.setValue(calendar.get(12));
            }
            if ((field = complexVariable.getField("second")) != null) {
                field.setValue(calendar.get(13));
            }
            if ((field = complexVariable.getField("millisecond")) != null) {
                field.setValue(calendar.get(14));
            }
            if ((field = complexVariable.getField("timezone")) != null) {
                format = new SimpleDateFormat("Z", locale);
                field.setValue(format.format(date));
            }
        }
    }
}

