/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic.pdc;

import com.avaya.sce.runtime.IPluggableConnectorLifeCycle;
import com.avaya.sce.runtime.SimpleVariable;
import com.avaya.sce.runtime.VDUVariableField;
import com.avaya.sce.runtime.connectivity.ic.CallGone;
import com.avaya.sce.runtime.connectivity.ic.NewCall;
import com.avaya.sce.runtime.varoperations.CaptureException;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class ICConnectorInit
implements IPluggableConnectorLifeCycle {
    private static final boolean DEBUG_SANITY_CHECKS = true;

    public void applicationStarted(IRuntimeSession session, boolean isMainApplication) {
    }

    private boolean isEDUID(String eduid) {
        if (eduid.charAt(30) != '0' || eduid.charAt(31) != '2') {
            return false;
        }
        int iSection = 1;
        boolean timeStampOk = false;
        boolean IPOk = false;
        boolean portOk = false;
        block5: for (int i = 0; i < 32; ++i) {
            char ch = eduid.charAt(i);
            if ("0123456789abcdefABCDEF".indexOf(ch) == -1) {
                return false;
            }
            switch (iSection) {
                case 1: {
                    if (i < 0 || i > 7) continue block5;
                    if (7 == i) {
                        iSection = 2;
                    }
                    if (ch == '0') continue block5;
                    timeStampOk = true;
                    iSection = 2;
                    continue block5;
                }
                case 2: {
                    if (i < 16 || i > 23) continue block5;
                    if (23 == i) {
                        iSection = 3;
                    }
                    if (ch == '0') continue block5;
                    IPOk = true;
                    iSection = 3;
                    continue block5;
                }
                case 3: {
                    if (i < 24 || i > 27) continue block5;
                    if (27 == i) {
                        iSection = 3;
                    }
                    if (ch == '0') continue block5;
                    portOk = true;
                    iSection = 4;
                    continue block5;
                }
            }
        }
        return timeStampOk && IPOk && portOk;
    }

    public void initialVariablesPosted(IRuntimeSession session, boolean isMainApplication) {
        boolean hasChannel;
        String eduid;
        boolean eduInUUI = false;
        if (!isMainApplication) {
            return;
        }
        SCESession mySession = (SCESession)session;
        if (mySession.isRunmodule()) {
            throw new IllegalStateException("ICC Connector init was called in a module.");
        }
        IVariableField VDUfield = mySession.getVariableField("vdu", "id");
        if (VDUfield == null) {
            throw new IllegalStateException("ICC connector init was called but project variables do not exist!");
        }
        String eduId = "";
        IVariable shareduui = mySession.getVariable("shareduui");
        IVariableField sharedMode = mySession.getVariableField("session", "sharedmode");
        if (sharedMode != null && sharedMode.getStringValue().equalsIgnoreCase("shared")) {
            IVariableField value = mySession.getVariableField(new VariableName("shareduui", "value"));
            if (shareduui.isCollection()) {
                shareduui.getCollection().reset();
                while (shareduui.getCollection().hasMore()) {
                    shareduui.getCollection().next();
                    eduId = eduId + value.getStringValue();
                }
            } else {
                eduId = value.getStringValue();
            }
        } else {
            IVariableField UUI = mySession.getVariableField("session", "uui");
            if (UUI != null) {
                eduId = UUI.getStringValue();
            }
        }
        if (eduId.length() >= 38 && this.isEDUID(eduid = eduId.substring(6, 38))) {
            IVariableField field = mySession.getVariableField("vdu", "id");
            if (field != null) {
                field.setValue(eduid);
            }
            if ((field = mySession.getVariableField("vdu_cache", "id")) != null) {
                field.setValue(eduid);
            }
            eduInUUI = true;
        }
        IVariableField channel = mySession.getVariableField("session", "channel");
        IVariableField sipcallid = mySession.getVariableField("_sipcallid");
        IVariableField newCallPlaced = mySession.getVariableField(new VariableName("NewCallPlaced"));
        boolean hasSip = sipcallid != null && sipcallid.getStringValue().length() > 0 && !sipcallid.getStringValue().equalsIgnoreCase("unknown");
        boolean bl = hasChannel = channel != null && channel.getStringValue().length() > 0;
        if ((hasSip || hasChannel) && newCallPlaced == null) {
            IVariable vduVariable;
            IVariable ncp = SimpleVariable.createSimpleVariable((String)"NewCallPlaced", (boolean)false, null, (SCESession)mySession, (boolean)false, (boolean)false);
            mySession.putVariable(ncp);
            try {
                Debugging call;
                String useVOX = mySession.getParameter("sage.ic.useVOX");
                if (useVOX == null || useVOX.equalsIgnoreCase("true")) {
                    if (!eduInUUI) {
                        call = new NewCall();
                        call.executeCommand(mySession);
                    }
                } else if (!eduInUUI) {
                    call = new com.avaya.sce.runtime.connectivity.ic.web.NewCall();
                    call.executeCommand(mySession);
                }
            }
            catch (SCERuntimeException e) {
                CaptureException ce = new CaptureException((Throwable)e);
                ce.evaluate((IRuntimeSession)mySession);
                throw e;
            }
            finally {
                ncp.getSimpleVariable().setValue(true);
            }
            if ((vduVariable = mySession.getVariable("vdu")) != null) {
                String[] fields = vduVariable.getComplexVariable().getFieldNames();
                for (int i = 0; i < fields.length; ++i) {
                    VDUVariableField field = (VDUVariableField)vduVariable.getComplexVariable().getField(fields[i]);
                    if (fields[i].compareTo("id") == 0) continue;
                    field.InitializeValue();
                }
            }
        } else {
            session.getTraceOutput().writeln(3, "IC connector init - No SIP call ID or channel found in session data");
        }
    }

    public void sentApplicationExit(IRuntimeSession session) {
        String useVOX = session.getParameter("sage.ic.useVOX");
        if (useVOX != null && useVOX.equalsIgnoreCase("false")) {
            return;
        }
        SCESession mySession = (SCESession)session;
        try {
            IVariableField VDUfield = session.getVariableField("vdu", "id");
            if (VDUfield == null) {
                throw new IllegalStateException("ICC connector sentApplicationExit was called but VDU variable does not exist!");
            }
            String VDUID = VDUfield.getStringValue();
            CallGone cg = new CallGone(VDUID);
            cg.executeCommand(mySession);
        }
        catch (SCERuntimeException e) {
            CaptureException ce = new CaptureException((Throwable)e);
            ce.evaluate((IRuntimeSession)mySession);
        }
    }

    public void applicationReentered(IRuntimeSession session) {
        IVariableField VDUfield = session.getVariableField("vdu", "id");
        if (VDUfield != null && session.isTraceEnabled()) {
            session.getTraceOutput().writeln(3, "IC connector has already issued CallGone command, but application has been re-entered.  VDUID: " + VDUfield.getStringValue());
        }
    }
}

