/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic.web;

import com.avaya.sce.runtime.connectivity.ic.web.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class TransferCall
extends ICCommand {
    private static final String CALLTRANSFER_CMD = "Transfer";
    private static final String ERROR_PREAMBLE = "ICTransferCall:";
    String destination;
    String vdu_Id;
    boolean isVariable;

    public TransferCall(String destination, boolean isVariable) {
        this.destination = destination;
        this.isVariable = isVariable;
    }

    protected String getCommand() {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            if (this.vdu_Id.length() > 0) {
                String value;
                if (this.isVariable) {
                    VariableName varName = new VariableName(this.destination);
                    IVariableField destinationVar = this.session.getVariableField(varName);
                    if (destinationVar == null) {
                        this.setError("variable: " + this.destination + " does not exist");
                    }
                    if ((value = destinationVar.getStringValue()) == null) {
                        this.setError("variable: " + this.destination + " is not set");
                    }
                } else {
                    value = this.destination;
                }
                try {
                    return new String("&cmdType=" + URLEncoder.encode(CALLTRANSFER_CMD, "UTF-8") + "&vdu_id=" + URLEncoder.encode(this.vdu_Id, "UTF-8") + "&transferExt=" + URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    this.setError("Transfer Call command format incorrect");
                    return "";
                }
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        return null;
    }
}

