/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;

public class GrammarFinder
extends ResourceFinder {
    public static final String TYPE = "GRAMMAR";

    public static GrammarFinder getGrammarFinder(String language) {
        return (GrammarFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static IRuntimeGrammar load(String name, String language) {
        IRuntimeGrammar grammar = null;
        if (name != null) {
            try {
                grammar = (IRuntimeGrammar)GrammarFinder.getGrammarFinder(language).getInstance(name);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating grammar", e);
            }
        }
        return grammar;
    }

    public static boolean veryExists(String name, String language, SCESession session) throws Exception {
        return GrammarFinder.getGrammarFinder(language).verify(name);
    }

    public GrammarFinder(String appLanguage) {
        super(appLanguage);
    }

    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("grammars");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("grammars");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

