/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti;

import com.avaya.sce.runtime.connectivity.cti.desktop.CallInfo;
import com.avaya.sce.runtime.connectivity.cti.desktop.CallInfoInitialCall;
import com.avaya.sce.runtime.connectivity.cti.desktop.Conference;
import com.avaya.sce.runtime.connectivity.cti.desktop.Dial;
import com.avaya.sce.runtime.connectivity.cti.ir.BlindCall;
import com.avaya.sce.runtime.connectivity.cti.ir.CTIEnd;
import com.avaya.sce.runtime.connectivity.cti.ir.ConferenceParty;
import com.avaya.sce.runtime.connectivity.cti.ir.ConsultationCall;
import com.avaya.sce.runtime.connectivity.cti.ir.Disconnect;
import com.avaya.sce.runtime.connectivity.cti.ir.Hold;
import com.avaya.sce.runtime.connectivity.cti.ir.RemoveConferenceParty;
import com.avaya.sce.runtime.connectivity.cti.ir.Retrieve;
import com.avaya.sce.runtime.connectivity.cti.ir.SetDisconnectUUIConference;
import com.avaya.sce.runtime.connectivity.cti.ir.Transfer;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.SCESession;

public final class CTIOpFactory {
    private CTIOpFactory() {
    }

    private static boolean isDesktop(SCESession session) {
        String platform;
        PlatformSettings settings = session.getPlatformSettings();
        if (settings != null && (platform = settings.getPlatform()) != null) {
            return platform.equals("Desktop");
        }
        return true;
    }

    public static IExecutable createCallInfoInitialCallOperation(SCESession session) {
        if (CTIOpFactory.isDesktop(session)) {
            return new CallInfoInitialCall(session);
        }
        return new com.avaya.sce.runtime.connectivity.cti.ir.CallInfoInitialCall(session);
    }

    public static IExecutable createCallInfoOperation(String name, SCESession session, Object callId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new CallInfo(name, session, callId);
        }
        return new com.avaya.sce.runtime.connectivity.cti.ir.CallInfo(name, session, callId);
    }

    public static IExecutable createDialOperation(String name, SCESession session, Object address, Object heldCall, Object uui, boolean uuiAsAscii, Object ringMax) {
        if (CTIOpFactory.isDesktop(session)) {
            return new Dial(name, session, address, heldCall, uui, uuiAsAscii);
        }
        return new com.avaya.sce.runtime.connectivity.cti.ir.Dial(name, session, address, heldCall, uui, uuiAsAscii, ringMax);
    }

    public static IExecutable createBlindCallOperation(String name, SCESession session, Object heldCallAddress, Object dialCallAddress, Object uui, boolean uuiAsAscii) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.BlindCall(name, session, heldCallAddress, dialCallAddress, uui, uuiAsAscii);
        }
        return new BlindCall(name, session, heldCallAddress, dialCallAddress, uui, uuiAsAscii);
    }

    public static IExecutable createConsultationCallOperation(String name, SCESession session, Object heldCallAddress, Object dialCallAddress, Object uui, boolean uuiAsAscii, Object ringMax, boolean transferOnRing) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.ConsultationCall(name, session, heldCallAddress, dialCallAddress, uui, uuiAsAscii, transferOnRing);
        }
        return new ConsultationCall(name, session, heldCallAddress, dialCallAddress, uui, uuiAsAscii, ringMax, transferOnRing);
    }

    public static IExecutable createHoldOperation(SCESession session, Object callId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.Hold(session, callId);
        }
        return new Hold(session, callId);
    }

    public static IExecutable createConferenceOperation(SCESession session, Object heldCallId, Object activeCallId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new Conference(session, heldCallId, activeCallId);
        }
        return new com.avaya.sce.runtime.connectivity.cti.ir.Conference(session, heldCallId, activeCallId);
    }

    public static IExecutable addConferencePartyOperation(SCESession session, Object conferenceCallId, Object partyNumber) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.ConferenceParty(session, conferenceCallId, partyNumber);
        }
        return new ConferenceParty(session, conferenceCallId, partyNumber);
    }

    public static IExecutable removeConferencePartyOperation(SCESession session, Object conferenceCallId, Object partyNumber) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.RemoveConferenceParty(session, conferenceCallId, partyNumber);
        }
        return new RemoveConferenceParty(session, conferenceCallId, partyNumber);
    }

    public static IExecutable setDisconnectUUIConferenceOperation(SCESession session, Object conferenceCallId, Object uui, boolean uuiAsAscii) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.SetDisconnectUUIConference(session, conferenceCallId, uui, uuiAsAscii);
        }
        return new SetDisconnectUUIConference(session, conferenceCallId, uui, uuiAsAscii);
    }

    public static IExecutable createTransferOperation(SCESession session, Object heldCallId, Object activeCallId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.Transfer(session, heldCallId, activeCallId);
        }
        return new Transfer(session, heldCallId, activeCallId);
    }

    public static IExecutable createDisconnectOperation(SCESession session, Object callId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.Disconnect(session, callId);
        }
        return new Disconnect(session, callId);
    }

    public static IExecutable createRetrieveOperation(SCESession session, Object callId) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.Retrieve(session, callId);
        }
        return new Retrieve(session, callId);
    }

    public static IExecutable createCTIEndOperation(SCESession session, String extension, String callid) {
        if (CTIOpFactory.isDesktop(session)) {
            return new com.avaya.sce.runtime.connectivity.cti.desktop.CTIEnd(session, extension);
        }
        return new CTIEnd(session, extension, callid);
    }
}

