/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti;

import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.VariableName;

public class VariableUtil {
    public static String getVariableValue(IRuntimeSession session, VariableName varName) {
        IVariable var = session.getVariable(varName.toString());
        if (var == null) {
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)3, (String)("VariableUtil.getVariableValue: No session variable with name " + varName + " exists"));
            return "";
        }
        String value = "";
        if (var.isSimpleVariable()) {
            value = var.getSimpleVariable().getStringValue();
        } else {
            IVariableField varField = var.getComplexVariable().getField(varName.getFieldName());
            if (varField != null) {
                value = varField.getStringValue();
            } else {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)3, (String)("VariableUtil.getVariableValue: No complex variable field named " + varName + " exists"));
            }
        }
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("VariableUtil.getVariableValue: Variable value is " + value));
        return value;
    }

    public static IVariableField getSessionVariable(IRuntimeSession session, String name) {
        IVariableField varField = session.getVariableField("session", name);
        if (varField == null) {
            session.throwRTException("ExtensionProvider.getExtension: Unable to get session variable named " + name);
        }
        return varField;
    }
}

