/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.Action;
import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.PromptInfo;
import com.avaya.sce.runtime.PromptRefInfo;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.perf.Performance;
import com.avaya.sce.runtimecommon.SCESession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Event
implements IGenerator {
    protected PromptRefInfo[] promptNames;
    protected Action action;
    protected String[] type;

    public Event(String type, PromptRefInfo promptName, Action action) {
        this(new String[]{type}, promptName, action);
    }

    public Event(String[] type, PromptRefInfo promptName, Action action) {
        this(type, new PromptRefInfo[]{promptName}, action);
    }

    public Event(String type, PromptRefInfo[] promptNames, Action action) {
        this(new String[]{type}, promptNames, action);
    }

    public Event(String[] type, PromptRefInfo[] promptNames, Action action) {
        if (promptNames != null && promptNames.length > 0 && promptNames[0] != null) {
            this.promptNames = promptNames;
        }
        this.action = action;
        this.type = type;
        this.setAction(action);
    }

    private void genAction(IOutputGenerator generator, int count, Action action) {
        if (action != null) {
            if (count == action.getCount(generator.getMySession()) || action.getCount(generator.getMySession()) == 0) {
                action.generate(generator);
            } else {
                generator.eventMiddle(this);
            }
        } else {
            generator.eventMiddle(this);
        }
    }

    private boolean isSingle(Collection<IRuntimePrompt> prompts) {
        for (IRuntimePrompt prompt : prompts) {
            Collection counts = prompt.getLevelNumbers();
            if (counts.size() != 1) {
                return false;
            }
            Iterator iter = counts.iterator();
            Integer count = (Integer)iter.next();
            if (count == 1) continue;
            return false;
        }
        return true;
    }

    private Collection<Integer> getUniqueLevelList(Collection<IRuntimePrompt> prompts, Integer threshold) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        if (threshold != null) {
            map.put(threshold, threshold);
        }
        for (IRuntimePrompt prompt : prompts) {
            Collection counts = prompt.getLevelNumbers();
            for (Integer count : counts) {
                map.put(count, count);
            }
        }
        return map.keySet();
    }

    private Collection<PromptInfo> getPromptInfoForLevel(Collection<IRuntimePrompt> prompts, int levelNum) {
        ArrayList<PromptInfo> result = new ArrayList<PromptInfo>();
        for (IRuntimePrompt prompt : prompts) {
            Integer level;
            Collection levels = prompt.getLevelNumbers();
            int last = -1;
            Iterator i$ = levels.iterator();
            while (i$.hasNext() && (level = (Integer)i$.next()) <= levelNum) {
                last = level;
            }
            if (last == -1) continue;
            result.add(new PromptInfo(last, prompt));
        }
        return result;
    }

    @Override
    public void generate(IOutputGenerator generator) {
        Collection<PromptInfo> promptInfo;
        ArrayList<IRuntimePrompt> prompts = null;
        if (this.promptNames != null) {
            prompts = new ArrayList<IRuntimePrompt>();
            for (PromptRefInfo promptInfo2 : this.promptNames) {
                String promptName = promptInfo2.getName();
                String language = promptInfo2.getLanguage();
                IRuntimePrompt prompt = PromptFinder.load(promptName, language, generator.getMySession());
                long start = System.currentTimeMillis();
                prompt.updatePrompt(generator.getMySession());
                long stop = System.currentTimeMillis();
                Performance.update("_avaya-update-prompt|Update Prompt", stop - start, generator.getMySession().getServlet().getServletName());
                prompts.add(prompt);
            }
        }
        if (prompts != null && this.action == null) {
            boolean isSingle = this.isSingle(prompts);
            Collection<Integer> uniquePromptLevels = this.getUniqueLevelList(prompts, null);
            for (Integer promptLevelNum : uniquePromptLevels) {
                generator.eventBegin(this, promptLevelNum, isSingle);
                promptInfo = this.getPromptInfoForLevel(prompts, promptLevelNum);
                for (PromptInfo info : promptInfo) {
                    generator.promptMiddle(info.getPrompt(), info.getPromptLevel(), isSingle, true);
                }
                this.genAction(generator, promptLevelNum, this.action);
                generator.eventEnd(this);
            }
        }
        if (prompts == null && this.action != null) {
            int threshold = this.action.getCount(generator.getMySession());
            HashMap<String, String> eventInfo = (HashMap<String, String>)generator.getMySession().getProperty("___sageeventinfo");
            if (eventInfo == null) {
                eventInfo = new HashMap<String, String>();
                generator.getMySession().setProperty("___sageeventinfo", eventInfo);
            }
            if (threshold <= 1) {
                if (threshold == 1 || threshold == 0) {
                    eventInfo.put(this.getType(), "1");
                }
                boolean alwaysActive = threshold == 0;
                generator.eventBegin(this, threshold, alwaysActive);
                this.genAction(generator, threshold, this.action);
                generator.eventEnd(this);
            } else {
                ArrayList<Integer> actionLevels = new ArrayList<Integer>();
                if (eventInfo.get(this.getType()) != null) {
                    actionLevels.add(new Integer(threshold));
                } else {
                    actionLevels.add(new Integer(1));
                    actionLevels.add(new Integer(threshold));
                }
                for (Integer levelNumber : actionLevels) {
                    generator.eventBegin(this, levelNumber, false);
                    this.genAction(generator, levelNumber, this.action);
                    generator.eventEnd(this);
                }
            }
        }
        if (prompts != null && this.action != null) {
            int threshold = this.action.getCount(generator.getMySession());
            if (threshold <= 1) {
                Collection<Integer> uniquePromptLevels = this.getUniqueLevelList(prompts, null);
                boolean isSingle = this.isSingle(prompts);
                for (Integer promptLevelNum : uniquePromptLevels) {
                    generator.eventBegin(this, promptLevelNum, isSingle);
                    Collection<PromptInfo> promptInfo3 = this.getPromptInfoForLevel(prompts, promptLevelNum);
                    for (PromptInfo info : promptInfo3) {
                        generator.promptMiddle(info.getPrompt(), info.getPromptLevel(), isSingle, true);
                    }
                    this.genAction(generator, promptLevelNum, this.action);
                    generator.eventEnd(this);
                }
            } else {
                Collection<Integer> uniquePromptLevels = this.getUniqueLevelList(prompts, threshold);
                for (Integer promptLevelNum : uniquePromptLevels) {
                    generator.eventBegin(this, promptLevelNum, false);
                    promptInfo = this.getPromptInfoForLevel(prompts, promptLevelNum);
                    for (PromptInfo info : promptInfo) {
                        generator.promptMiddle(info.getPrompt(), info.getPromptLevel(), false, true);
                    }
                    this.genAction(generator, promptLevelNum, this.action);
                    generator.eventEnd(this);
                }
            }
        }
        if (prompts == null && this.action == null) {
            int threshold = 0;
            boolean alwaysActive = true;
            generator.eventBegin(this, threshold, alwaysActive);
            this.genAction(generator, threshold, this.action);
            generator.eventEnd(this);
        }
    }

    public String getType() {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (String value : this.type) {
            if (first) {
                buf.append(value);
                first = false;
                continue;
            }
            buf.append(" ");
            buf.append(value);
        }
        return buf.toString();
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
        if (action != null) {
            action.setEvent(this);
        }
    }

    public String getPromptName() {
        if (this.promptNames != null) {
            return this.promptNames[0].getName();
        }
        return null;
    }

    public void setPromptName(String promptName) {
        this.promptNames = new PromptRefInfo[]{new PromptRefInfo(promptName, "")};
    }

    public void setPromptNames(PromptRefInfo[] promptNames) {
        this.promptNames = promptNames;
    }

    public PromptRefInfo[] getPromptNames() {
        return this.promptNames;
    }

    public void addType(String value) {
        String[] newTypes = new String[this.type.length + 1];
        for (int i = 0; i < this.type.length; ++i) {
            newTypes[i] = this.type[i];
        }
        this.type = newTypes;
        this.type[this.type.length - 1] = value;
    }

    public void setType(String type) {
        this.setType(new String[]{type});
    }

    public void setType(String[] type) {
        this.type = type;
    }

    public static void updateForThresholdOne(Collection<Event> events, SCESession mySession) {
        HashMap<String, String> eventInfo = (HashMap<String, String>)mySession.getProperty("___sageeventinfo");
        if (eventInfo == null) {
            eventInfo = new HashMap<String, String>();
            mySession.setProperty("___sageeventinfo", eventInfo);
        }
        for (Event event : events) {
            int count;
            if (event.getAction() == null || (count = event.getAction().getCount(mySession)) != 1 && count != 0) continue;
            eventInfo.put(event.getType(), "1");
        }
    }
}

