/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.VariableName;

public class Assign
extends AssignmentOperation {
    String destName;
    String sourceName;
    boolean sourceIsConstant;

    public Assign(String destName, String sourceName, boolean sourceIsConstant) {
        this.destName = destName;
        this.sourceName = sourceName;
        this.sourceIsConstant = sourceIsConstant;
    }

    public void evaluate(IRuntimeSession mySession) {
        VariableName destVarName = new VariableName(this.destName);
        IVariable destVar = mySession.getVariable(destVarName.getVarName());
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Assigning [" + this.sourceName + "] to [" + this.destName + "]");
        }
        if (this.sourceIsConstant) {
            IVariableField destField = mySession.getVariableField(destVarName);
            destField.setValue(this.sourceName);
        } else {
            VariableName sourceVarName = new VariableName(this.sourceName);
            IVariable sourceVar = mySession.getVariable(sourceVarName.getVarName());
            if (sourceVar.isComplexVariable() && sourceVarName.getFieldName() == null && destVar.isComplexVariable() && destVarName.getFieldName() == null) {
                IComplexVariable complex = sourceVar.getComplexVariable();
                String[] fieldNames = complex.getFieldNames();
                for (int i = 0; i < fieldNames.length; ++i) {
                    IVariableField destField = mySession.getVariableField(destVarName.getVarName(), fieldNames[i]);
                    destField.setValue(this.getStringValue(mySession, new VariableName(sourceVarName.getVarName(), fieldNames[i])));
                }
            } else {
                if (destVar.isComplexVariable() && destVarName.getFieldName() == null) {
                    mySession.throwRTException("Incompatible assignment between " + sourceVarName + " and " + destVarName);
                }
                if (sourceVar.isComplexVariable() && sourceVarName.getFieldName() == null) {
                    mySession.throwRTException("Incompatible assignment between " + sourceVarName + " and " + destVarName);
                }
                IVariableField destField = mySession.getVariableField(destVarName);
                destField.setValue(this.getObjectValue(mySession, sourceVarName));
            }
        }
    }
}

