/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.vp.admin.variables.runtime;

import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.vp.admin.variables.runtime.IClientProxy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimulatorClientProxy
implements IClientProxy {
    private IRuntimeSession session;
    private static final String HOST = "localhost";
    public static final int DEFAULT_PORT = 7000;
    public static final String REQ_COMMAND = "giveme_app_variables";
    public static final String BYE = "bye";

    public SimulatorClientProxy(IRuntimeSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, String> getParams(String appName) {
        HashMap<String, String> data = new HashMap<String, String>();
        Socket client = null;
        try {
            client = new Socket(HOST, 7000);
            PrintWriter out = new PrintWriter(client.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream(), "UTF-8"));
            out.println(REQ_COMMAND);
            String nameValue = "";
            while ((nameValue = in.readLine()) != null && !nameValue.equals(BYE)) {
                String[] pair = nameValue.split("\\|");
                if (pair.length > 1) {
                    LoggerUtil.writeTrace((IRuntimeSession)this.session, (int)1, (String)(pair[0] + "=>" + pair[1]));
                    data.put(pair[0], pair[1]);
                    continue;
                }
                if (pair.length != 1) continue;
                LoggerUtil.writeTrace((IRuntimeSession)this.session, (int)1, (String)(pair[0] + "=>"));
                data.put(pair[0], "");
            }
        }
        catch (Exception e) {
            LoggerUtil.writeTrace((IRuntimeSession)this.session, (int)3, (String)("Problem simulating CAV values (" + e.getMessage() + "); default values will be used."));
        }
        finally {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (IOException e) {}
        }
        return data;
    }

    @Override
    public String getType(String paramName) {
        return null;
    }
}

