/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.cti.ir;

import com.avaya.sce.runtime.connectivity.cti.CallInfoData;
import com.avaya.sce.runtime.connectivity.cti.VariableUtil;
import com.avaya.sce.runtime.connectivity.cti.ir.CTICommand;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class CallInfo
extends CTICommand {
    String varName;
    VariableName callIdVariable;

    public CallInfo(String varName, SCESession session, Object callIdVariable) {
        super(session);
        this.varName = varName;
        if (callIdVariable == null) {
            return;
        }
        if (!(callIdVariable instanceof VariableName)) {
            throw new IllegalArgumentException("Illegal callId type " + callIdVariable.getClass().getName());
        }
        this.callIdVariable = (VariableName)callIdVariable;
    }

    public void processResponse(String rawResponse) {
        CallInfoData cid = this.processCallInfoResults(rawResponse);
        if (cid != null) {
            LoggerUtil.writeTrace((IRuntimeSession)this.getSession(), (int)1, (String)"CallInfo.doGetCallInfo: Populating call info variable values...");
            this.setCallInfoVariableValues(this.varName, cid);
        }
    }

    public String getServletNameParams() {
        try {
            if (this.isIR()) {
                return "/aesconnector/CallInfo?" + URLEncoder.encode("callid=" + this.getCallId(), "UTF-8") + URLEncoder.encode("&channel=" + this.getExtensionFromSession(), "UTF-8");
            }
            return "/aesconnector/CallInfo?" + URLEncoder.encode("callid=" + this.getCallId(), "UTF-8") + URLEncoder.encode("&extension=" + this.getExtensionFromSession(), "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }

    protected String getCallId() {
        VariableName vName = new VariableName(this.callIdVariable.toString(), "callid");
        String callId = VariableUtil.getVariableValue((IRuntimeSession)this.getSession(), vName);
        if (callId != null && callId.length() > 0) {
            return callId;
        }
        this.session.throwRTException("No valid call id in CTI CallInfo operation");
        return null;
    }
}

