/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.internal.PhraseFinder;
import com.avaya.sce.runtime.internal.PhrasesetFinder;
import com.avaya.sce.runtimecommon.SCESession;
import java.net.URL;

public class Phrase
implements IGenerator,
Cloneable {
    static final boolean ENABLE_SANITY_CHECKS = true;
    private String fileName;
    private String text;
    private Type type = Type.STANDALONE;
    protected SCESession mySession;
    private String language;

    public final void generate(IOutputGenerator generator) {
        if (this.mySession != null && this.mySession != generator.getMySession()) {
            throw new IllegalStateException("Sanity check failure!  Session should be the same as the output generator session.");
        }
        this.mySession = generator.getMySession();
        generator.phraseBegin(this);
        generator.phraseEnd(this);
    }

    public final void generateAsMedia(IOutputGenerator generator) {
        if (this.mySession != null && this.mySession != generator.getMySession()) {
            throw new IllegalStateException("Sanity check failure!  Session should be the same as the output generator session.");
        }
        this.mySession = generator.getMySession();
        generator.audioMediaPhraseBegin(this);
        generator.audioMediaPhraseEnd(this);
    }

    public String getURL() {
        if (this.language == null) {
            this.language = this.mySession.getCurrentLanguage();
        }
        String name = this.type == Type.STANDALONE ? PhraseFinder.getPhraseFinder(this.language).resolveResourceName(this.getFileName()) : PhrasesetFinder.getPhrasesetFinder(this.language).resolveResourceName(this.getFileName());
        URL url = this.mySession.getFileURL(name);
        return url.toString();
    }

    public String getText() {
        return this.text;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public final void setText(String text) {
        this.text = text;
    }

    public final void setType(Type type) {
        this.type = type;
    }

    public final Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public SCESession getMySession() {
        return this.mySession;
    }

    protected Object clone() throws CloneNotSupportedException {
        Phrase clone = (Phrase)super.clone();
        clone.mySession = null;
        return clone;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        STANDALONE,
        PHRASESET_PHRASE,
        MMF;

    }
}

