/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Phraseset;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;

public class PhrasesetFinder
extends ResourceFinder {
    public static final String TYPE = "PHRASESET";

    public static PhrasesetFinder getPhrasesetFinder(String language) {
        return (PhrasesetFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Phraseset load(String name, String language) {
        Phraseset phraseset = null;
        if (name != null) {
            try {
                phraseset = (Phraseset)PhrasesetFinder.getPhrasesetFinder(language).getInstance(name);
                phraseset.setLanguage(language);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating phraseset", e);
            }
        }
        return phraseset;
    }

    public PhrasesetFinder(String appLanguage) {
        super(appLanguage);
    }

    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("phrasesets");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/");
        itemName.append("data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("phrases");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

