/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.StringTokenizer;

public class Alarm
extends ICCommand {
    private static final String VOX_ALARM_CMD = "VOX.alarm";
    private static final String ERROR_PREAMBLE = "ICAlarm:";
    String alarmName;
    String alarmType;
    String alarmDescription;
    boolean isDescVar;

    public Alarm(String alarmName, String alarmDescription, boolean isDescVar, String alarmType) {
        this.alarmName = alarmName;
        this.alarmType = alarmType;
        this.alarmDescription = alarmDescription;
        this.isDescVar = isDescVar;
    }

    protected String getCommand(String reqID) {
        String value = this.alarmDescription;
        if (this.isDescVar) {
            VariableName varName = new VariableName(this.alarmDescription);
            IVariableField destinationVar = this.session.getVariableField(varName);
            if (destinationVar == null) {
                this.setError("variable: " + this.alarmDescription + " does not exist");
            }
            if ((value = destinationVar.getStringValue()) == null) {
                this.setError("variable: " + this.alarmDescription + " is not set");
            }
        }
        return new String("[VOX.alarm(\"" + this.alarmName + "\",\"" + this.alarmType + "\",\"" + value + "\")][" + reqID + "]");
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        String retAlarmName;
        String error = "";
        StringTokenizer st = new StringTokenizer(response, "[(,)]");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        if ((retAlarmName = error.replaceAll("\"", "")).compareTo(this.alarmName) != 0) {
            this.setError(error.replaceAll("\"", ""));
        }
        return null;
    }
}

