/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.StringTokenizer;

public class GetVox
extends ICCommand {
    private static final String VOX_GETVOX_CMD = "VOX.getvox";
    private static final String ERROR_PREAMBLE = "ICGetVox:";
    String name;
    String VDUID;

    public GetVox(String name) {
        this.name = name;
    }

    protected String getCommand(String reqID) {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.VDUID = field.getStringValue();
            if (this.VDUID.length() > 0) {
                return new String("[VOX.getvox(\"" + this.VDUID + "\",\"" + this.convertVariableToICFormat(this.name) + "\")][" + reqID + "]");
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        String error = "";
        StringTokenizer st = new StringTokenizer(response, "(,)", true);
        if (st.hasMoreTokens()) {
            st.nextToken();
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        if (!error.equals(",")) {
            this.setError(error);
        }
        String value = "";
        if (st.hasMoreTokens()) {
            st.nextToken();
            st.nextToken();
            st.nextToken();
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            value = st.nextToken();
            while (!value.endsWith("\"")) {
                value = value + st.nextToken();
            }
        }
        return value.replaceAll("\"", "");
    }
}

