/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetVDU
extends ICCommand {
    private static final String VOX_SETVDU_CMD = "VOX.setvdu";
    private static final String ERROR_PREAMBLE = "ICSetVDU:";
    List<String> names;
    String value = null;
    String vdu_Id;

    public SetVDU(String name, String value) {
        this.names = new ArrayList<String>();
        this.names.add(name);
        this.value = value;
    }

    public SetVDU(List<String> names) {
        this.names = names;
    }

    @Override
    protected String getCommand(String reqID) {
        StringBuffer sb = null;
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            if (this.vdu_Id.length() > 0) {
                sb = new StringBuffer("[VOX.setvdu(\"" + this.vdu_Id + "\"");
                for (String name : this.names) {
                    IVariableField cachedField = this.session.getVariableField("vdu_cache", name);
                    if (this.value != null) {
                        sb.append(",\"" + this.convertVariableToICFormat(name) + "\"," + "\"" + this.value + "\")][" + reqID + "]");
                        if (cachedField != null) {
                            cachedField.setValue(this.value);
                        }
                        return sb.toString();
                    }
                    sb.append(",\"" + this.convertVariableToICFormat(name) + "\",\"" + cachedField.getStringValue() + "\"");
                }
                sb.append(")][" + reqID + "]");
                return sb.toString();
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    @Override
    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    @Override
    protected Object parseResponse(String response) throws SCERuntimeException {
        String error;
        String retVDU_ID;
        StringTokenizer st = new StringTokenizer(response, "[(,)]");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if ((retVDU_ID = (error = st.nextToken()).replaceAll("\"", "")).compareTo(this.vdu_Id) != 0) {
            this.setError(error);
        }
        return null;
    }
}

