/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic;

import com.avaya.sce.runtime.connectivity.ic.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.StringTokenizer;

public class TransferCall
extends ICCommand {
    private static final String VOX_CALLTRANSFER_CMD = "VOX.transfer";
    private static final String ERROR_PREAMBLE = "ICTransferCall:";
    String destination;
    String vdu_Id;
    boolean isVariable;

    public TransferCall(String destination, boolean isVariable) {
        this.destination = destination;
        this.isVariable = isVariable;
    }

    protected String getCommand(String reqID) {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            if (this.vdu_Id.length() > 0) {
                String value;
                if (this.isVariable) {
                    VariableName varName = new VariableName(this.destination);
                    IVariableField destinationVar = this.session.getVariableField(varName);
                    if (destinationVar == null) {
                        this.setError("variable: " + this.destination + " does not exist");
                    }
                    if ((value = destinationVar.getStringValue()) == null) {
                        this.setError("variable: " + this.destination + " is not set");
                    }
                } else {
                    value = this.destination;
                }
                return new String("[VOX.transfer(\"" + this.vdu_Id + "\",\"" + value + "\")][" + reqID + "]");
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        String retVDU_id;
        String error = "";
        StringTokenizer st = new StringTokenizer(response, "[(,)]");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        if (st.hasMoreTokens()) {
            error = st.nextToken();
        }
        if ((retVDU_id = error.replaceAll("\"", "")).compareTo(this.vdu_Id) != 0) {
            this.setError(error.replaceAll("\"", ""));
        }
        return null;
    }
}

