/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic.web;

import com.avaya.sce.runtime.connectivity.ic.web.ICCommand;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetVDU
extends ICCommand {
    private static final String GETVDU_CMD = "GetVDU";
    private static final String ERROR_PREAMBLE = "ICGetVDU:";
    List<String> names;
    String vdu_Id;

    public GetVDU(String name) {
        this.names = new ArrayList<String>();
        this.names.add(name);
    }

    public GetVDU(List<String> names) {
        this.names = names;
    }

    @Override
    protected String getCommand() {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            this.vdu_Id = field.getStringValue();
            if (this.vdu_Id.length() > 0) {
                try {
                    StringBuffer sb = new StringBuffer("&cmdType=" + URLEncoder.encode(GETVDU_CMD, "UTF-8") + "&vdu_id=" + URLEncoder.encode(this.vdu_Id, "UTF-8") + "&fields=");
                    int ctr = 0;
                    for (String name : this.names) {
                        if (ctr++ != 0) {
                            sb.append(URLEncoder.encode("|", "UTF-8"));
                        }
                        sb.append(URLEncoder.encode("\"" + this.convertVariableToICFormat(name) + "\"", "UTF-8"));
                    }
                    return sb.toString();
                }
                catch (UnsupportedEncodingException e) {
                    this.setError("GetVDU command format incorrect");
                    return "";
                }
            }
            this.setError("No VDU ID");
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    @Override
    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    private String convertVariableNameToDDFormat(String name) {
        name = name.replaceAll("\\.\\.", "__DOTDOT__");
        return name.replaceAll("\\.", "__DOT__").replaceAll("\\+", "__PLUS__").replaceAll("\\*", "__STAR__").replaceAll("\\!", "__MARK__");
    }

    @Override
    protected Object parseResponse(String response) throws SCERuntimeException {
        String subString = response.substring(response.indexOf("&field="));
        String fields = subString.substring(subString.indexOf("=") + 1);
        StringTokenizer st = new StringTokenizer(fields, ",", true);
        String retValue = "";
        String value = "";
        while (st.hasMoreTokens()) {
            IComplexVariable vduCache;
            IVariableField field;
            String nameValue = st.nextToken();
            String name = nameValue.substring(1, nameValue.indexOf("|") - 1);
            value = nameValue.substring(nameValue.indexOf("|") + 2);
            while (!value.endsWith("\"")) {
                value = value + st.nextToken();
            }
            retValue = value = value.replaceAll("\"", "");
            IVariable tmp = this.session.getVariable("vdu_cache");
            if (tmp != null && (field = (vduCache = tmp.getComplexVariable()).getField(this.convertVariableNameToDDFormat(name))) != null) {
                field.setValue(value);
            }
            if (!st.hasMoreTokens()) continue;
            st.nextToken();
        }
        return retValue;
    }
}

