/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic.web;

import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtimecommon.Debugging;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.servlet.ServletContext;

public abstract class ICCommand
extends Debugging
implements IPluggableExecutable {
    protected SCESession session = null;
    final int DEFAULT_TIMEOUT = 8000;
    private static final String ERROR_PREAMBLE = "ICCommand:";
    protected static final String CHANNEL_PROPERTY_NAME = "channel";
    private static final String ERROR_MSG = "errorMsg";

    public void execute(IRuntimeSession mySession) {
        this.executeCommand((SCESession)mySession);
    }

    public String getId() {
        return "com.avaya.sce.ic.ui.icConnector";
    }

    public String getTraceMessage() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCommand(SCESession session) throws SCERuntimeException {
        String protocol;
        String host;
        int port;
        Object response = null;
        this.session = session;
        URL srcURL = null;
        this.setLastErrorField("");
        try {
            srcURL = new URL(session.getRequestCopyURL().toString());
        }
        catch (MalformedURLException e) {
            this.setError(e.getMessage());
        }
        String localPort = session.getParameter("sage.ic.localport");
        if (localPort != null && localPort.length() > 0) {
            port = Integer.valueOf(localPort);
            host = "localhost";
            protocol = srcURL.getProtocol();
        } else {
            port = srcURL.getPort() != -1 ? srcURL.getPort() : srcURL.getDefaultPort();
            host = srcURL.getHost();
            protocol = srcURL.getProtocol();
        }
        String reqURL = port != -1 ? protocol + "://" + host + ":" + port + "/icconnector/RequestID" : protocol + "://" + host + "/icconnector/RequestID";
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("ICCommand.execute:  Talking to ICC using URL: " + reqURL));
        String reqID = null;
        InputStream inputStream = null;
        BufferedReader reader = null;
        try {
            URL urlRequestID = new URL(reqURL);
            URLConnection urlConnection = urlRequestID.openConnection();
            urlConnection.addRequestProperty("Cookie", "___DDSESSIONID=" + session.getSessionId());
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("ICCommand.execute:  setting session cookie to " + session.getSessionId()));
            urlConnection.connect();
            inputStream = urlConnection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(inputStream));
            reqID = reader.readLine();
        }
        catch (Exception e) {
            this.setError(e.getMessage());
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {}
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {}
        }
        String cmd = this.getCommand();
        if (cmd != null) {
            int errorNdx;
            String strResponse = "";
            inputStream = null;
            reader = null;
            boolean isSIP = false;
            if (session.getVariableField("session", "protocolname").getStringValue().equalsIgnoreCase("sip")) {
                isSIP = true;
            }
            try {
                String ICConnectorServerURL = port != -1 ? protocol + "://" + host + ":" + port : protocol + "://" + host;
                ICConnectorServerURL = ICConnectorServerURL + "/icconnector/ICConnectorWebServer?reqid=" + URLEncoder.encode(reqID, "UTF-8") + "&timeout=" + URLEncoder.encode(Integer.toString(this.getTimeout()), "UTF-8") + cmd + (!isSIP ? "&channel=" + URLEncoder.encode(session.getVariableField("session", CHANNEL_PROPERTY_NAME).getStringValue(), "UTF-8") : "&callid=" + URLEncoder.encode(session.getVariableField("_sipcallid").getStringValue(), "UTF-8")) + (!isSIP ? "&issip=0" : "&issip=1");
                session.getTraceOutput().writeln(2, "Sending to ICC: " + ICConnectorServerURL);
                URL url = new URL(ICConnectorServerURL);
                URLConnection urlConnection = url.openConnection();
                urlConnection.addRequestProperty("Cookie", "___DDSESSIONID=" + session.getSessionId());
                urlConnection.connect();
                inputStream = urlConnection.getInputStream();
                reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                strResponse = reader.readLine();
            }
            catch (Exception e) {
                this.setError(e.getMessage());
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {}
            }
            if (strResponse.length() == 0) {
                this.setError("Timeout waiting for VRUSM/HTTPVOX to respond");
            }
            String formattedResponse = this.formatResponse(strResponse);
            if (session.isDDTraceEnabled() && formattedResponse != null) {
                session.getTraceOutput().writeln(2, "VRUSM response: " + formattedResponse);
            }
            if ((errorNdx = formattedResponse.indexOf(ERROR_MSG)) != -1) {
                String errorMsg = formattedResponse.substring(errorNdx + (ERROR_MSG.length() + 1));
                session.getTraceOutput().writeln(2, "error in VRUSM response:" + errorMsg);
                this.setError(errorMsg);
            } else {
                response = this.parseResponse(formattedResponse);
            }
        } else {
            this.setError("Invalid command");
        }
        return response;
    }

    protected String formatCommand(String rawCommand) {
        return rawCommand.replaceAll(" ", "%20");
    }

    protected String formatResponse(String rawResponse) {
        String undecodedResponse = null;
        try {
            undecodedResponse = URLDecoder.decode(rawResponse, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        return undecodedResponse;
    }

    protected String getCommand() {
        this.session.throwRTException("must override getCommand");
        return null;
    }

    protected int getTimeout() {
        return 8000;
    }

    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    protected void setError(String text) {
        String errorText = this.getErrorPreamble() + text;
        this.setLastErrorField(errorText);
        ServletContext context = this.session.getServlet().getServletContext();
        String throwExceptions = context.getInitParameter("sage.ic.throwexceptions");
        if (throwExceptions == null || throwExceptions.length() == 0 || throwExceptions.equalsIgnoreCase("true")) {
            this.session.throwRTException(errorText);
        }
    }

    protected void setLastErrorField(String text) {
        IVariableField field = this.session.getVariableField("session", "lasterror");
        if (field != null) {
            field.setValue(text);
        }
    }

    protected Object parseResponse(String response) throws SCERuntimeException {
        this.session.throwRTException("must override ParseResponse");
        return null;
    }

    protected String convertVariableToICFormat(String variable) {
        return variable.replaceAll("__DOT__", ".").replaceAll("__DOTDOT__", "..").replaceAll("__PLUS__", "+").replaceAll("__STAR__", "*").replaceAll("__MARK__", "!");
    }
}

