/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.ic.web;

import com.avaya.sce.runtime.connectivity.ic.web.ICCommand;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InvokeWorkflow
extends ICCommand {
    private static final String WORKFLOW_TR2_CMD = "TR2";
    private static final String WORKFLOW_TR1_CMD = "TR1";
    private static final String ERROR_PREAMBLE = "ICInvokeWorkflow:";
    String workflowName;
    int timeout;
    List<String> inputs;
    List<String> outputs;
    String vdu_Id;

    public InvokeWorkflow(String workflowName, int timeout, List<String> inputs, List<String> outputs) {
        this.workflowName = workflowName;
        this.timeout = timeout;
        this.inputs = inputs;
        this.outputs = outputs;
    }

    @Override
    protected String getCommand() {
        IVariableField field = this.session.getVariableField("vdu", "id");
        if (field != null) {
            try {
                this.vdu_Id = field.getStringValue();
                String cmd = "&cmdType=" + URLEncoder.encode(WORKFLOW_TR2_CMD, "UTF-8");
                if (this.timeout == 0) {
                    cmd = "&cmdType=" + URLEncoder.encode(WORKFLOW_TR1_CMD, "UTF-8");
                }
                if (this.vdu_Id.length() > 0) {
                    cmd = cmd + "&vdu_id=" + URLEncoder.encode(this.vdu_Id, "UTF-8");
                    cmd = cmd + "&workflowName=" + URLEncoder.encode(this.workflowName, "UTF-8");
                    cmd = cmd + "&inputfields=";
                    if (this.inputs != null) {
                        int ctr = 1;
                        Iterator<String> i = this.inputs.iterator();
                        while (i.hasNext()) {
                            if (ctr != 1) {
                                cmd = cmd + ",";
                            }
                            IVariableField inputVar = this.session.getVariableField(new VariableName(i.next()));
                            cmd = cmd + URLEncoder.encode("param" + ctr++ + "|\"" + inputVar.getStringValue() + "\"", "UTF-8");
                        }
                    } else {
                        cmd = cmd + URLEncoder.encode("<none>", "UTF-8");
                    }
                    cmd = cmd + "&outputfields=";
                    if (this.outputs != null) {
                        boolean firstOne = true;
                        for (String output : this.outputs) {
                            VariableName vName;
                            String name;
                            if (!firstOne) {
                                cmd = cmd + URLEncoder.encode("|", "UTF-8");
                            }
                            if ((name = (vName = new VariableName(output)).getFieldName()) == null) {
                                name = vName.getVarName();
                            }
                            cmd = cmd + URLEncoder.encode("\"" + this.convertVariableToICFormat(name) + "\"", "UTF-8");
                            firstOne = false;
                        }
                    } else {
                        cmd = cmd + URLEncoder.encode("<none>", "UTF-8");
                    }
                    return cmd;
                }
                this.setError("No VDU ID");
            }
            catch (UnsupportedEncodingException e) {
                this.setError("InvokeWorkflow command format incorrect");
                return "";
            }
        } else {
            this.setError("IC is not enabled or no VDU variable exists.");
        }
        return null;
    }

    @Override
    protected String getErrorPreamble() {
        return ERROR_PREAMBLE;
    }

    @Override
    protected int getTimeout() {
        return this.timeout;
    }

    @Override
    protected Object parseResponse(String response) throws SCERuntimeException {
        if (this.getTimeout() == 0) {
            return null;
        }
        String subString = response.substring(response.indexOf("&field="));
        String outputFields = subString.substring(subString.indexOf("=") + 1);
        if (this.outputs != null) {
            StringTokenizer st = new StringTokenizer(outputFields, ",", true);
            while (st.hasMoreTokens()) {
                String nameValue = st.nextToken();
                String outputName = nameValue.substring(1, nameValue.indexOf("|") - 1);
                String outputValue = nameValue.substring(nameValue.indexOf("|") + 2);
                while (!outputValue.endsWith("\"")) {
                    outputValue = outputValue + st.nextToken();
                }
                outputValue = outputValue.replaceAll("\"", "");
                for (String output : this.outputs) {
                    VariableName varName = new VariableName(output);
                    String responseName = varName.getFieldName();
                    if (responseName == null) {
                        responseName = varName.getVarName();
                    }
                    if (!responseName.equalsIgnoreCase(outputName)) continue;
                    IVariableField outputVar = this.session.getVariableField(new VariableName(output));
                    outputVar.setValue(outputValue);
                    break;
                }
                if (!st.hasMoreTokens()) continue;
                st.nextToken();
            }
        }
        return null;
    }
}

