/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IBooleanOperation;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;

public class Expression
implements IBooleanOperation {
    public static final int INT_EQUAL = 1;
    public static final int INT_NOT_EQUAL = 2;
    public static final int INT_LESS_THAN = 3;
    public static final int INT_LESS_THAN_EQUAL = 4;
    public static final int INT_GREATER_THAN = 5;
    public static final int INT_GREATER_THEN_EQUAL = 6;
    public static final int STRING_EQUAL = 7;
    public static final int STRING_NOT_EQUAL = 8;
    public static final int STRING_GREATER_THAN = 9;
    public static final int STRING_LESS_THAN = 10;
    public static final int STRING_EQUAL_IGNORE = 11;
    public static final int STRING_NOT_EQUAL_IGNORE = 12;
    public static final int HAS_MORE = 13;
    public static final int HAS_NO_MORE = 14;
    public static final int IS_EMPTY = 15;
    public static final int IS_TRUE = 16;
    public static final int IS_FALSE = 17;
    public static final int IS_DIGITS = 18;
    public static final int IS_AFTER = 19;
    public static final int IS_BEFORE = 20;
    public static final int NOT_EMPTY = 21;
    public static final int IS_NULL = 22;
    public static final int HAS_PREVIOUS = 23;
    public static final int HAS_NO_PREVIOUS = 24;
    public static final int IS_COLLECTION = 25;
    private String name;
    private String variableA;
    private int operator;
    private String operand;
    private boolean operandBIsVaraible;

    public Expression(String name, String variableA, int operator, String operand, boolean operandBIsVaraible) {
        this.name = name;
        this.variableA = variableA;
        this.operator = operator;
        this.operand = operand;
        this.operandBIsVaraible = operandBIsVaraible;
    }

    public Expression(String name, String variableA, int operator, String operand) {
        this.name = name;
        this.variableA = variableA;
        this.operator = operator;
        this.operand = operand;
    }

    public Expression(String name, String variableA, int operator) {
        this.name = name;
        this.name = name;
        this.variableA = variableA;
        this.operator = operator;
    }

    private String getStringValue(String variable, boolean isVariable, IRuntimeSession mySession, boolean xlateNull) {
        if (isVariable) {
            String value;
            VariableName varName = new VariableName(variable);
            IVariableField var = mySession.getVariableField(varName);
            if (var == null) {
                mySession.throwRTException("Variable " + this.variableA + " does not exist");
            }
            if ((value = var.getStringValue()) == null) {
                value = "__DD_NULL";
            }
            if (xlateNull && value.equals("__DD_NULL")) {
                value = "";
            }
            return value;
        }
        return variable;
    }

    private double getDoubleValue(String variable, boolean isVariable, IRuntimeSession mySession) {
        if (isVariable) {
            Object valueDate;
            VariableName varName = new VariableName(variable);
            IVariableField var = mySession.getVariableField(varName);
            if (var == null) {
                mySession.throwRTException("Variable " + this.variableA + " does not exist");
            }
            if ((valueDate = var.getObjectValue()) instanceof Date) {
                return ((Date)valueDate).getTime();
            }
            String valueStr = var.getStringValue();
            if (valueStr == null) {
                valueStr = "__DD_NULL";
            }
            double value = valueStr.equals("__DD_NULL") ? 0.0 : var.getDoubleValue();
            return value;
        }
        return Double.parseDouble(variable);
    }

    private boolean getBooleanValue(String variable, IRuntimeSession mySession) {
        String valueStr;
        VariableName varName = new VariableName(variable);
        IVariableField var = mySession.getVariableField(varName);
        if (var == null) {
            mySession.throwRTException("Variable " + this.variableA + " does not exist");
        }
        if ((valueStr = var.getStringValue()) == null) {
            valueStr = "__DD_NULL";
        }
        boolean value = valueStr.equals("__DD_NULL") ? false : var.getBooleanValue();
        return value;
    }

    private boolean isAfter(String variableA, String variableB, IRuntimeSession mySession) {
        IVariable var = mySession.getVariable(variableA);
        IComplexVariable complex = var.getComplexVariable();
        String[] fields = complex.getFieldNames();
        var = mySession.getVariable(variableB);
        if (this.fieldsMatch(SCERT.DATE_FIELDS, fields)) {
            IVariableField fieldA = mySession.getVariableField(variableA, "year");
            IVariableField fieldB = mySession.getVariableField(variableB, "year");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "monthinyear");
            fieldB = mySession.getVariableField(variableB, "monthinyear");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "dayofmonth");
            fieldB = mySession.getVariableField(variableB, "dayofmonth");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "dayofyear");
            fieldB = mySession.getVariableField(variableB, "dayofyear");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
        } else {
            IVariableField fieldA = mySession.getVariableField(variableA, "hour");
            IVariableField fieldB = mySession.getVariableField(variableB, "hour");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "minute");
            fieldB = mySession.getVariableField(variableB, "minute");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "second");
            fieldB = mySession.getVariableField(variableB, "second");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "millisecond");
            fieldB = mySession.getVariableField(variableB, "millisecond");
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return false;
            }
        }
        return false;
    }

    private boolean contains(String[] list, String value) {
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean fieldsMatch(String[] varFieldsA, String[] varFieldsB) {
        int i;
        for (i = 0; i < varFieldsA.length; ++i) {
            if (this.contains(varFieldsB, varFieldsA[i])) continue;
            return false;
        }
        for (i = 0; i < varFieldsA.length; ++i) {
            if (this.contains(varFieldsA, varFieldsB[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isBefore(String variableA, String variableB, IRuntimeSession mySession) {
        IVariable var = mySession.getVariable(variableA);
        IComplexVariable complex = var.getComplexVariable();
        String[] fields = complex.getFieldNames();
        var = mySession.getVariable(variableB);
        if (this.fieldsMatch(SCERT.DATE_FIELDS, fields)) {
            IVariableField fieldA = mySession.getVariableField(variableA, "year");
            IVariableField fieldB = mySession.getVariableField(variableB, "year");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "monthinyear");
            fieldB = mySession.getVariableField(variableB, "monthinyear");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "dayofmonth");
            fieldB = mySession.getVariableField(variableB, "dayofmonth");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "dayofyear");
            fieldB = mySession.getVariableField(variableB, "dayofyear");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
        } else {
            IVariableField fieldA = mySession.getVariableField(variableA, "hour");
            IVariableField fieldB = mySession.getVariableField(variableB, "hour");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "minute");
            fieldB = mySession.getVariableField(variableB, "minute");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "second");
            fieldB = mySession.getVariableField(variableB, "second");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
            fieldA = mySession.getVariableField(variableA, "millisecond");
            fieldB = mySession.getVariableField(variableB, "millisecond");
            if (fieldA.getIntValue() < fieldB.getIntValue()) {
                return true;
            }
            if (fieldA.getIntValue() > fieldB.getIntValue()) {
                return false;
            }
        }
        return false;
    }

    public boolean evaluate(IRuntimeSession mySession) {
        block79: {
            SCESession ses = (SCESession)mySession;
            String servletName = "";
            try {
                HttpServletRequest request = ses.getRequest();
                servletName = request.getServletPath();
                int index = servletName.lastIndexOf(47);
                servletName = servletName.substring(index + 1);
            }
            catch (Exception e) {
                if (!ses.isDDTraceEnabled()) break block79;
                ses.getTraceOutput().writeln(3, "Unexpected context path [" + ses.getRequest().getContextPath() + "]");
            }
        }
        if (mySession.isTraceEnabled()) {
            StringBuffer sb = new StringBuffer();
            boolean singleOp = false;
            sb.append("[");
            sb.append(this.name);
            sb.append("] Expression [");
            sb.append(this.variableA);
            sb.append("] ");
            switch (this.operator) {
                case 1: {
                    sb.append("Numeric Equal");
                    break;
                }
                case 2: {
                    sb.append("Numeric Not Equal");
                    break;
                }
                case 3: {
                    sb.append("Numeric Less Than");
                    break;
                }
                case 4: {
                    sb.append("Numeric Less Than or Equal");
                    break;
                }
                case 5: {
                    sb.append("Numeric Greater Than");
                    break;
                }
                case 6: {
                    sb.append("Numeric Greater Than or Equal");
                    break;
                }
                case 7: {
                    sb.append("String Equal");
                    break;
                }
                case 8: {
                    sb.append("String Not Equal");
                    break;
                }
                case 9: {
                    sb.append("String Greater Than");
                    break;
                }
                case 10: {
                    sb.append("String Less Than");
                    break;
                }
                case 11: {
                    sb.append("String Equal Ignorecase");
                    break;
                }
                case 12: {
                    sb.append("String Not Equal Ignorecase");
                    break;
                }
                case 13: {
                    sb.append("Has More");
                    singleOp = true;
                    break;
                }
                case 14: {
                    sb.append("Has No More");
                    singleOp = true;
                    break;
                }
                case 15: {
                    sb.append("Is Empty");
                    singleOp = true;
                    break;
                }
                case 16: {
                    sb.append("Is True");
                    singleOp = true;
                    break;
                }
                case 17: {
                    sb.append("Is False");
                    singleOp = true;
                    break;
                }
                case 18: {
                    sb.append("Equal");
                    singleOp = true;
                    break;
                }
                case 19: {
                    sb.append("Is After");
                    break;
                }
                case 20: {
                    sb.append("Is Before");
                    break;
                }
                case 21: {
                    sb.append("Not Empty");
                    break;
                }
                case 22: {
                    sb.append("Is Null");
                    break;
                }
                case 23: {
                    sb.append("Has Previous");
                    singleOp = true;
                    break;
                }
                case 24: {
                    sb.append("Has No Previous");
                    singleOp = true;
                    break;
                }
                case 25: {
                    sb.append("Is Collection");
                    singleOp = true;
                }
            }
            if (!singleOp) {
                sb.append(" [");
                sb.append(this.operand);
                sb.append("]");
            }
            if (mySession.getTraceOutput() != null) {
                mySession.getTraceOutput().writeln(2, sb.toString());
            }
        }
        switch (this.operator) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                double doubleA = 0.0;
                double doubleB = 0.0;
                try {
                    doubleA = this.getDoubleValue(this.variableA, true, mySession);
                    doubleB = this.getDoubleValue(this.operand, this.operandBIsVaraible, mySession);
                }
                catch (Exception e) {
                    if (mySession.getTraceOutput() != null) {
                        mySession.getTraceOutput().writeln(2, "Returning false since " + e.toString());
                    }
                    return false;
                }
                switch (this.operator) {
                    case 1: {
                        return doubleA == doubleB;
                    }
                    case 2: {
                        return doubleA != doubleB;
                    }
                    case 3: {
                        return doubleA < doubleB;
                    }
                    case 4: {
                        return doubleA <= doubleB;
                    }
                    case 5: {
                        return doubleA > doubleB;
                    }
                    case 6: {
                        return doubleA >= doubleB;
                    }
                }
                return false;
            }
            case 7: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareTo(valueB) == 0;
            }
            case 8: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareTo(valueB) != 0;
            }
            case 9: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareToIgnoreCase(valueB) > 0;
            }
            case 10: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareToIgnoreCase(valueB) < 0;
            }
            case 11: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareToIgnoreCase(valueB) == 0;
            }
            case 12: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                String valueB = this.getStringValue(this.operand, this.operandBIsVaraible, mySession, true);
                return valueA.compareToIgnoreCase(valueB) != 0;
            }
            case 13: {
                IVariable var = mySession.getVariable(new VariableName(this.variableA).getVarName());
                if (var.isCollection()) {
                    return var.getCollection().hasMore();
                }
                return false;
            }
            case 14: {
                IVariable var = mySession.getVariable(new VariableName(this.variableA).getVarName());
                if (var.isCollection()) {
                    return !var.getCollection().hasMore();
                }
                return true;
            }
            case 15: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                if (valueA == null) {
                    return true;
                }
                return valueA.length() == 0;
            }
            case 21: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                if (valueA == null) {
                    return false;
                }
                return valueA.length() != 0;
            }
            case 16: {
                boolean b = false;
                try {
                    b = this.getBooleanValue(this.variableA, mySession);
                }
                catch (Exception e) {
                    if (mySession.getTraceOutput() != null) {
                        mySession.getTraceOutput().writeln(2, "Returning false since " + e.toString());
                    }
                    return false;
                }
                return true == b;
            }
            case 17: {
                boolean b = false;
                try {
                    b = this.getBooleanValue(this.variableA, mySession);
                }
                catch (Exception e) {
                    if (mySession.getTraceOutput() != null) {
                        mySession.getTraceOutput().writeln(2, "Returning false since " + e.toString());
                    }
                    return false;
                }
                return false == b;
            }
            case 18: {
                String valueA = this.getStringValue(this.variableA, true, mySession, true);
                if (valueA.length() == 0) {
                    return false;
                }
                for (int i = 0; i < valueA.length(); ++i) {
                    if (Character.isDigit(valueA.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            case 19: {
                return this.isAfter(this.variableA, this.operand, mySession);
            }
            case 20: {
                return this.isBefore(this.variableA, this.operand, mySession);
            }
            case 22: {
                String valueA = this.getStringValue(this.variableA, true, mySession, false);
                return valueA.equals("__DD_NULL");
            }
            case 23: {
                IVariable var = mySession.getVariable(new VariableName(this.variableA).getVarName());
                if (var.isCollection()) {
                    return var.getCollection().hasPrevious();
                }
                return false;
            }
            case 24: {
                IVariable var = mySession.getVariable(new VariableName(this.variableA).getVarName());
                if (var.isCollection()) {
                    return !var.getCollection().hasPrevious();
                }
                return true;
            }
            case 25: {
                IVariable var = mySession.getVariable(new VariableName(this.variableA).getVarName());
                return var.isCollection();
            }
        }
        return false;
    }
}

