/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.connectivity.restws;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.HttpClientError;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

public class RestProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private SSLContext ctx = null;
    private String protocol = "";

    public RestProtocolSocketFactory(String protocol) {
        this.protocol = protocol;
        this.getSSLContext();
    }

    private static SSLContext getSSLContext(String protocol) {
        try {
            SSLContext ctx = SSLContext.getInstance(protocol);
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                public boolean checkClientTrusted(X509Certificate[] chain) {
                    return true;
                }

                public boolean isServerTrusted(X509Certificate[] chain) {
                    return true;
                }

                public boolean isClientTrusted(X509Certificate[] chain) {
                    return true;
                }

                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(X509Certificate[] chain, String authType) {
                }

                public void checkServerTrusted(X509Certificate[] chain, String authType) {
                }
            }};
            ctx.init(null, trustAllCerts, null);
            return ctx;
        }
        catch (Exception e) {
            throw new HttpClientError(e.toString());
        }
    }

    public SSLContext getSSLContext() {
        if (this.ctx == null) {
            this.ctx = this.protocol == null || this.protocol.length() == 0 ? RestProtocolSocketFactory.getSSLContext("ssl") : RestProtocolSocketFactory.getSSLContext(this.protocol);
        }
        return this.ctx;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(host, port);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(clientHost, clientPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        SSLSocketFactory socketfactory = this.getSSLContext().getSocketFactory();
        if (timeout == 0) {
            return socketfactory.createSocket(host, port, localAddress, localPort);
        }
        Socket socket = socketfactory.createSocket();
        InetSocketAddress localaddr = new InetSocketAddress(localAddress, localPort);
        InetSocketAddress remoteaddr = new InetSocketAddress(host, port);
        socket.bind(localaddr);
        socket.connect(remoteaddr, timeout);
        return socket;
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        return this.getSSLContext().getSocketFactory().createSocket(socket, host, port, autoClose);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(RestProtocolSocketFactory.class);
    }

    public int hashCode() {
        return RestProtocolSocketFactory.class.hashCode();
    }
}

