/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;

public class PhraseFinder
extends ResourceFinder {
    public static final String TYPE = "PHRASE";

    public static PhraseFinder getPhraseFinder(String language) {
        return (PhraseFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Phrase load(String name, String language) {
        Phrase phrase = null;
        if (name != null) {
            try {
                phrase = (Phrase)PhraseFinder.getPhraseFinder(language).getInstance(name);
                phrase.setLanguage(language);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating phrase", e);
            }
        }
        return phrase;
    }

    public PhraseFinder(String appLanguage) {
        super(appLanguage);
    }

    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("phrases");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("phrases");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

