/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Format {
    public static final String FORMAT = "format";
    public static final String FMT_TEXT = "text";
    public static final String FMT_DIGITS = "digits";
    public static final String FMT_FILENAME = "filename";
    public static final String FMT_FILEURL = "fileurl";
    public static final String FMT_AUDIO = "audio";
    private List<FormatAttribute> formatAttributes = new ArrayList<FormatAttribute>(5);

    public void add(String attribute, String value) {
        this.formatAttributes.add(new FormatAttribute(attribute, value));
    }

    public String get(String attribute) {
        for (FormatAttribute attrib : this.formatAttributes) {
            if (!attrib.getName().equals(attribute)) continue;
            return attrib.getValue();
        }
        return null;
    }

    public Iterator<String> iterator() {
        ArrayList<String> keys = new ArrayList<String>(this.formatAttributes.size());
        Iterator<FormatAttribute> iter = this.formatAttributes.iterator();
        while (iter.hasNext()) {
            keys.add(iter.next().getName());
        }
        return keys.iterator();
    }

    public FormatAttribute[] getFormatAttributes() {
        int size = this.formatAttributes.size();
        if (size == 0) {
            return new FormatAttribute[0];
        }
        return this.formatAttributes.toArray(new FormatAttribute[size]);
    }

    public static class FormatAttribute {
        private String name;
        private String value;

        private FormatAttribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

