/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.PromptElement;
import com.avaya.sce.runtime.PromptLevel;
import com.avaya.sce.runtime.internal.Utils;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;

public abstract class Prompt
implements IGenerator,
IRuntimePrompt {
    public static final int FIRST = 1;
    public static final int RANDOM = 2;
    public static final int SEQUENTIAL = 3;
    public static final int STANDARD = 4;
    int order = 4;
    String barginType = "speech";
    String name;
    String treatAsReply = "false";
    SCESession mySession = null;
    boolean enabled = true;
    boolean formPrompt = false;
    HashMap<Integer, PromptLevel> levels = new HashMap();
    String language = "";

    public Prompt() {
        this.name = Utils.getDefaultName(this);
    }

    @Override
    public void updatePrompt(SCESession mySession) {
    }

    @Override
    public final void generate(IOutputGenerator generator) {
        if (!this.enabled) {
            return;
        }
        if (this.formPrompt && this.order != 2) {
            this.order = 1;
        }
        if (this.getOrder() == 2) {
            generator.promptRandomize(this);
        } else {
            Collection<Integer> counts = this.getLevelNumbers();
            int iteration = 1;
            for (Integer count : counts) {
                boolean isSingle;
                boolean doGenerate = true;
                if (this.getOrder() == 1 && iteration > 1) {
                    doGenerate = false;
                }
                if (counts.size() == 1) {
                    isSingle = true;
                    iteration = count;
                } else {
                    isSingle = false;
                }
                if (doGenerate) {
                    if (this.getOrder() == 1) {
                        generator.promptBegin(this, iteration, isSingle);
                        generator.promptMiddle(this, iteration, isSingle, false);
                        generator.promptEnd(this, iteration, isSingle);
                    } else if (this.getOrder() == 3) {
                        generator.promptBegin(this, iteration, false, count, isSingle);
                        generator.promptMiddle(this, count, isSingle, false);
                        generator.promptEnd(this, count, isSingle);
                    } else {
                        generator.promptBegin(this, count, isSingle);
                        generator.promptMiddle(this, count, isSingle, false);
                        generator.promptEnd(this, count, isSingle);
                    }
                }
                ++iteration;
            }
        }
    }

    @Override
    public final Collection<Integer> getLevelNumbers() {
        ArrayList<Integer> theLevels = new ArrayList<Integer>();
        Set<Integer> set = this.levels.keySet();
        for (Integer key : set) {
            PromptLevel level = this.levels.get(key);
            theLevels.add(new Integer(level.getCount()));
        }
        Collections.sort(theLevels, new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                if (i1 > i2) {
                    return 1;
                }
                if (i1.intValue() == i2.intValue()) {
                    return 0;
                }
                if (i1 < i2) {
                    return -1;
                }
                return 0;
            }
        });
        return theLevels;
    }

    public final int getNumLevels() {
        return this.levels.size();
    }

    public final int getOrder() {
        return this.order;
    }

    public final void setOrder(int order) {
        this.order = order;
    }

    public final void add(int count, PromptElement element) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            level = new PromptLevel(count);
            this.levels.put(countObj, level);
        }
        element.setSession(this.mySession);
        if (this.language.length() > 0) {
            element.setLanguage(this.language);
        }
        level.add(element);
    }

    public final void setTimeout(int count, int timeout) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            level = new PromptLevel(count);
            this.levels.put(countObj, level);
        }
        level.setTimeout(timeout);
    }

    public final int getTimeout(int count) {
        int timeoutValue = -1;
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level != null) {
            int constTimeout = level.getTimeout();
            String varTimeout = level.getTimeoutVariable();
            if (varTimeout != null) {
                try {
                    Integer tm = new Integer(this.getVariableValue(varTimeout));
                    timeoutValue = tm;
                }
                catch (Exception e) {}
            } else {
                timeoutValue = constTimeout;
            }
        }
        return timeoutValue;
    }

    public final ArrayList<PromptElement> getElements(int count) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            return null;
        }
        return level.getElements();
    }

    public final boolean isBargin(int count) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            return true;
        }
        return level.isBargin();
    }

    public final String getBarginType() {
        return this.barginType;
    }

    public final String getTreatAsReply() {
        return this.treatAsReply;
    }

    public final String getName() {
        return this.name;
    }

    public final void setBargin(int count, boolean bargin) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            level = new PromptLevel(count);
            this.levels.put(countObj, level);
        }
        level.setBargin(bargin);
    }

    public final void setTimeoutVariable(int count, String varName) {
        Integer countObj = new Integer(count);
        PromptLevel level = this.levels.get(countObj);
        if (level == null) {
            level = new PromptLevel(count);
            this.levels.put(countObj, level);
        }
        level.setTimeoutVariable(varName);
    }

    public final void setBarginType(String barginType) {
        this.barginType = barginType;
    }

    public final void setTreatAsReply(String treatAsReply) {
        this.treatAsReply = treatAsReply;
    }

    public final void setName(String name) {
        this.name = name;
    }

    @Override
    public final void setSession(SCESession mySession) {
        this.mySession = mySession;
    }

    public final boolean isEnabled() {
        return this.enabled;
    }

    public final void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final SCESession getSession() {
        return this.mySession;
    }

    boolean isFormPrompt() {
        return this.formPrompt;
    }

    void setFormPrompt(boolean formPrompt) {
        this.formPrompt = formPrompt;
    }

    protected String getVariableValue(String varName) {
        IVariableField field = this.getSession().getVariableField(new VariableName(varName));
        return field != null ? field.getStringValue() : null;
    }

    public final void setLanguage(String language) {
        this.language = language;
    }

    public final String getLanguage() {
        return this.language;
    }
}

