/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.perf;

import com.avaya.sce.runtime.perf.Counter;
import com.avaya.sce.runtimecommon.ICounter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class Performance {
    public static final String PAGE_REQ_START = "___sage.pagerequest.start";
    public static final String PAGE_GEN = "_avaya-page-gen|Page Generation";
    public static final String WSOP = "_avaya-wsop|Web Service Operation";
    public static final String DBOP = "_avaya-dbop|Data Base Operation";
    public static final String REQ_BEGIN = "_avaya-request-begin|Request Begin";
    public static final String ICOP = "_avaya-icop|IC Operation";
    public static final String CTIOP = "_avaya-ctiop|CTI Operation";
    public static final String SERVLET_REQ = "_avaya-servlet-request|Servlet Request";
    public static final String UPDATE_CHOICE = "_avaya-update-choice|Update Choice";
    public static final String UPDATE_PROMPT = "_avaya-update-prompt|Update Prompt";
    public static final String UPDATE_GRAMMAR = "_avaya-update-grammar|Update Grammar";
    public static final String UPDATE_FIELD = "_avaya-update-field|Update Field";
    public static final String UPDATE_LINK = "_avaya-update-link|Update Link";
    public static final String UPDATE_BRANCHES = "_avaya-update-branches|Update Branches";
    public static final String SERVLET_IMPL = "_avaya-servlet-implementation|Servlet Implementation";
    public static final String UPDATE_PROPS = "_avaya-update-props|Update Props";
    public static final String CUSTOM_MLGENERATION = "_avaya-custom-mlgeneration|Markup lanugage generation";
    public static final String UPDATE_EVENTS = "_avaya-update-events|Update Events";
    private static boolean enabled;
    private static TreeMap<String, HashMap<String, ICounter>> counters;

    public static void update(String type, long value, String id) {
        ICounter counter;
        HashMap<String, Object> servletBucket;
        if (!enabled) {
            return;
        }
        if (type == null) {
            new Exception("type null").printStackTrace();
        }
        if (id == null) {
            new Exception("id null").printStackTrace();
        }
        if ((servletBucket = counters.get(type)) == null) {
            servletBucket = new HashMap();
            counters.put(type, servletBucket);
        }
        if ((counter = servletBucket.get(id)) == null) {
            counter = new Counter(id);
            servletBucket.put(id, counter);
        }
        counter.update((double)value);
    }

    public static void clearAll() {
        Iterator<String> iterator = counters.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            HashMap<String, ICounter> servletBucket = counters.get(key);
            Iterator<String> iterator2 = servletBucket.keySet().iterator();
            while (iterator2.hasNext()) {
                String key2 = iterator.next();
                ICounter counter = servletBucket.get(key2);
                counter.clear();
            }
        }
    }

    public static String getDescriptionFromType(String type) {
        if (type == null) {
            return "";
        }
        int index = type.indexOf("|");
        if (index != -1) {
            return type.substring(index + 1);
        }
        return type;
    }

    public static Collection<String> getCounterTypes() {
        return counters.keySet();
    }

    public static HashMap<String, ICounter> getCounterType(String type) {
        if (type == null) {
            return null;
        }
        if (type.length() == 0) {
            return null;
        }
        HashMap<String, Object> servletBucket = counters.get(type);
        if (servletBucket == null) {
            servletBucket = new HashMap();
            counters.put(type, servletBucket);
        }
        return servletBucket;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setEnabled(boolean enabled) {
        Performance.enabled = enabled;
    }

    static {
        counters = new TreeMap();
        enabled = false;
    }
}

