/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;

public class PrepareAAI
extends AssignmentOperation {
    String mode;
    String ucidVar;
    String asaiVar;
    String resultVar;

    public PrepareAAI(String mode, String ucidVar, String asaiVar, String resultVar) {
        this.mode = mode;
        this.ucidVar = ucidVar;
        this.asaiVar = asaiVar;
        this.resultVar = resultVar;
    }

    private String stringToHex(String data) {
        StringBuilder result = new StringBuilder();
        try {
            for (int i = 0; i < data.length(); ++i) {
                char x = data.charAt(i);
                result.append(Integer.toString(x, 16));
            }
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error converting string to hex character codes", e);
        }
        return result.toString();
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        IVariableField asaiField;
        String aai;
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "Preparing AAI [" + this.mode + "] ucid [" + this.ucidVar + "] asai [" + this.asaiVar + "] result [" + this.resultVar + "]");
        }
        if (this.mode.toLowerCase().equals("shared")) {
            if (this.asaiVar.length() == 0) {
                aai = "PD,00";
            } else {
                asaiField = mySession.getVariableField(new VariableName(this.asaiVar));
                aai = "PD,04;C8," + this.stringToHex(asaiField.getStringValue());
            }
            if (this.ucidVar.length() != 0) {
                IVariableField ucidField = mySession.getVariableField(new VariableName(this.ucidVar));
                aai = aai + ";FA," + this.stringToHex(ucidField.getStringValue());
            }
        } else {
            asaiField = mySession.getVariableField(new VariableName(this.asaiVar));
            aai = "04" + this.stringToHex(asaiField.getStringValue());
        }
        IVariableField resultField = mySession.getVariableField(new VariableName(this.resultVar));
        resultField.setValue(aai);
    }
}

