/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;

public class StringToHexCharCodes
extends AssignmentOperation {
    String destName;
    String sourceName;

    public StringToHexCharCodes(String destName, String sourceName) {
        this.destName = destName;
        this.sourceName = sourceName;
    }

    @Override
    public void evaluate(IRuntimeSession mySession) {
        IVariableField destField = mySession.getVariableField(new VariableName(this.destName));
        String source = this.getStringValue(mySession, new VariableName(this.sourceName));
        StringBuilder result = new StringBuilder();
        try {
            byte[] bytes = source.getBytes("UTF-8");
            for (int i = 0; i < bytes.length; ++i) {
                result.append(Integer.toString(bytes[i] & 0xFF, 16));
            }
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error converting string to hex character codes", e);
        }
        if (mySession.isTraceEnabled()) {
            mySession.getTraceOutput().writeln(2, "StringToHexCharCodes [" + this.sourceName + "] to [" + this.destName + "] results in [" + result.toString() + "]");
        }
        destField.setValue(result.toString());
    }
}

