/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.vxml;

import com.avaya.ade.common.utils.io.IO;
import com.avaya.runtime.platforms.Toolkit;
import com.avaya.sce.runtime.AppDocument;
import com.avaya.sce.runtime.CaptureExpression;
import com.avaya.sce.runtime.Choice;
import com.avaya.sce.runtime.CoordinationPar;
import com.avaya.sce.runtime.CoordinationSeq;
import com.avaya.sce.runtime.Disconnect;
import com.avaya.sce.runtime.DynamicGrammar;
import com.avaya.sce.runtime.EmailInfo;
import com.avaya.sce.runtime.Entry;
import com.avaya.sce.runtime.Event;
import com.avaya.sce.runtime.ExitAction;
import com.avaya.sce.runtime.Field;
import com.avaya.sce.runtime.Form;
import com.avaya.sce.runtime.Format;
import com.avaya.sce.runtime.Goto;
import com.avaya.sce.runtime.Grammar;
import com.avaya.sce.runtime.Handler;
import com.avaya.sce.runtime.ILanguage;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IPluggableConnectorVXMLContribution;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.Invoke;
import com.avaya.sce.runtime.Link;
import com.avaya.sce.runtime.MMFPhrasesetPhrase;
import com.avaya.sce.runtime.MediaElement;
import com.avaya.sce.runtime.MediaInfo;
import com.avaya.sce.runtime.MediaPage;
import com.avaya.sce.runtime.MediaPar;
import com.avaya.sce.runtime.MediaRegion;
import com.avaya.sce.runtime.MediaSeq;
import com.avaya.sce.runtime.MediaText;
import com.avaya.sce.runtime.MediaTextBlock;
import com.avaya.sce.runtime.Menu;
import com.avaya.sce.runtime.MixedInitiativeForm;
import com.avaya.sce.runtime.Parameter;
import com.avaya.sce.runtime.Phrase;
import com.avaya.sce.runtime.PhraseVariableElement;
import com.avaya.sce.runtime.PlatformObject;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.PromptElement;
import com.avaya.sce.runtime.Property;
import com.avaya.sce.runtime.Record;
import com.avaya.sce.runtime.Return;
import com.avaya.sce.runtime.ReturnError;
import com.avaya.sce.runtime.Root;
import com.avaya.sce.runtime.RuntimeVersion;
import com.avaya.sce.runtime.SMILLink;
import com.avaya.sce.runtime.SMSInfo;
import com.avaya.sce.runtime.SessionVarField;
import com.avaya.sce.runtime.Submit;
import com.avaya.sce.runtime.Throw;
import com.avaya.sce.runtime.Transfer;
import com.avaya.sce.runtime.TransferOnError;
import com.avaya.sce.runtime.internal.ASRTTSFinder;
import com.avaya.sce.runtime.internal.FlowFinder;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.tracking.ReportInfo;
import com.avaya.sce.runtimecommon.IComplexVariable;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.RuntimeCommonVersion;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import com.avaya.sce.runtimecommon.config.IApplicationConfiguration;
import com.avaya.sce.runtimecommon.config.IProxySettings;
import com.avaya.sce.runtimecommon.debug.DebugInfo;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;

public class OutputGenerator
extends com.avaya.sce.runtime.OutputGenerator {
    private boolean didPromptPregen = false;

    public OutputGenerator(SCESession mySession) {
        super(mySession);
    }

    public final String stringToHex(String data) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < data.length(); ++i) {
            char x = data.charAt(i);
            result.append(Integer.toString(x, 16));
        }
        return result.toString();
    }

    private String getNextUrl(String next) {
        if (this.isSecureFetch) {
            try {
                String requestUrlStr = this.mySession.getRequestCopyURL();
                if (requestUrlStr.startsWith("http://")) {
                    requestUrlStr = "https://" + requestUrlStr.substring(7);
                }
                URL reqURL = new URL(requestUrlStr);
                IApplicationConfiguration config = com.avaya.runtimecommon.platforms.Toolkit.getConfig();
                IProxySettings settings = config.getProxySettings();
                int port = 8443;
                if (settings.getSecureFetchPort().length() > 0) {
                    port = Integer.parseInt(settings.getSecureFetchPort());
                } else if (this.mySession.isDDTraceEnabled()) {
                    this.mySession.getTraceOutput().writeln(3, "Secure Fetch enabled, using default port 8443");
                }
                reqURL = new URL(reqURL.getProtocol(), reqURL.getHost(), port, reqURL.getFile());
                URL nextURL = new URL(reqURL, next);
                next = nextURL.toString();
            }
            catch (MalformedURLException e) {
                this.mySession.throwRTException("MalformedURL generating secure fetch", (Exception)e);
            }
        }
        if (next.indexOf(63) == -1) {
            return next + "?" + "___DDSESSIONID" + "=" + this.mySession.getEncodedSessionId();
        }
        return next + "&amp;" + "___DDSESSIONID" + "=" + this.mySession.getEncodedSessionId();
    }

    private static String encodeQueryString(String query) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(query.length() << 1);
        String[] params = query.split("&");
        for (int i = 0; i < params.length; ++i) {
            int index;
            if (i > 0) {
                sb.append("&amp;");
            }
            if ((index = params[i].indexOf(61)) > 0) {
                sb.append(params[i].substring(0, index));
                sb.append("=");
                sb.append(URLEncoder.encode(params[i].substring(++index), "UTF-8"));
                continue;
            }
            sb.append(URLEncoder.encode(params[i], "UTF-8"));
        }
        return sb.toString();
    }

    private void promptPreGen(Collection prompts) {
        this.didPromptPregen = true;
        for (Prompt prompt : prompts) {
            if (prompt.getOrder() != 2) continue;
            this.out.println("<var name=\"" + prompt.getName() + "\" expr=\"((Math.floor(Math.random()*100))%" + prompt.getNumLevels() + ")+1\"/>");
        }
    }

    protected void generateExitInfo() {
        IVariableField reasonField = this.mySession.getVariableField(new VariableName("session:exitReason"));
        IVariableField info1Field = this.mySession.getVariableField(new VariableName("session:exitInfo1"));
        IVariableField info2Field = this.mySession.getVariableField(new VariableName("session:exitInfo2"));
        IVariableField custidField = this.mySession.getVariableField(new VariableName("session:exitCustomerId"));
        IVariableField prefpathField = this.mySession.getVariableField(new VariableName("session:exitPreferredPath"));
        IVariableField topicField = this.mySession.getVariableField(new VariableName("session:exitTopic"));
        String reason = reasonField != null ? reasonField.getStringValue() : "";
        String info1 = info1Field != null ? info1Field.getStringValue() : "";
        String info2 = info2Field != null ? info2Field.getStringValue() : "";
        String custId = info2Field != null ? custidField.getStringValue() : "";
        String prefPath = info2Field != null ? prefpathField.getStringValue() : "";
        String topic = info2Field != null ? topicField.getStringValue() : "";
        reason = this.xmlEscapeString(reason, true, false);
        info1 = this.xmlEscapeString(info1, true, false);
        info2 = this.xmlEscapeString(info2, true, false);
        this.out.println("<var name=\"_avayaExitReason\" expr=\"'" + reason + "'\"/>");
        this.out.println("<var name=\"_avayaExitInfo1\" expr=\"'" + info1 + "'\"/>");
        this.out.println("<var name=\"_avayaExitInfo2\" expr=\"'" + info2 + "'\"/>");
        this.out.println("<var name=\"_avayaExitCustomerId\" expr=\"'" + custId + "'\"/>");
        this.out.println("<var name=\"_avayaExitPreferredPath\" expr=\"'" + prefPath + "'\"/>");
        this.out.println("<var name=\"_avayaExitTopic\" expr=\"'" + topic + "'\"/>");
    }

    @Override
    public void begin(AppDocument document) {
        String rootDoc;
        boolean genExitInfo = false;
        boolean genRoot = false;
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.out.print("<vxml");
        if (this.mySession.getPlatformSettings().getVxml().equals("2.1 + IVVR")) {
            this.genAttr("version", "2.1");
        } else if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.genAttr("version", "2.1");
        } else {
            this.genAttr("version", "2.0");
        }
        this.genAttr("xmlns", "http://www.w3.org/2001/vxml");
        this.genAttr("xml:lang", Toolkit.getCurrentLanguageTTS(this.mySession));
        if (document != null) {
            if (!(document instanceof Root)) {
                if (!(document instanceof Return)) {
                    rootDoc = this.mySession.getCurrentRootDoc();
                    if (rootDoc != null) {
                        if (!this.mySession.getRuntimePropertyEnabled("xmlrootinline")) {
                            this.genAttr("application", this.getNextUrl(rootDoc));
                        } else {
                            genRoot = true;
                        }
                    }
                } else if (!this.mySession.isRootApplicaiton()) {
                    rootDoc = this.mySession.getCurrentRootDoc();
                    if (rootDoc != null) {
                        if (!this.mySession.getRuntimePropertyEnabled("xmlrootinline")) {
                            this.genAttr("application", this.getNextUrl(rootDoc));
                        } else {
                            genRoot = true;
                        }
                    }
                } else {
                    genExitInfo = true;
                }
            }
        } else {
            rootDoc = this.mySession.getCurrentRootDoc();
            if (rootDoc != null) {
                if (!this.mySession.getRuntimePropertyEnabled("xmlrootinline")) {
                    this.genAttr("application", this.getNextUrl(rootDoc));
                } else {
                    genRoot = true;
                }
            }
        }
        this.out.println(">");
        this.out.println("<meta name=\"author\" content=\"Avaya Aura Orchestration Designer\"/>");
        this.out.println("<meta name=\"runtime-version\" content=\"" + RuntimeVersion.getVersion() + "\"/>");
        this.out.println("<meta name=\"runtimecommon-version\" content=\"" + RuntimeCommonVersion.getVersion() + "\"/>");
        if (RuntimeVersion.getPatchInfo().length > 0 || RuntimeCommonVersion.getPatchInfo().length > 0) {
            String[][] patches = new String[][]{RuntimeVersion.getPatchInfo(), RuntimeCommonVersion.getPatchInfo()};
            boolean addComma = false;
            this.out.print("<meta name=\"runtime-hotfixes\" content=\"");
            String[][] arr$ = patches;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String[] mrs;
                for (String s : mrs = arr$[i$]) {
                    if (addComma) {
                        this.out.print(", ");
                    }
                    this.out.print(s);
                    addComma = true;
                }
            }
            this.out.println("\"/>");
        }
        this.out.println("<meta name=\"copyright\" content=\"Copyright (c) 2002-2011, Avaya\"/>");
        if (genRoot) {
            this.generateRoot();
        }
        this.generateFetchAudio(document);
        if (genExitInfo) {
            this.generateExitInfo();
        }
    }

    @Override
    public void end(AppDocument document) {
        this.out.println("</vxml>");
    }

    @Override
    public void setContentType(HttpServletResponse response) {
        String showVXML = this.mySession.getRequest().getParameter("__Dialog__Designer__VXMLINHTML");
        if (showVXML != null && showVXML.equalsIgnoreCase("true")) {
            response.setContentType("text/html; charset=UTF-8");
            return;
        }
        response.setContentType("application/voicexml+xml; charset=UTF-8");
    }

    @Override
    public void formBegin(Form form) {
        this.out.print("<form");
        this.genAttr("id", form.getName());
        this.out.println(">");
    }

    @Override
    public void formEnd(Form form) {
        this.mySession.removeProperty("___sagerecordutterancenameinfo");
        this.mySession.removeProperty("___sagenomatchnoinputnameinfo");
        this.out.println("</form>");
    }

    @Override
    public void menuBegin(Menu menu, Collection prompts, Collection choices) {
        if (menu.isRecordUtterance()) {
            this.mySession.setProperty("___sagerecordutterancenameinfo", (Object)menu.getName());
        }
        this.mySession.setProperty("___sagenomatchnoinputnameinfo", (Object)menu.getName());
        this.promptPreGen(prompts);
        this.genVars(menu.getName(), 1, menu.getColumns(choices), menu.getGrammars(choices), menu.isCollectMark(), menu.isRecordUtterance());
        this.out.println("<var name=\"ddmenuchoice\"/>");
        if (menu.isRecordUtterance()) {
            this.out.print("<property");
            this.genAttr("name", "recordutterance");
            this.genAttr("value", "true");
            this.out.println(" />");
        }
        this.out.print("<menu");
        this.genAttr("id", menu.getName());
        this.genAttr("accept", menu.getAccept());
        this.out.println(">");
    }

    @Override
    public void menuEnd(Menu menu, Collection choices) {
        this.mySession.removeProperty("___sagerecordutterancenameinfo");
        this.mySession.removeProperty("___sagenomatchnoinputnameinfo");
        this.out.println("</menu>");
        for (Choice choice : choices) {
            if (!choice.isEnabled()) continue;
            this.out.print("<form id=\"");
            this.out.print("choice" + choice.getId());
            this.out.println("\">");
            this.out.println("<block>");
            this.out.println("<assign name=\"ddmenuchoice\" expr=\"'" + this.getNextUrl(choice.getNext()) + "'\"/>");
            this.out.println("<goto next=\"#ddfinish\"/>");
            this.out.println("</block>");
            Collection events = (Collection)this.mySession.getProperty("dd.appdoc.completedevents");
            if (events != null) {
                for (Event event : events) {
                    if (event.getType().indexOf("connection") == -1) continue;
                    event.generate(this);
                }
            }
            this.out.println("</form>");
        }
        this.out.println("<form id=\"ddfinish\">");
        this.out.println("<block>");
        ArrayList<String> cols = menu.getColumns(choices);
        this.genAssignsVars(menu.getName(), cols, menu.getGrammars(choices), menu.isCollectMark(), menu.isRecordUtterance());
        this.out.print("<submit expr=\"ddmenuchoice\" namelist=\"");
        this.out.print(menu.getName() + "___value" + " ");
        this.out.print(menu.getName() + "___confidence" + " ");
        this.out.print(menu.getName() + "___utterance" + " ");
        this.out.print(menu.getName() + "___inputmode" + " ");
        this.out.print(menu.getName() + "___interpretation" + " ");
        this.out.print(menu.getName() + "___noinputcount" + " ");
        this.out.print(menu.getName() + "___nomatchcount" + " ");
        for (String col : cols) {
            this.out.print(menu.getName() + "___" + col + " ");
        }
        if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            if (menu.isCollectMark()) {
                this.out.print(menu.getName() + "___markname" + " ");
                this.out.print(menu.getName() + "___marktime" + " ");
            }
            if (menu.isRecordUtterance()) {
                this.out.print(menu.getName() + "___recording" + " ");
                this.out.print(menu.getName() + "___recordingsize" + " ");
                this.out.print(menu.getName() + "___recordingduration" + " ");
            }
        }
        this.out.print("\"  method=\"post\"");
        if (menu.isRecordUtterance()) {
            this.out.print(" enctype=\"multipart/form-data\"");
        }
        this.out.println("/>");
        this.out.println("</block>");
        Collection events = (Collection)this.mySession.getProperty("dd.appdoc.completedevents");
        if (events != null) {
            for (Event event : events) {
                if (event.getType().indexOf("connection") == -1) continue;
                event.generate(this);
            }
        }
        this.out.println("</form>");
    }

    @Override
    public void linkBegin(Link link) {
        this.out.print("<link ");
        if (link.getEvent() != null && link.getEvent().length() > 0) {
            this.genAttr("event", link.getEvent());
        } else if (link.getExpressionList() == null) {
            this.genAttr("next", this.getNextUrl(link.getNext()));
        } else {
            this.genAttr("next", "#" + link.getName() + "Form");
        }
        if (link.isDtmfConstant()) {
            this.genAttr("dtmf", link.getDtmf());
        } else {
            this.genAttr("dtmf", this.getVariable(link.getDtmf()));
        }
        this.out.println(">");
    }

    @Override
    public void linkEnd(Link link) {
        this.out.println("</link>");
    }

    @Override
    public void linkPostBegin(Link link) {
        if (link.getExpressionList() != null) {
            this.out.print("<form id=\"");
            this.out.print(link.getName() + "Form");
            this.out.println("\">");
            this.out.println("<block>");
            Submit submit = new Submit(link.getNext());
            submit.setEncodingType("application/x-www-form-urlencoded");
            submit.setPost(true);
            for (CaptureExpression expression : link.getExpressionList()) {
                expression.generate(this);
                submit.addToSubmitList(expression.getSubmitName());
            }
            submit.generate(this);
            this.out.println("</block>");
            Collection events = (Collection)this.mySession.getProperty("dd.appdoc.completedevents");
            if (events != null) {
                for (Event event : events) {
                    event.generate(this);
                }
            }
            this.out.println("</form>");
        }
    }

    @Override
    public void linkPostEnd(Link link) {
    }

    @Override
    public void choiceBegin(Choice choice) {
        this.out.print("<choice ");
        if (choice.isDtmfConstant()) {
            this.genAttr("dtmf", choice.getDtmf());
        } else {
            this.genAttr("dtmf", this.getVariable(choice.getDtmf()));
        }
        this.genAttr("accept", choice.getAccept());
        this.genAttr("next", "#choice" + choice.getId());
        this.out.println(">");
    }

    @Override
    public void choiceEnd(Choice choice) {
        this.out.println("</choice>");
    }

    @Override
    public void grammarBegin(Grammar grammar) {
        ServletContext context = this.mySession.getServlet().getServletContext();
        String cacheValue = context.getInitParameter("grammar-caching");
        if (cacheValue == null) {
            cacheValue = "none";
        }
        if (grammar.isBuiltin()) {
            this.out.print("<grammar ");
            this.genAttr("mode", grammar.getMode());
            this.genAttr("xml:lang", grammar.getRootLanguage());
            this.genAttr("weight", grammar.getWeight());
            String value = "builtin:" + grammar.getBuiltinMode() + "/" + grammar.getType();
            if (grammar.getOptions() != null && grammar.getOptions().length() > 0) {
                value = value + "?" + grammar.getOptions();
            }
            this.genAttr("src", value);
            if (cacheValue.equals("none")) {
                this.genAttr("maxage", "0");
            }
            this.out.println("/>");
        } else {
            this.out.print("<grammar ");
            this.genAttr("mode", grammar.getMode());
            this.genAttr("xml:lang", grammar.getRootLanguage());
            if (cacheValue.equals("none")) {
                this.genAttr("maxage", "0");
            }
            this.genAttr("weight", grammar.getWeight());
            try {
                String urlStr = grammar.getURL();
                int index = urlStr.indexOf(63);
                if (index != -1 && !grammar.doNotEncodeQueryString()) {
                    String query = urlStr.substring(++index);
                    urlStr = urlStr.substring(0, index);
                    urlStr = urlStr + OutputGenerator.encodeQueryString(query);
                }
                this.genAttr("src", urlStr);
            }
            catch (Exception e) {
                this.genAttr("src", grammar.getURL());
            }
            this.genAttr("type", grammar.getMediaType());
            this.out.println("/>");
        }
    }

    @Override
    public void grammarEnd(Grammar grammar) {
    }

    @Override
    public void dynamicGrammarBegin(DynamicGrammar grammar) {
        this.out.println(grammar.toString());
    }

    @Override
    public void dynamicGrammarEnd(DynamicGrammar grammar) {
    }

    @Override
    public void audioMediaPhraseBegin(Phrase phrase) {
        this.out.print("<media src=\"");
        this.out.print(phrase.getURL());
        this.out.println("\"/>");
    }

    @Override
    public void audioMediaPhraseEnd(Phrase phrase) {
    }

    @Override
    public void phraseBegin(Phrase phrase) {
        this.out.print("<audio src=\"");
        if (phrase.getType() == Phrase.Type.MMF && this.mySession.getPlatformSettings().getPlatform().equals("MPS")) {
            String parentMMFFilename = ((MMFPhrasesetPhrase)phrase).getParentMMFFilename();
            phrase.getFileName();
            this.out.print("builtin:" + parentMMFFilename + "/" + phrase.getFileName());
        } else {
            this.out.print(phrase.getURL());
        }
        String text = phrase.getText();
        if (text == null) {
            this.out.println("\"/>");
            return;
        }
        if (text.length() == 0) {
            this.out.println("\"/>");
            return;
        }
        ServletContext context = this.mySession.getServlet().getServletContext();
        if (Boolean.parseBoolean(context.getInitParameter("runtime-Disable-TTS-Backup"))) {
            this.out.println("\"/>");
            return;
        }
        this.out.print("\">");
        this.out.print(this.xmlEscapeString(text, false, false));
    }

    @Override
    public void phraseEnd(Phrase phrase) {
        String text = phrase.getText();
        if (text == null) {
            return;
        }
        if (text.length() == 0) {
            return;
        }
        ServletContext context = this.mySession.getServlet().getServletContext();
        if (Boolean.parseBoolean(context.getInitParameter("runtime-Disable-TTS-Backup"))) {
            return;
        }
        this.out.println("</audio>");
    }

    @Override
    public void gotoBegin(Goto goTo) {
        String nmniVarName = (String)this.mySession.getProperty("___sagenomatchnoinputnameinfo");
        String recordUttervarName = (String)this.mySession.getProperty("___sagerecordutterancenameinfo");
        if (goTo.getExpressionList() == null && recordUttervarName == null && nmniVarName == null) {
            this.out.print("<goto ");
            this.genAttr("next", this.getNextUrl(goTo.getNext()));
            this.out.println("/>");
        } else {
            Submit submit = new Submit(goTo.getNext());
            submit.setEncodingType("multipart/form-data");
            submit.setPost(true);
            if (recordUttervarName != null) {
                this.out.println("<var name=\"" + recordUttervarName + "___recording" + "\" expr=\"try {application.lastresult$.recording} catch (errMsg) {'undefined'}\"/>");
                this.out.println("<var name=\"" + recordUttervarName + "___recordingsize" + "\" expr=\"try {objectToString(application.lastresult$.recordingsize)} catch (errMsg) {'undefined'}\"/>");
                this.out.println("<var name=\"" + recordUttervarName + "___recordingduration" + "\" expr=\"try {objectToString(application.lastresult$.recordingduration)} catch (errMsg) {'undefined'}\"/>");
                submit.addToSubmitList(recordUttervarName + "___recording");
                submit.addToSubmitList(recordUttervarName + "___recordingsize");
                submit.addToSubmitList(recordUttervarName + "___recordingduration");
            }
            if (goTo.getExpressionList() != null) {
                for (CaptureExpression expression : goTo.getExpressionList()) {
                    submit.addToSubmitList(expression.getSubmitName());
                }
            }
            if (nmniVarName != null) {
                this.out.println("<assign name=\"" + nmniVarName + "___noinputcount" + "\" expr=\"try {" + "_avayaNoinputCounter" + "} catch (errMsg) {'0'}\"/>");
                this.out.println("<assign name=\"" + nmniVarName + "___nomatchcount" + "\" expr=\"try {" + "_avayaNomatchCounter" + "} catch (errMsg) {'0'}\"/>");
                submit.addToSubmitList(nmniVarName + "___noinputcount");
                submit.addToSubmitList(nmniVarName + "___nomatchcount");
            }
            submit.generate(this);
        }
    }

    @Override
    public void gotoEnd(Goto goTo) {
    }

    private void prompStandardAttributes(Prompt prompt, int count) {
        if (prompt.isBargin(count)) {
            this.genAttr("bargein", "true");
            this.genAttr("bargeintype", prompt.getBarginType());
        } else {
            this.genAttr("bargein", "false");
        }
        int timeout = prompt.getTimeout(count);
        if (timeout != -1) {
            this.genAttr("timeout", timeout + "ms");
        }
        if (prompt.getLanguage().length() > 0) {
            String langCode = this.getLangClass(prompt.getLanguage()).getTTSLanguage();
            this.genAttr("xml:lang", langCode);
        }
    }

    private ILanguage getLangClass(String language) {
        ILanguage langClass = null;
        try {
            langClass = (ILanguage)ASRTTSFinder.getASRTTSFinder(language).getInstance("ASR_TTS_Language");
        }
        catch (Exception e) {
            throw new SCERuntimeException("Language [" + language + "] does not exits", e);
        }
        return langClass;
    }

    public void promptBeginStd(Prompt prompt, int count, boolean isRandomized, int iteration, boolean isSingle) {
        this.out.print("<prompt");
        this.prompStandardAttributes(prompt, count);
        if (isRandomized) {
            this.genAttr("cond", "" + prompt.getName() + " == " + iteration);
        } else if (!isSingle) {
            this.genAttr("count", Integer.toString(count));
        }
        this.out.println(">");
    }

    @Override
    public void promptBegin(IRuntimePrompt prompt, int count, boolean isRandomized, int iteration, boolean isSingle) {
        if (prompt instanceof Prompt || prompt == null) {
            this.promptBeginStd((Prompt)prompt, count, isRandomized, iteration, isSingle);
        } else {
            this.mySession.throwRTException("Prompt type not implemented");
        }
    }

    @Override
    public void promptBegin(IRuntimePrompt prompt, int count, boolean isSingle) {
        if (prompt instanceof Prompt || prompt == null) {
            this.promptBeginStd((Prompt)prompt, count, false, -1, isSingle);
        } else {
            this.mySession.throwRTException("Prompt type not implemented");
        }
    }

    @Override
    public void promptMiddle(IRuntimePrompt promptIn, int count, boolean isSingle, boolean forceTag) {
        if (promptIn != null) {
            Prompt prompt = (Prompt)promptIn;
            if (forceTag) {
                this.out.print("<prompt");
                this.prompStandardAttributes(prompt, count);
                this.out.println(">");
            }
            ServletContext context = null;
            ArrayList<PromptElement> list = null;
            list = prompt.getElements(count);
            block14: for (int i = 0; i < list.size(); ++i) {
                PromptElement element = list.get(i);
                if (!element.isEnabled()) continue;
                switch (element.getType()) {
                    case 1: {
                        this.generateTextContent(element.getText());
                        continue block14;
                    }
                    case 2: 
                    case 9: {
                        Phrase p = element.getPhrase();
                        if (!element.getAsMedia()) {
                            p.generate(this);
                            continue block14;
                        }
                        p.generateAsMedia(this);
                        continue block14;
                    }
                    case 3: {
                        Format format = element.getFormats();
                        if (format != null) {
                            String fmt = format.get("format");
                            if (fmt.equals("filename") || fmt.equals("fileurl")) {
                                String value = element.getFormattedVariableText();
                                if (element.isWaveFile()) {
                                    if (!element.getAsMedia()) {
                                        this.out.print("<audio src=\"");
                                    } else {
                                        this.out.print("<media src=\"");
                                    }
                                    this.out.print(value);
                                    this.out.println("\"/>");
                                    continue block14;
                                }
                                if (this.mySession.getRuntimePropertyEnabled("noescapeprompt")) {
                                    this.out.println(value);
                                    continue block14;
                                }
                                this.out.println(this.xmlEscapeString(value, false, false));
                                continue block14;
                            }
                            if (fmt.equals("digits")) {
                                this.out.println(element.getFormattedVariableText());
                                continue block14;
                            }
                            if (!fmt.equals("text")) continue block14;
                            this.generateTextContent(element.getFormattedVariableText());
                            continue block14;
                        }
                        if (this.mySession.getRuntimePropertyEnabled("noescapeprompt")) {
                            this.out.println(element.getFormattedVariableText());
                            continue block14;
                        }
                        this.out.println(this.xmlEscapeString(element.getFormattedVariableText(), false, false));
                        continue block14;
                    }
                    case 4: 
                    case 12: {
                        Phrase[] values = element.getFormattedVariableAudio();
                        for (int ix = 0; ix < values.length; ++ix) {
                            if (!element.getAsMedia()) {
                                values[ix].generate(this);
                                continue;
                            }
                            values[ix].generateAsMedia(this);
                        }
                        continue block14;
                    }
                    case 7: {
                        context = this.mySession.getServlet().getServletContext();
                        if (!Boolean.valueOf(context.getInitParameter("runtime-SSML")).booleanValue()) continue block14;
                        this.generateXMLTagFull(element);
                        continue block14;
                    }
                    case 5: {
                        context = this.mySession.getServlet().getServletContext();
                        if (!Boolean.valueOf(context.getInitParameter("runtime-SSML")).booleanValue()) continue block14;
                        this.generateXMLTagBegin(element);
                        continue block14;
                    }
                    case 6: {
                        context = this.mySession.getServlet().getServletContext();
                        if (!Boolean.valueOf(context.getInitParameter("runtime-SSML")).booleanValue()) continue block14;
                        this.generateXMLTagEnd(element);
                        continue block14;
                    }
                    case 8: {
                        Format exFormat = element.getFormats();
                        String exFmt = null;
                        if (exFormat != null) {
                            exFmt = exFormat.get("format");
                        }
                        this.generateExpressionContent(element.getValue(), exFmt);
                        continue block14;
                    }
                    case 10: {
                        Phrase[] phrases;
                        if (!(element instanceof PhraseVariableElement)) {
                            throw new SCERuntimeException("Prompt element must be type \"PhraseVariableElement\". Element type: " + element.getClass().getName());
                        }
                        for (Phrase phrase : phrases = ((PhraseVariableElement)element).getPhrases()) {
                            if (!element.getAsMedia()) {
                                phrase.generate(this);
                                continue;
                            }
                            phrase.generateAsMedia(this);
                        }
                        continue block14;
                    }
                    case 11: {
                        ((MediaElement)element).generate(this);
                        continue block14;
                    }
                    case 15: {
                        throw new SCERuntimeException("Email Text - is not valid ");
                    }
                    case 16: {
                        throw new SCERuntimeException("SMS Text - is not valid ");
                    }
                }
            }
            if (forceTag) {
                this.out.println("</prompt>");
            }
        }
    }

    @Override
    public void promptEnd(IRuntimePrompt prompt, int count, boolean isSingle) {
        this.out.println("</prompt>");
    }

    @Override
    public void promptRandomize(IRuntimePrompt prompt) {
        if (!this.didPromptPregen) {
            ArrayList<IRuntimePrompt> prompts = new ArrayList<IRuntimePrompt>();
            prompts.add(prompt);
            this.promptPreGen(prompts);
        }
        Collection counts = prompt.getLevelNumbers();
        int index = 0;
        for (Integer count : counts) {
            this.promptBegin(prompt, count, true, index + 1, false);
            this.promptMiddle(prompt, count, false, false);
            this.promptEnd(prompt, count, false);
            ++index;
        }
    }

    private void genRecordAssigns(Record record) {
        this.out.println("<assign name=\"" + record.getName() + "___value" + "\" expr=\"try {" + record.getName() + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___confidence" + "\" expr=\"try {" + record.getName() + "$.confidence" + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___utterance" + "\" expr=\"try {" + record.getName() + "$.utterance" + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___duration" + "\" expr=\"try {" + record.getName() + "$.duration" + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___size" + "\" expr=\"try {" + record.getName() + "$.size" + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___termchar" + "\" expr=\"try {" + record.getName() + "$.termchar" + "} catch (errMsg) {'undefined'}\"/>");
        this.out.println("<assign name=\"" + record.getName() + "___maxtime" + "\" expr=\"try {" + record.getName() + "$.maxtime" + "} catch (errMsg) {'undefined'}\"/>");
    }

    private void genTransferAssigns(Transfer transfer, String value) {
        if (transfer.getTransferType() == Transfer.TransferType.BRIDGED) {
            this.out.println("<assign name=\"" + transfer.getName() + "___value" + "\" expr=\"try {" + value + "} catch (errMsg) {'undefined'}\"/>");
            this.out.println("<assign name=\"" + transfer.getName() + "___duration" + "\" expr=\"try {" + transfer.getName() + "$.duration" + "} catch (errMsg) {'undefined'}\"/>");
            this.out.println("<assign name=\"" + transfer.getName() + "___utterance" + "\" expr=\"try {" + transfer.getName() + "$.utterance" + "} catch (errMsg) {'undefined'}\"/>");
            this.out.println("<assign name=\"" + transfer.getName() + "___inputmode" + "\" expr=\"try {" + transfer.getName() + "$.inputmode" + "} catch (errMsg) {'undefined'}\"/>");
        }
        if (transfer.getTransferType() == Transfer.TransferType.CONSULTATION) {
            this.out.println("<assign name=\"" + transfer.getName() + "\" expr=\"try {" + value + "} catch (errMsg) {'undefined'}\"/>");
        }
    }

    private void genRootAssigns(Submit submit, String name) {
        this.out.println("<var name=\"" + name + "___noinputcount" + "\" expr=\"try {" + "_avayaNoinputCounter" + "} catch (errMsg) {'0'}\"/>");
        this.out.println("<var name=\"" + name + "___nomatchcount" + "\" expr=\"try {" + "_avayaNomatchCounter" + "} catch (errMsg) {'0'}\"/>");
        submit.addToSubmitList(name + "___noinputcount");
        submit.addToSubmitList(name + "___nomatchcount");
    }

    @Override
    public void handlerBegin(Handler handler) {
        boolean skipRootAssigns = false;
        this.out.println("<catch event=\"" + handler.getType() + "\">");
        if (handler.getRecord() != null) {
            this.genRecordAssigns(handler.getRecord());
            skipRootAssigns = true;
        }
        if (handler.getTransfer() != null) {
            this.genTransferAssigns(handler.getTransfer(), handler.getValue());
            skipRootAssigns = true;
        }
        if (handler.getSubmitObject() == null) {
            Submit submit = new Submit(handler.getNext());
            handler.setSubmitObject(submit);
            handler.setSubmit(true);
            String name = "avayadonotsave";
            submit.setSubmitName(name);
            if (handler.isSubmit()) {
                this.genRootAssigns(submit, name);
            }
        } else {
            Submit submit = handler.getSubmitObject();
            String name = submit.getSubmitName();
            if (name != null && !skipRootAssigns && handler.isSubmit()) {
                this.genRootAssigns(submit, name);
            }
        }
    }

    @Override
    public void handlerEnd(Handler handler) {
        this.out.println("</catch>");
    }

    private String xmlEscapeString(String source, boolean forVXMLExpression, boolean valueIsExpression) {
        boolean removedSingleQuotes = false;
        if (valueIsExpression && source.charAt(0) == '\'' && source.charAt(source.length() - 1) == '\'') {
            source = source.substring(1, source.length() - 1);
            removedSingleQuotes = true;
        }
        source = source.replaceAll("&", "&amp;");
        if (forVXMLExpression && removedSingleQuotes) {
            source = source.replaceAll("'", "\\\\'");
            source = source.replaceAll("\"", "\\\\\"");
        }
        source = source.replaceAll("'", "&apos;");
        source = source.replaceAll("\"", "&quot;");
        source = source.replaceAll("<", "&lt;");
        source = source.replaceAll(">", "&gt;");
        if (removedSingleQuotes) {
            source = "'" + source + "'";
        }
        return source;
    }

    @Override
    public void rootBegin(Root root) {
        this.out.println("<script>");
        this.out.println("function getnbest(  item, nbest ) {");
        this.out.println("    var len = application.lastresult$.length;");
        this.out.println("    var result = \"\";");
        this.out.println("    ");
        this.out.println("    if ( len &gt; nbest) {");
        this.out.println("        len = nbest;");
        this.out.println("    }");
        this.out.println("    for (var i = 0; i &lt; len; i++) {");
        this.out.println("        if (i &gt; 0) {");
        this.out.println("            result += \" " + this.mySession.getPlatformSettings().getCollectionSeparator() + "\";");
        this.out.println("        }");
        this.out.println("        var temp  =  \"application.lastresult$[\" + i + \"].\" + item;");
        this.out.println("        result += extractprops( \"\", eval(temp));");
        this.out.println("    }");
        this.out.println("    return result;");
        this.out.println("}");
        this.out.println("");
        this.out.println("function getnbestnmni(  item, nbest ) {");
        this.out.println("    var len = application.lastresult$.length;");
        this.out.println("    var result = \"\";");
        this.out.println("    ");
        this.out.println("    if ( len &gt; nbest) {");
        this.out.println("        len = nbest;");
        this.out.println("    }");
        this.out.println("    for (var i = 0; i &lt; len; i++) {");
        this.out.println("        if (i &gt; 0) {");
        this.out.println("            result += \" " + this.mySession.getPlatformSettings().getCollectionSeparator() + "\";");
        this.out.println("        }");
        this.out.println("        result += item;");
        this.out.println("    }");
        this.out.println("    return result;");
        this.out.println("}");
        this.out.println("");
        this.out.println("function extractprops ( parent, obj ) {");
        this.out.println("    var prop, name, result = \"\";");
        this.out.println("    var count = 1;");
        this.out.println("    if ( typeof ( obj ) == \"object\" ) {");
        this.out.println("        for ( prop in obj ) {");
        this.out.println("            name = parent + prop;");
        this.out.println("            if ( typeof ( obj [ prop ] ) == \"object\" ) {");
        this.out.println("                result += extractprops( name+\".\", obj [ prop ] );");
        this.out.println("            } else {");
        this.out.println("                if (count == 1) {");
        this.out.println("                    result = obj [ prop ];");
        this.out.println("                } else {");
        this.out.println("                    result += \" \" + obj [ prop ];");
        this.out.println("                }");
        this.out.println("            }");
        this.out.println("            count = count + 1;");
        this.out.println("        }");
        this.out.println("    } else {");
        this.out.println("        if (obj == undefined ) {");
        this.out.println("            result +=  \"undefined\";");
        this.out.println("        } else {");
        this.out.println("            result +=  obj;");
        this.out.println("        }");
        this.out.println("    }");
        this.out.println("    return result;");
        this.out.println("}");
        this.out.println("");
        this.out.println("function startswith ( value, startwith ) {");
        this.out.println("    var index;");
        this.out.println("    index = value.indexOf(startwith, 0);");
        this.out.println("    if ( index == 0 ) {");
        this.out.println("       return true;");
        this.out.println("    } else {");
        this.out.println("       return false;");
        this.out.println("    }");
        this.out.println("}");
        this.out.println("");
        this.out.println("function containsUndefined ( value ) {");
        this.out.println("    var index;");
        this.out.println("    index = value.indexOf('undefined', 0);");
        this.out.println("    if ( index == -1 ) {");
        this.out.println("       return false;");
        this.out.println("    } else {");
        this.out.println("       return true;");
        this.out.println("    }");
        this.out.println("}");
        this.out.println("");
        this.out.println("</script>");
        this.genCaptureScript();
        this.generateExitInfo();
        this.out.println("<var name=\"_avayaNoinputCounter\" expr=\"0\"/>");
        this.out.println("<var name=\"_avayaNomatchCounter\" expr=\"0\"/>");
    }

    @Override
    public void rootEnd(Root root) {
        this.out.println("<meta name=\"marker\" content=\"Avaya Aura Orchestration Designer Root End\"/>");
    }

    @Override
    public void propertyBegin(Property property) {
        String value;
        if (property.getName().equals("fetchaudio")) {
            Prompt fetchAudio = (Prompt)PromptFinder.load(property.getValue(), this.getMySession().getCurrentLanguage(), this.getMySession());
            value = this.getAudioURLFromAudioPrompt(fetchAudio);
        } else if (property.getName().equals("fetchtimeout")) {
            if (this.mySession.isRunInDebug()) {
                value = "3600s";
            } else {
                value = property.getValue();
                if (property.isVariable()) {
                    value = this.getVariable(value);
                }
            }
        } else {
            value = property.getValue();
            if (property.isVariable()) {
                value = this.getVariable(value);
            }
        }
        this.out.print("<property");
        this.genAttr("name", property.getName());
        if (property.isHexEncodeValue() && value.length() > 0) {
            value = property.isEPAACCHeader(value) ? "P-Intrinsics=" + this.stringToHex(property.getEPAACCHeaderValue(value)) : this.stringToHex(value);
        }
        this.genAttr("value", value);
        this.out.println(" />");
    }

    @Override
    public void propertyEnd(Property property) {
    }

    @Override
    public void blockBegin() {
        this.out.println("<block>");
    }

    @Override
    public void blockEnd() {
        this.out.println("</block>");
    }

    private void genVarForParam(Parameter param) {
        this.out.print("<var");
        this.genAttr("name", param.getName(), true);
        if (param.getMode() == 1) {
            this.genAttr("expr", "'" + this.xmlEscapeString(param.getValue(), true, false) + "'", true);
        } else if (param.getMode() == 3) {
            this.genAttr("expr", "'" + this.xmlEscapeString(this.getVariable(param.getValue()), true, false) + "'", true);
        } else if (param.getMode() == 2) {
            this.genAttr("expr", this.xmlEscapeString(param.getValue(), true, true), true);
        }
        this.out.println("/>");
    }

    private void genParamForParam(Parameter param) {
        this.out.print("<param");
        this.genAttr("name", param.getName(), true);
        if (param.getMode() == 1) {
            this.genAttr("value", this.xmlEscapeString(param.getValue(), false, false), true);
        } else if (param.getMode() == 3) {
            this.genAttr("value", this.xmlEscapeString(this.getVariable(param.getValue()), false, false), true);
        } else if (param.getMode() == 2) {
            this.genAttr("expr", this.xmlEscapeString(param.getValue(), true, true), true);
        }
        this.out.println("/>");
    }

    @Override
    public void disconnectBegin(Disconnect disconnect, Collection outParams) {
        if (outParams != null && this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            for (Parameter param : outParams) {
                this.genVarForParam(param);
            }
            this.out.print("<disconnect");
            StringBuffer sb = new StringBuffer();
            for (Parameter param : outParams) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(param.getName());
            }
            this.genAttr("namelist", sb.toString());
            this.out.println("/>");
        } else {
            this.out.println("<disconnect/>");
        }
    }

    @Override
    public void disconnectEnd(Disconnect disconnect) {
    }

    private void genVars(String name, int nBest, Collection<String> colNames, Collection<IRuntimeGrammar> grammars, boolean isMark, boolean isRecording) {
        this.out.print("<property");
        this.genAttr("name", "maxnbest");
        this.genAttr("value", Integer.toString(nBest));
        this.out.println("/>");
        this.out.print("<var");
        this.genAttr("name", "nbest");
        this.genAttr("expr", Integer.toString(nBest));
        this.out.println("/>");
        this.out.println("<var name=\"" + name + "___value" + "\"/>");
        this.out.println("<var name=\"" + name + "___confidence" + "\"/>");
        this.out.println("<var name=\"" + name + "___utterance" + "\"/>");
        this.out.println("<var name=\"" + name + "___inputmode" + "\"/>");
        this.out.println("<var name=\"" + name + "___interpretation" + "\" expr=\"'undefined'\"/>");
        this.out.println("<var name=\"" + name + "___noinputcount" + "\" expr=\"'0'\"/>");
        this.out.println("<var name=\"" + name + "___nomatchcount" + "\" expr=\"'0'\"/>");
        for (String slot : colNames) {
            this.out.println("<var name=\"" + name + "___" + slot + "\"/>");
        }
        for (IRuntimeGrammar gram : grammars) {
            if (!gram.isEnabled()) continue;
            this.out.println("<var name=\"graminterp___" + gram.getClass().getSimpleName() + "\" expr=\"'undefined'\"/>");
        }
        if (isMark) {
            this.out.println("<var name=\"" + name + "___markname" + "\"/>");
            this.out.println("<var name=\"" + name + "___marktime" + "\"/>");
        }
        if (isRecording) {
            this.out.println("<var name=\"" + name + "___recording" + "\"/>");
            this.out.println("<var name=\"" + name + "___recordingsize" + "\"/>");
            this.out.println("<var name=\"" + name + "___recordingduration" + "\"/>");
        }
    }

    @Override
    public void fieldBegin(Field field, Collection prompts) {
        if (field.isRecordUtterance()) {
            this.mySession.setProperty("___sagerecordutterancenameinfo", (Object)field.getName());
        }
        this.mySession.setProperty("___sagenomatchnoinputnameinfo", (Object)field.getName());
        this.promptPreGen(prompts);
        this.genVars(field.getName(), field.getNBest(), field.getUniqueColNames(), field.getGrammars(), field.isCaptureMark(), field.isRecordUtterance());
        this.out.print("<field");
        this.genAttr("name", field.getName());
        this.genAttr("modal", field.isModal());
        this.out.println(">");
        if (this.mySession.getPlatformSettings().getVxml().equals("2.1") && field.isRecordUtterance()) {
            this.out.print("<property");
            this.genAttr("name", "recordutterance");
            this.genAttr("value", "true");
            this.out.println(" />");
        }
    }

    private void genInterpForNonScriptedGrammars(String name, Collection<IRuntimeGrammar> grammars) {
        for (IRuntimeGrammar gram : grammars) {
            List<String> colNames;
            if (!gram.isEnabled() || (colNames = gram.getColumnIds()).size() <= 0) continue;
            this.out.print("<assign name=\"graminterp___" + gram.getClass().getSimpleName() + "\" expr=\"");
            boolean first = true;
            for (String slot : colNames) {
                if (first) {
                    this.out.print(name + "___" + slot);
                    first = false;
                    continue;
                }
                this.out.print(" + ' ' + " + name + "___" + slot);
            }
            this.out.println("\"/>");
        }
        ArrayList<IRuntimeGrammar> sortedGrammars = new ArrayList<IRuntimeGrammar>(grammars);
        Collections.sort(sortedGrammars, new Comparator<IRuntimeGrammar>(){

            @Override
            public int compare(IRuntimeGrammar g1, IRuntimeGrammar g2) {
                int n2;
                int n1 = g1.getColumnIds().size();
                if (n1 == (n2 = g2.getColumnIds().size())) {
                    return 0;
                }
                if (n2 > n1) {
                    return -1;
                }
                return 1;
            }
        });
        for (IRuntimeGrammar gram : sortedGrammars) {
            if (!gram.isEnabled() || gram.getColumnIds().size() <= 0) continue;
            this.out.println("<if cond=\"containsUndefined(graminterp___" + gram.getClass().getSimpleName() + ") == false\">");
            this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"graminterp" + "___" + gram.getClass().getSimpleName() + "\"/>");
            this.out.println("</if>");
        }
    }

    private void genAssignsVars(String name, Collection<String> uniqueColNames, Collection<IRuntimeGrammar> grammars, boolean isMarking, boolean isRecordUtterance) {
        String genType = (String)SCERT.ASR_TYPES_MAP.get(this.mySession.getPlatformSettings().getASR());
        if (uniqueColNames != null && uniqueColNames.size() > 0) {
            this.out.println("<assign name=\"" + name + "___confidence" + "\" expr=\"getnbest('" + "confidence" + "', nbest)\"/>");
            this.out.println("<assign name=\"" + name + "___utterance" + "\" expr=\"getnbest('" + "utterance" + "', nbest)\"/>");
            this.out.println("<assign name=\"" + name + "___inputmode" + "\" expr=\"getnbest('" + "inputmode" + "', nbest)\"/>");
            for (String slot : uniqueColNames) {
                this.out.println("<assign name=\"" + name + "___" + slot + "\" expr=\"getnbest('" + "interpretation" + "." + slot + "', nbest)\"/>");
            }
            if (genType.equals("SRGS-Literals")) {
                this.genInterpForNonScriptedGrammars(name, grammars);
            } else {
                this.out.println("<if cond=\"" + name + "___inputmode" + " == 'dtmf'\">");
                this.genInterpForNonScriptedGrammars(name, grammars);
                this.out.println("<else/>");
                this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + ".cxtag', nbest)\"/>");
                this.out.println("</if>");
            }
        } else {
            this.out.println("<assign name=\"" + name + "___confidence" + "\" expr=\"getnbest('" + "confidence" + "', nbest)\"/>");
            this.out.println("<assign name=\"" + name + "___utterance" + "\" expr=\"getnbest('" + "utterance" + "', nbest)\"/>");
            this.out.println("<assign name=\"" + name + "___inputmode" + "\" expr=\"getnbest('" + "inputmode" + "', nbest)\"/>");
            if (genType.equals("SRGS-Literals")) {
                this.out.println("<assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + "', nbest)\"/>");
            } else {
                this.out.println("<if cond=\"" + name + "___inputmode" + " == 'dtmf'\">");
                if (this.mySession.getPlatformSettings().getDTMFNative() == PlatformSettings.DTMFMode.LOCAL_SRGS_LITERALS) {
                    this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + "', nbest)\"/>");
                } else {
                    this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + ".cxtag', nbest)\"/>");
                }
                this.out.println("<else/>");
                this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + ".cxtag', nbest)\"/>");
                this.out.println("</if>");
            }
        }
        this.out.println("<if cond=\"startswith(" + name + "___interpretation" + ", 'undefined') == true \">");
        this.out.println("    <assign name=\"" + name + "___interpretation" + "\" expr=\"getnbest('" + "interpretation" + "', nbest)\"/>");
        this.out.println("</if>");
        this.out.println("<assign name=\"" + name + "___value" + "\" expr=\"" + name + "___interpretation" + "\"/>");
        if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            if (isMarking) {
                this.out.println("<assign name=\"" + name + "___markname" + "\" expr=\"application.lastresult$.markname\"/>");
                this.out.println("<assign name=\"" + name + "___marktime" + "\" expr=\"application.lastresult$.marktime\"/>");
            }
            if (isRecordUtterance) {
                this.out.println("<assign name=\"" + name + "___recording" + "\" expr=\"try {application.lastresult$.recording} catch (errMsg) {'undefined'}\"/>");
                this.out.println("<assign name=\"" + name + "___recordingsize" + "\" expr=\"try {objectToString(application.lastresult$.recordingsize)} catch (errMsg) {'undefined'}\"/>");
                this.out.println("<assign name=\"" + name + "___recordingduration" + "\" expr=\"try {objectToString(application.lastresult$.recordingduration)} catch (errMsg) {'undefined'}\"/>");
            }
        }
        this.out.println("<assign name=\"" + name + "___noinputcount" + "\" expr=\"getnbestnmni(" + "_avayaNoinputCounter" + ", nbest)\"/>");
        this.out.println("<assign name=\"" + name + "___nomatchcount" + "\" expr=\"getnbestnmni(" + "_avayaNomatchCounter" + ", nbest)\"/>");
    }

    @Override
    public void fieldEnd(Field field) {
        this.out.println("<filled>");
        this.genAssignsVars(field.getName(), field.getUniqueColNames(), field.getGrammars(), field.isCaptureMark(), field.isRecordUtterance());
        this.out.println("</filled>");
        this.out.println("</field>");
    }

    @Override
    public void submitBegin(Submit submit, Collection submitList) {
        Collection vxmlContribClassNames = (Collection)this.mySession.getProperty("___sagertVXMLContrib");
        ArrayList<String> additionalNames = new ArrayList<String>();
        if (vxmlContribClassNames != null) {
            for (String className : vxmlContribClassNames) {
                try {
                    IPluggableConnectorVXMLContribution pdcVXMLContrib = (IPluggableConnectorVXMLContribution)Class.forName(className).newInstance();
                    this.out.println("<!-- BEGIN " + pdcVXMLContrib.getId() + " -->");
                    Collection<String> names = pdcVXMLContrib.addToSubmitList(this.mySession, this.out);
                    if (names != null) {
                        additionalNames.addAll(names);
                    }
                    this.out.println("<!-- END " + pdcVXMLContrib.getId() + " -->");
                }
                catch (Exception e) {
                    String message = "Error invoking PluggableConnectorInitialize class [" + className + "] for application started ";
                    ReportInfo.alarm("Error", message, e, this.mySession);
                    this.mySession.throwRTException(message, e);
                }
            }
        }
        this.out.print("<submit");
        this.genAttr("next", this.getNextUrl(submit.getNext()));
        if (!submitList.isEmpty() || !additionalNames.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (String name : submitList) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(name);
            }
            for (String name : additionalNames) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(name);
            }
            this.genAttr("namelist", sb.toString());
            this.genAttr("method", submit.isPost() ? "post" : "get");
            this.genAttr("enctype", submit.getEncodingType());
        }
        this.out.println("/>");
    }

    @Override
    public void submitEnd(Submit submit) {
    }

    @Override
    public void platformObjectBegin(PlatformObject platformObject, Collection prompts) {
        this.promptPreGen(prompts);
        for (String varName : platformObject.getShadowVariables()) {
            this.out.println("<var name=\"" + platformObject.getName() + "___" + varName + "\"/>");
        }
        this.out.print("<object");
        this.genAttr("name", platformObject.getName());
        this.genAttr("classid", platformObject.getClassId());
        this.genAttr("data", platformObject.getData());
        this.genAttr("type", platformObject.getType());
        this.genAttr("codebase", platformObject.getCodeBase());
        this.genAttr("codetype", platformObject.getCodeType());
        this.genAttr("archive", platformObject.getArchive());
        this.out.println(">");
        Collection<Parameter> params = platformObject.getParams();
        for (Parameter param : params) {
            this.genParamForParam(param);
        }
    }

    @Override
    public void platformObjectEnd(PlatformObject platformObject) {
        this.out.println("<filled>");
        for (String varName : platformObject.getShadowVariables()) {
            this.out.println("<assign name=\"" + platformObject.getName() + "___" + varName + "\" expr=\"" + platformObject.getName() + "." + varName + "\"/>");
        }
        this.out.println("</filled>");
        this.out.println("</object>");
    }

    @Override
    public void recordBegin(Record record, Collection prompts) {
        this.promptPreGen(prompts);
        this.out.println("<var name=\"" + record.getName() + "___value" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___confidence" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___utterance" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___duration" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___size" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___termchar" + "\"/>");
        this.out.println("<var name=\"" + record.getName() + "___maxtime" + "\"/>");
        this.out.print("<record");
        this.genAttr("name", record.getName());
        this.genAttr("beep", record.isBeep());
        this.genAttr("maxtime", record.getMaxtime());
        this.genAttr("modal", record.isModal());
        this.genAttr("finalsilence", record.getFinalSilence());
        this.genAttr("dtmfterm", record.isDtfmTerm());
        this.genAttr("type", record.getType());
        if (!this.mySession.getPlatformSettings().getVxml().equals("2.0") && !this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.genAttr("recordmodes", record.getMode());
        }
        this.out.println(">");
    }

    @Override
    public void recordEnd(Record record) {
        this.out.println("<filled>");
        this.genRecordAssigns(record);
        this.out.println("</filled>");
        this.out.println("</record>");
    }

    private String getAudioURLFromAudioPrompt(Prompt audioPrompt) {
        String audioURL = null;
        try {
            if (audioPrompt != null) {
                ArrayList<PromptElement> list = audioPrompt.getElements(1);
                PromptElement promptElement = list.get(0);
                Phrase phrase = promptElement.getPhrase();
                audioURL = phrase.getURL();
            }
        }
        catch (Exception e) {
            this.mySession.throwRTException("Invalid transfer audio, must be a prompt with one prompt level and one element that is a phrase", e);
        }
        return audioURL;
    }

    @Override
    public void transferBegin(Transfer transfer, Collection prompts) {
        String timeout;
        String xferAudio;
        block34: {
            this.promptPreGen(prompts);
            if (transfer.getTransferType() == Transfer.TransferType.BRIDGED) {
                this.out.println("<var name=\"" + transfer.getName() + "___value" + "\"/>");
                this.out.println("<var name=\"" + transfer.getName() + "___duration" + "\"/>");
                this.out.println("<var name=\"" + transfer.getName() + "___inputmode" + "\"/>");
                this.out.println("<var name=\"" + transfer.getName() + "___utterance" + "\"/>");
            }
            this.out.print("<transfer");
            this.genAttr("name", transfer.getName());
            String destNumber = null;
            if (transfer.getDestType() == 1) {
                destNumber = transfer.getDestNumber();
            } else if (transfer.getDestType() == 2) {
                destNumber = this.getVariable(transfer.getDestNumber());
            } else {
                this.mySession.throwRTException("Invalid transfer phone number type");
            }
            if (!(destNumber.toLowerCase().startsWith("tel:") || destNumber.toLowerCase().startsWith("sip:") || destNumber.toLowerCase().startsWith("sips:"))) {
                destNumber = "tel:" + destNumber;
            }
            xferAudio = this.getAudioURLFromAudioPrompt(transfer.getXferAudio());
            this.genAttr("dest", destNumber);
            if (this.mySession.getPlatformSettings().getVxml().equals("2.0")) {
                if (transfer.getTransferType() == Transfer.TransferType.BRIDGED) {
                    this.genAttr("bridge", "true");
                } else if (transfer.getTransferType() == Transfer.TransferType.BLIND) {
                    this.genAttr("bridge", "false");
                } else if (transfer.getTransferType() == Transfer.TransferType.CONSULTATION) {
                    this.genAttr("bridge", "false");
                }
            } else if (transfer.getTransferType() == Transfer.TransferType.BRIDGED) {
                this.genAttr("type", "bridge");
            } else if (transfer.getTransferType() == Transfer.TransferType.BLIND) {
                this.genAttr("type", "blind");
            } else if (transfer.getTransferType() == Transfer.TransferType.CONSULTATION) {
                this.genAttr("type", "consultation");
            }
            timeout = null;
            if (transfer.getTimeoutType() == 1) {
                timeout = transfer.getConnectTimeout();
            } else {
                if (transfer.getTimeoutType() == 2) {
                    timeout = this.getVariable(transfer.getConnectTimeout());
                    if (!timeout.endsWith("s")) {
                        timeout = timeout + "s";
                    }
                    String tmp = null;
                    if (timeout.endsWith("ms")) {
                        tmp = timeout.substring(0, timeout.length() - 2);
                    } else if (timeout.endsWith("s")) {
                        tmp = timeout.substring(0, timeout.length() - 1);
                    }
                    try {
                        if (Integer.parseInt(tmp) < 0) {
                            throw new NumberFormatException("Timeout must be positive.");
                        }
                        break block34;
                    }
                    catch (NumberFormatException e) {
                        throw new SCERuntimeException("Invalid connect timeout value: \"" + timeout + "\". Timeout must be a positive integer with an optional \"s\" or \"ms\" suffix, such as \"10s\".");
                    }
                }
                this.mySession.throwRTException("Invalid transfer phone number type");
            }
        }
        this.genAttr("connecttimeout", timeout);
        if (transfer.getTransferType() != Transfer.TransferType.CONSULTATION) {
            this.genAttr("maxtime", transfer.getMaxTime());
        }
        this.genAttr("transferaudio", xferAudio);
        String aai = "";
        if (transfer.getAaiType() == 1) {
            aai = transfer.getAai();
        } else if (transfer.getAaiType() == 2) {
            aai = this.getVariable(transfer.getAai());
        } else {
            this.mySession.throwRTException("Invalid transfer aai type");
        }
        String ucidStr = "";
        if (transfer.getUcidVar() != null && transfer.getUcidVar().length() > 0) {
            ucidStr = this.getVariable(transfer.getUcidVar());
        }
        aai = transfer.checkHexEncodeAAIForAACC(aai, ucidStr);
        this.genAttr("aai", aai);
        this.out.println(">");
    }

    @Override
    public void transferEnd(Transfer transfer) {
        this.out.println("<filled>");
        this.genTransferAssigns(transfer, transfer.getName());
        this.out.println("</filled>");
        this.out.println("</transfer>");
    }

    @Override
    public void eventBegin(Event event, int count, boolean isSingle) {
        this.out.print("<catch");
        String eventType = event.getType();
        this.genAttr("event", eventType);
        if (!isSingle) {
            this.genAttr("count", Integer.toString(count));
        }
        this.out.println(">");
        if (eventType.indexOf("nomatch") != -1) {
            this.out.println("<assign name=\"_avayaNomatchCounter\" expr=\"_avayaNomatchCounter + 1\"/>");
        }
        if (eventType.indexOf("noinput") != -1) {
            this.out.println("<assign name=\"_avayaNoinputCounter\" expr=\"_avayaNoinputCounter + 1\"/>");
        }
    }

    @Override
    public void eventMiddle(Event event) {
        this.out.println("<reprompt/>");
    }

    @Override
    public void eventEnd(Event event) {
        this.out.println("</catch>");
    }

    @Override
    public void mixedInitiativeFormBegin(MixedInitiativeForm form) {
    }

    @Override
    public void mixedInitiativeFormEnd(MixedInitiativeForm Form2) {
    }

    @Override
    public void programmErrorBegin(String message, Throwable e) {
        StringBuffer buf = new StringBuffer();
        buf.append(message);
        buf.append(", ");
        String exceptionStr = e.toString();
        int index = exceptionStr.indexOf("**** Root Cause");
        if (index != -1) {
            buf.append(exceptionStr.substring(0, index));
        } else {
            buf.append(exceptionStr);
        }
        this.out.println("<form>");
        this.out.println("<block>");
        this.out.println("<throw ");
        this.genAttr("event", "error.runtime." + e.getClass().getCanonicalName());
        this.genAttr("message", IO.sanitizeString((String)buf.toString(), (String)"./:?,"));
        this.out.println("/>");
        this.out.println("</block>");
        this.out.println("</form>");
    }

    @Override
    public void programmErrorEnd(String message, Throwable e) {
        try {
            boolean foundHandler = false;
            Root root = (Root)((Object)FlowFinder.getFlowFinder(this.mySession.getCurrentLanguage()).getInstance(this.mySession.getCurrentRootDoc()));
            Collection events = root.getEvents(this.mySession);
            for (Event handler : events) {
                if (!handler.getType().equalsIgnoreCase("error") && !handler.getType().toLowerCase().startsWith("error.runtime") && !handler.getType().equalsIgnoreCase(".")) continue;
                foundHandler = true;
            }
            if (!foundHandler) {
                boolean rootInline = this.mySession.getRuntimePropertyEnabled("xmlrootinline");
                if (!this.mySession.isTerminationURLEnabled()) {
                    if (rootInline) {
                        this.mySession.setExitTimer();
                    } else {
                        this.mySession.setRemoveSessionPending();
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void genCaptureScript() {
        this.out.println("<script>");
        this.out.println("function objectToString(  obj ) {");
        this.out.println("    try {");
        this.out.println("    var result = \"\";");
        this.out.println("    result += getobjectprops( \"\", obj);");
        this.out.println("    if (result.charAt(0) == '" + this.mySession.getPlatformSettings().getCollectionSeparator() + "' ) {");
        this.out.println("        result = result.substring(1);");
        this.out.println("    } ");
        this.out.println("    } catch (errMsg) {");
        this.out.println("        return(\"undefined\");");
        this.out.println("    }");
        this.out.println("    return result;");
        this.out.println("}");
        this.out.println("");
        this.out.println("function getobjectprops ( parent, obj ) {");
        this.out.println("    var prop, name, result = \"\";");
        this.out.println("    if ( typeof ( obj ) == \"object\" ) { ");
        this.out.println("        for ( prop in obj ) { ");
        this.out.println("            name = parent + prop;");
        this.out.println("            if ( typeof ( obj [ prop ] ) == \"object\" ) {");
        this.out.println("                result += extractprops( name+\".\", obj [ prop ] );");
        this.out.println("            } else { ");
        this.out.println("                result +=   \"" + this.mySession.getPlatformSettings().getCollectionSeparator() + "\"  + obj [ prop ]; ");
        this.out.println("            } ");
        this.out.println("        } ");
        this.out.println("    } else { ");
        this.out.println("        if (obj == undefined ) { ");
        this.out.println("           result +=  \"undefined\"; ");
        this.out.println("        } else { ");
        this.out.println("           result +=  obj; ");
        this.out.println("        } ");
        this.out.println("    } ");
        this.out.println("    return result;");
        this.out.println("}");
        this.out.println("</script>");
    }

    private void runAsSubdialogBegin(Entry entry) {
        Collection inputParams = entry.getInputParams(this.getMySession());
        if (inputParams != null) {
            for (String param : inputParams) {
                this.out.print("<var");
                this.genAttr("name", param);
                this.out.println("/>");
            }
        }
    }

    private void runAsSubdialogEnd(Entry entry) {
    }

    private void runAsInitialAppBegin(Entry entry) {
        this.out.println("<script>");
        this.out.println("function getArray( arrayName, item ) {");
        this.out.println("    try {");
        this.out.println("        var len = eval( arrayName +'.length;');");
        this.out.println("        var result = \"\";");
        this.out.println("    ");
        this.out.println("        for (var i = 0; i &lt; len; i++) {");
        this.out.println("            if (i &gt; 0) {");
        this.out.println("                result += \" " + this.mySession.getPlatformSettings().getCollectionSeparator() + "\";");
        this.out.println("            }");
        this.out.println("            var temp  =  arrayName + \"[\" + i + \"].\" + item;");
        this.out.println("            result += eval(temp);");
        this.out.println("        }");
        this.out.println("        return result;");
        this.out.println("    } catch (errMsg) {");
        this.out.println("            return('unknown');");
        this.out.println("    }");
        this.out.println("}");
        this.out.println("function getRedirect( item ) {");
        this.out.println("    return(getArray('session.connection.redirect', item));");
        this.out.println("}");
        this.out.println("function getShareduui( item ) {");
        this.out.println("    return(getArray('session.avaya.uui.shared', item));");
        this.out.println("}");
        this.out.println("function getScriptItem( item ) {");
        this.out.println("    try {");
        this.out.println("        var result = \"\";");
        this.out.println("        result += eval(item);");
        this.out.println("        return result;");
        this.out.println("    } catch (errMsg) {");
        this.out.println("        return('unknown');");
        this.out.println("    }");
        this.out.println("}");
        if (this.mySession.getPlatformSettings().getPlatform().equals("IR")) {
            this.out.println("function getUUIName() {");
            this.out.println("    try {");
            this.out.print("        if ( ");
            this.out.print("session___protocolname");
            this.out.println(" != 'unknown' ) {");
            this.out.print("            var temp = '");
            this.out.print("session.connection.protocol.");
            this.out.print("'+ ");
            this.out.print("session___protocolname");
            this.out.print(" +'");
            this.out.print(".uui");
            this.out.println("';");
            this.out.println("            return(eval(temp));");
            this.out.println("        } else {");
            this.out.println("            return('unknown');");
            this.out.println("        }");
            this.out.println("    } catch (errMsg) {");
            this.out.println("            return('unknown');");
            this.out.println("    }");
            this.out.println("}");
        }
        if (!this.mySession.getPlatformSettings().getPlatform().equals("IR")) {
            this.out.println("function getSIPCallID() {");
            this.out.println("    try {");
            this.out.println("        var protocol = getScriptItem( 'session.connection.protocol.name' );");
            this.out.print("        if ( ");
            this.out.print("protocol");
            this.out.print(" == 'sip'  || ");
            this.out.print("protocol");
            this.out.println(" == 'SIP' ) {");
            this.out.print("            var temp = ");
            this.out.print("getScriptItem( 'session.connection.protocol.sip.callid' )");
            this.out.println(";");
            this.out.println("            return(temp);");
            this.out.println("        } else {");
            this.out.println("            return('unknown');");
            this.out.println("        }");
            this.out.println("    } catch (errMsg) {");
            this.out.println("            return('unknown');");
            this.out.println("    }");
            this.out.println("}");
        }
        this.out.println("</script>");
        for (SessionVarField field : Submit.sessionVarFields) {
            if (this.mySession.getPlatformSettings().getPlatform().equals("IR")) {
                this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getIRExpr() + "\"/>");
                continue;
            }
            if (this.mySession.getPlatformSettings().getPlatform().equals("Voice Portal")) {
                this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getVPExpr() + "\"/>");
                continue;
            }
            if (this.mySession.getPlatformSettings().getPlatform().equals("Experience Portal")) {
                this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getVPExpr() + "\"/>");
                continue;
            }
            if (this.mySession.getPlatformSettings().getPlatform().equals("Desktop")) {
                this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getDesktopExpr() + "\"/>");
                continue;
            }
            if (this.mySession.getPlatformSettings().getPlatform().equals("MPS")) {
                this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getMPSExpr() + "\"/>");
                continue;
            }
            this.out.println("<var name=\"" + field.getDDVar() + "\" expr=\"" + field.getOtherExpr() + "\"/>");
        }
    }

    private void runAsInitialAppEnd(Entry entry) {
    }

    @Override
    public void throwBegin(Throw event) {
        this.out.print("    <throw");
        this.genAttr("event", event.getName());
        this.genAttr("message", event.getMessageValue(this.getMySession()));
        this.out.println("/>");
    }

    @Override
    public void throwEnd(Throw event) {
    }

    private void genOutParmaVars(Collection outParams, boolean isLast) {
        VariableName varName;
        IVariable var;
        boolean sawComplex = false;
        for (Parameter param : outParams) {
            if (param.getMode() != 3 || !(var = this.mySession.getVariable((varName = new VariableName(param.getValue())).getVarName())).isComplexVariable() || varName.getFieldName() != null) continue;
            param.setComplex(true);
            sawComplex = true;
        }
        if (sawComplex) {
            if (!isLast) {
                this.genCaptureScript();
            }
            this.out.println("<script>");
            for (Parameter param : outParams) {
                if (param.getMode() != 3 || !param.isComplex()) continue;
                varName = new VariableName(param.getValue());
                var = this.mySession.getVariable(varName.getVarName());
                IComplexVariable cplxVar = var.getComplexVariable();
                String[] names = cplxVar.getFieldNames();
                this.out.println("function get" + param.getName() + "() {");
                this.out.println("    var temp = new Object();");
                for (int i = 0; i < names.length; ++i) {
                    IVariableField field = cplxVar.getField(names[i]);
                    this.out.println("    temp." + names[i] + " = '" + this.xmlEscapeString(field.getStringValue(), true, false) + "';");
                }
                this.out.println("return(temp);");
                this.out.println("}");
            }
            this.out.println("</script>");
        }
        for (Parameter param : outParams) {
            this.out.print("<var");
            this.genAttr("name", param.getName(), true);
            if (param.getMode() == 1) {
                this.genAttr("expr", this.xmlEscapeString("'" + param.getValue() + "'", true, true), true);
            } else if (param.getMode() == 3) {
                if (param.isComplex()) {
                    if (!isLast) {
                        this.genAttr("expr", "objectToString(get" + param.getName() + "())", true);
                    } else {
                        this.genAttr("expr", "get" + param.getName() + "()", true);
                    }
                } else {
                    IOutputGenerator.PrivacyKind kind = isLast ? IOutputGenerator.PrivacyKind.NONE : IOutputGenerator.PrivacyKind.ENCRYPT;
                    this.genAttr("expr", this.xmlEscapeString("'" + this.getVariableWithPrivacy(param.getValue(), kind) + "'", true, true), true);
                }
            } else if (param.getMode() == 2) {
                this.genAttr("expr", this.xmlEscapeString(param.getValue(), true, true), true);
            }
            this.out.println("/>");
        }
    }

    @Override
    public void completeBegin(Return complete, boolean isLast, Collection outParams) {
        if (outParams != null) {
            this.genOutParmaVars(outParams, isLast);
        }
        ArrayList<String> additionalNames = new ArrayList<String>();
        if (isLast) {
            Collection vxmlContribClassNames = (Collection)this.mySession.getProperty("___sagertVXMLContrib");
            if (vxmlContribClassNames != null) {
                for (String className : vxmlContribClassNames) {
                    try {
                        IPluggableConnectorVXMLContribution pdcVXMLContrib = (IPluggableConnectorVXMLContribution)Class.forName(className).newInstance();
                        this.out.println("<!-- BEGIN " + pdcVXMLContrib.getId() + " -->");
                        Collection<String> names = pdcVXMLContrib.addToExitList(this.mySession, this.out);
                        if (names != null) {
                            additionalNames.addAll(names);
                        }
                        this.out.println("<!-- END " + pdcVXMLContrib.getId() + " -->");
                    }
                    catch (Exception e) {
                        String message = "Error invoking PluggableConnectorInitialize class [" + className + "] for application started ";
                        ReportInfo.alarm("Error", message, e, this.mySession);
                        this.mySession.throwRTException(message, e);
                    }
                }
            }
            this.out.print("<exit");
            if (outParams == null) {
                outParams = new ArrayList<Parameter>();
            }
            outParams.add(new Parameter("_avayaExitReason", "", 1));
            outParams.add(new Parameter("_avayaExitInfo1", "", 1));
            outParams.add(new Parameter("_avayaExitInfo2", "", 1));
            outParams.add(new Parameter("_avayaExitCustomerId", "", 1));
            outParams.add(new Parameter("_avayaExitPreferredPath", "", 1));
            outParams.add(new Parameter("_avayaExitTopic", "", 1));
        } else {
            this.out.print("<return");
        }
        if (outParams != null || !additionalNames.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Parameter param : outParams) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(param.getName());
            }
            for (String name : additionalNames) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(name);
            }
            this.genAttr("namelist", sb.toString());
        }
        this.out.println("/>");
    }

    @Override
    public void completeEnd(Return complete, boolean isLast) {
        if (isLast) {
            // empty if block
        }
    }

    @Override
    public void entryBegin(Entry entry, boolean isInitialApp) {
        if (isInitialApp) {
            this.runAsInitialAppBegin(entry);
        } else {
            this.runAsSubdialogBegin(entry);
        }
    }

    @Override
    public void entryEnd(Entry entry, boolean isInitialApp) {
        if (isInitialApp) {
            this.runAsInitialAppEnd(entry);
        } else {
            this.runAsSubdialogEnd(entry);
        }
    }

    @Override
    public void invocationBegin(Invoke invoke, Collection inParams, Collection outParams) {
        String queryStr;
        if (outParams != null) {
            for (String param : outParams) {
                this.out.print("<var");
                this.genAttr("name", invoke.getName() + "___" + param);
                this.out.println("/>");
            }
        }
        String entry = invoke.getWebAppEntryPoint(this.mySession);
        String anchor = "";
        int index = entry.indexOf(35);
        if (index != -1) {
            anchor = entry.substring(index);
            entry = entry.substring(0, index);
        }
        if (!(queryStr = this.getNextUrl(entry)).startsWith("http")) {
            queryStr = "/" + queryStr;
        }
        boolean isScanSoftOSDM = this.isScanSoftOSDM(invoke);
        String namelist = "";
        if (!isScanSoftOSDM) {
            queryStr = queryStr + "&amp;sagecall=" + this.mySession.getCurrentLanguage();
            DebugInfo info = (DebugInfo)this.mySession.getProperty("com.avaya.sce.runtime.debuginfo");
            if (info != null && info.getRemotePort() != -1) {
                queryStr = queryStr + "&amp;sagecfhport=" + info.getRemotePort();
                queryStr = queryStr + "&amp;sagecfhhost=" + info.getRemoteHostName();
            }
        } else {
            queryStr = invoke.getWebAppEntryPoint(this.mySession);
            if (!queryStr.startsWith("http")) {
                queryStr = "/" + queryStr;
            }
        }
        if ((isScanSoftOSDM || invoke.passParamsAsNameList()) && inParams != null) {
            for (Object param : inParams) {
                if (namelist.length() > 0) {
                    namelist = namelist + " ";
                }
                namelist = namelist + ((Parameter)param).getName();
                this.genVarForParam((Parameter)param);
            }
        }
        if (anchor.length() != 0) {
            queryStr = queryStr + anchor;
        }
        this.out.print("<subdialog");
        this.genAttr("name", invoke.getName());
        this.genAttr("src", queryStr);
        this.genAttr("method", invoke.getSubmitMethod());
        if (isScanSoftOSDM || invoke.passParamsAsNameList()) {
            this.genAttr("namelist", namelist);
        }
        this.out.println(">");
        if (inParams != null && !isScanSoftOSDM && !invoke.passParamsAsNameList()) {
            for (Object param : inParams) {
                this.genParamForParam((Parameter)param);
            }
        }
        this.out.println("<filled>");
        if (outParams != null) {
            for (Object param : outParams) {
                this.out.print("<assign");
                this.genAttr("name", invoke.getName() + "___" + (String)param);
                this.genAttr("expr", invoke.getName() + "." + (String)param);
                this.out.println("/>");
            }
        }
        this.out.println("</filled>");
    }

    @Override
    public void invocationEnd(Invoke invoke) {
        this.out.println("</subdialog>");
    }

    protected void generateTextContent(String txt) {
        if (this.mySession.getRuntimePropertyEnabled("noescapeprompt")) {
            this.out.println(txt);
        } else {
            this.out.println(this.xmlEscapeString(txt, false, false));
        }
    }

    protected void generateExpressionContent(String expr, String fmt) {
        if (fmt.equals("audio")) {
            this.out.println("<audio expr= \"" + expr + "\"/>");
        } else {
            this.out.println("<value expr= \"" + this.xmlEscapeString(expr, true, true) + "\"/>");
        }
    }

    protected void generateXMLTagBegin(PromptElement element) {
        if (element.getText().startsWith("mark")) {
            if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
                this.out.print("<" + element.getText() + this.getValues(element) + ">");
            }
        } else {
            this.out.print("<" + element.getText() + this.getValues(element) + ">");
        }
    }

    protected void generateXMLTagEnd(PromptElement element) {
        if (element.getText().startsWith("mark")) {
            if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
                this.out.print("</" + element.getText() + ">");
            }
        } else {
            this.out.print("</" + element.getText() + ">");
        }
    }

    protected void generateXMLTagFull(PromptElement element) {
        if (element.getText().startsWith("mark")) {
            if (this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
                this.out.print("<" + element.getText() + this.getValues(element) + "/>");
            }
        } else {
            this.out.print("<" + element.getText() + this.getValues(element) + "/>");
        }
    }

    protected String getValues(PromptElement element) {
        Format format = element.getFormats();
        String values = "";
        if (format != null) {
            Iterator<String> iter = format.iterator();
            while (iter.hasNext()) {
                String key = iter.next();
                values = values + " " + key + "=\"" + format.get(key) + "\"";
            }
        }
        return values;
    }

    protected boolean isScanSoftOSDM(Invoke invoke) {
        return invoke.getOSDMModuleID() != null;
    }

    private void generateExitBlock(String formName) {
        this.out.print("<form");
        this.genAttr("id", formName);
        this.out.println(">");
        this.out.println("<block>");
        this.out.print("    <goto ");
        this.genAttr("next", this.getNextUrl("AvayaDefaultExitHandler"));
        this.out.println("/>");
        this.out.println("</block>");
        this.out.println("<catch event=\".\">");
        this.out.println("    <exit namelist=\"_avayaExitReason _avayaExitInfo1 _avayaExitInfo2 _avayaExitCustomerId _avayaExitPreferredPath _avayaExitTopic\"/>");
        this.out.println("</catch> ");
        this.out.println("</form>");
    }

    @Override
    public void returnErrorBegin(ReturnError returnError, Throw throwItem, boolean isLast, boolean isPostGen) {
        if (!isPostGen) {
            if (!isLast) {
                if (this.mySession.getTOSFrame().isLocalCall()) {
                    Submit submit = new Submit("AvayaReturnErrorHandler");
                    submit.setEncodingType("application/x-www-form-urlencoded");
                    submit.setPost(true);
                    if (throwItem != null) {
                        ArrayList<Throw> items = (ArrayList<Throw>)this.mySession.getProperty("___sagereturnerrorsavethrowitem");
                        if (items == null) {
                            items = new ArrayList<Throw>();
                            this.mySession.setProperty("___sagereturnerrorsavethrowitem", items);
                        }
                        throwItem.setEvent(returnError.getEvent());
                        items.add(throwItem);
                    }
                    submit.addToSubmitList("_event");
                    submit.addToSubmitList("_message");
                    submit.generate(this);
                } else if (throwItem != null) {
                    this.out.print("<return");
                    this.genAttr("event", throwItem.getName());
                    this.genAttr("messageexpr", throwItem.getMessageValue(this.getMySession()));
                    this.out.println("/>");
                } else {
                    this.out.println("<if cond=\"_message == undefined\">");
                    this.out.println("    <return eventexpr=\"_event\"/>");
                    this.out.println("<else/>");
                    this.out.println("    <return eventexpr=\"_event\" messageexpr=\"_message\"/>");
                    this.out.println("</if>");
                }
            } else {
                StringBuffer info = new StringBuffer();
                info.append("Generated a ReturnError from main application, application will exit when executed. ");
                if (throwItem != null) {
                    info.append("Returning event " + throwItem.getName() + " with message " + throwItem.getMessageValue(this.getMySession()));
                } else {
                    info.append("Returning caughtEvent");
                }
                ReportInfo.alarm("Warning", info.toString(), this.mySession);
                this.out.print("<goto ");
                this.genAttr("next", "#" + returnError.getFormName());
                this.out.println("/>");
            }
        } else if (isLast) {
            this.generateExitBlock(returnError.getFormName());
        }
    }

    @Override
    public void returnErrorEnd(ReturnError returnError, Throw throwItem, boolean isLast, boolean isPostGen) {
    }

    @Override
    public void exitActionBegin(ExitAction exitAction, boolean isPostGen) {
        if (!isPostGen) {
            this.out.print("<goto ");
            this.genAttr("next", "#" + exitAction.getFormName());
            this.out.println("/>");
        } else {
            this.generateExitBlock(exitAction.getFormName());
        }
    }

    @Override
    public void exitActionEnd(ExitAction exitAction, boolean isPostGen) {
    }

    @Override
    public void captureExpressionBegin(CaptureExpression captureExpression) {
        this.out.println("<var name=\"" + captureExpression.getSubmitName() + "\" expr=\"try {objectToString(" + captureExpression.getExpression() + ")} catch (errMsg) {'undefined'}\"/>");
    }

    @Override
    public void captureExpressionEnd(CaptureExpression captureExpression) {
    }

    @Override
    public void transferOnErrorBegin(TransferOnError transferOE, Collection prompts, boolean isPostGen) {
        if (!isPostGen) {
            this.out.print("<goto ");
            this.genAttr("next", "#" + transferOE.getFormName());
            this.out.println("/>");
        } else {
            this.out.print("<form");
            this.genAttr("id", transferOE.getFormName());
            this.out.println(">");
            this.promptPreGen(prompts);
            this.out.print("<transfer");
            this.genAttr("name", transferOE.getName());
            String destNumber = null;
            if (transferOE.getDestType() == 1) {
                destNumber = "tel:" + transferOE.getDestNumber();
            } else if (transferOE.getDestType() == 2) {
                destNumber = "tel:" + this.getVariable(transferOE.getDestNumber());
            } else {
                this.mySession.throwRTException("Invalid transfer phone number type");
            }
            this.genAttr("dest", destNumber);
            if (this.mySession.getPlatformSettings().getVxml().equals("2.0")) {
                this.genAttr("bridge", "false");
            } else {
                this.genAttr("type", "blind");
            }
            if (transferOE.getAaiType() == 1) {
                this.genAttr("aai", transferOE.getAai());
            } else if (transferOE.getAaiType() == 2) {
                this.genAttr("aai", this.getVariable(transferOE.getAai()));
            } else {
                this.mySession.throwRTException("Invalid transfer aai type");
            }
            this.out.println(">");
        }
    }

    @Override
    public void transferOnErrorEnd(TransferOnError transferOE, boolean isPostGen) {
        if (isPostGen) {
            String formName = "Exit" + System.currentTimeMillis();
            this.out.println("<catch event=\".\">");
            this.out.print("<goto ");
            this.genAttr("next", "#" + formName);
            this.out.println("/>");
            this.out.println("</catch> ");
            this.out.println("</transfer>");
            this.out.println("<block> ");
            this.out.print("<goto ");
            this.genAttr("next", "#" + formName);
            this.out.println("/>");
            this.out.println("</block> ");
            this.out.println("</form>");
            this.generateExitBlock(formName);
        }
    }

    @Override
    public void mediaParBegin(MediaPar mediaPar) {
        this.out.print("\t\t\t<par");
        if (mediaPar.getEndSync().length() > 0) {
            this.out.print(" endsync=\"" + mediaPar.getEndSync() + "\"");
        }
        if (mediaPar.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaPar.getFill() + "\"");
        }
        this.out.print(">\n");
    }

    @Override
    public void mediaSeqBegin(MediaSeq mediaSeq) {
        this.out.print("\t\t\t<seq");
        if (mediaSeq.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaSeq.getFill() + "\"");
        }
        this.out.print(">\n");
    }

    @Override
    public void mediaParEnd(MediaPar mediaPar) {
        this.out.print("\t\t\t</par>\n");
    }

    @Override
    public void mediaSeqEnd(MediaSeq mediaSeq) {
        this.out.print("\t\t\t</seq>\n");
    }

    @Override
    public void mediaRegionBegin(MediaRegion mediaRegion) {
        this.out.print("\t\t\t\t<region");
        this.out.print(" xml:id=\"" + mediaRegion.getName() + "\"");
        if (mediaRegion.getBkgnColor().length() > 0) {
            this.out.print(" backgroundColor=\"#" + mediaRegion.getBkgnColor() + "\"");
        }
        if (mediaRegion.getTop() > 0) {
            this.out.print(" top=\"" + mediaRegion.getTop() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getBottom() > 0) {
            this.out.print(" bottom=\"" + mediaRegion.getBottom() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getLeft() > 0) {
            this.out.print(" left=\"" + mediaRegion.getLeft() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getRight() > 0) {
            this.out.print(" right=\"" + mediaRegion.getRight() + mediaRegion.getUnit_tblr() + "\"");
        }
        if (mediaRegion.getWidth() > 0) {
            this.out.print(" width=\"" + mediaRegion.getWidth() + mediaRegion.getUnit_hw() + "\"");
        }
        if (mediaRegion.getHeight() > 0) {
            this.out.print(" height=\"" + mediaRegion.getHeight() + mediaRegion.getUnit_hw() + "\"");
        }
        if (mediaRegion.getFit().length() > 0) {
            this.out.print(" fit=\"" + mediaRegion.getFit() + "\"");
        }
        if (mediaRegion.getShowBkgn().length() > 0) {
            this.out.print(" showBackground=\"" + mediaRegion.getShowBkgn() + "\"");
        }
        if (mediaRegion.getzIndex() > 0) {
            this.out.print(" z-index=\"" + mediaRegion.getzIndex() + "\"");
        }
        if (mediaRegion.getFontFamily().length() > 0) {
            this.out.print(" textFontFamily=\"" + mediaRegion.getFontFamily() + "\"");
        }
        if (mediaRegion.getFontSize().length() > 0) {
            this.out.print(" textFontSize=\"" + mediaRegion.getFontSize() + "\"");
        }
        if (mediaRegion.getFontColor().length() > 0) {
            this.out.print(" textColor=\"#" + mediaRegion.getFontColor() + "\"");
        }
        if (mediaRegion.getFontBkgnColor().length() > 0) {
            this.out.print(" textBackgroundColor=\"#" + mediaRegion.getFontBkgnColor() + "\"");
        }
        this.out.print("/>\n");
    }

    @Override
    public void SMILLinkBegin(SMILLink smilLink) {
        this.out.print("<media");
        if (smilLink.getExternal().length() > 0) {
            this.out.print(" src=\"" + smilLink.getExternal() + "\"/");
        } else if (smilLink.getLocal().length() > 0) {
            this.out.print(" src=\"" + smilLink.getLocalURL() + "\"/");
        } else {
            this.out.print(" src=\"" + smilLink.resolveVarField() + "\"/");
        }
        this.out.print(">\n");
    }

    @Override
    public void mediaPageBegin(MediaPage mediaPage) {
        if (this.mySession.getPlatformSettings().getVxml().equals("2.0") || this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.mySession.throwRTException("<media> tag requires project to be VXML 2.1 + IVVR compatible or higher");
            return;
        }
        this.out.print("<media type=\"" + mediaPage.getSMILType() + "\">\n");
        this.out.print("\t<![CDATA[");
        this.out.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.out.print("\t" + mediaPage.getDoctype() + "\n");
        this.out.print("\t<smil xmlns=\"" + mediaPage.getNamespace() + "\">\n");
        if (mediaPage.getRegions().size() > 0 || mediaPage.getBkgnColor().length() > 0 || mediaPage.getWidth() > 0 || mediaPage.getHeight() > 0) {
            this.out.print("\t\t<head>\n");
            this.out.print("\t\t\t<layout>\n");
            if (mediaPage.getBkgnColor().length() > 0 || mediaPage.getWidth() > 0 || mediaPage.getHeight() > 0) {
                this.out.print("\t\t\t\t<root-layout");
                if (mediaPage.getBkgnColor().length() > 0) {
                    this.out.print(" backgroundColor=\"#" + mediaPage.getBkgnColor() + "\"");
                }
                if (mediaPage.getWidth() > 0) {
                    this.out.print(" width=\"" + mediaPage.getWidth() + mediaPage.getUnit() + "\"");
                }
                if (mediaPage.getHeight() > 0) {
                    this.out.print(" height=\"" + mediaPage.getHeight() + mediaPage.getUnit() + "\"");
                }
                this.out.print("/>\n");
            }
            for (MediaRegion region : mediaPage.getRegions()) {
                region.generate(this);
            }
            this.out.print("\t\t\t</layout>\n");
            this.out.print("\t\t</head>\n");
        }
        this.out.print("\t\t<body>\n");
    }

    @Override
    public void mediaPageEnd(MediaPage transfer) {
        if (this.mySession.getPlatformSettings().getVxml().equals("2.0") || this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.mySession.throwRTException("<media> tag requires project to be VXML 2.1 + IVVR compatible or higher");
            return;
        }
        this.out.print("\t\t</body>\n");
        this.out.print("\t</smil>\n");
        this.out.print("\t]]>\n");
        this.out.print("</media>\n");
    }

    @Override
    public void mediaBegin(MediaInfo mediaInfo) {
        String mediaOutputType = "media";
        String srcURL = mediaInfo.getMediaURL();
        srcURL = mediaInfo.hookGetMediaURL(srcURL);
        int mediaType = mediaInfo.getMediaType();
        mediaType = mediaInfo.hookGetMediaType(mediaType, srcURL);
        switch (mediaType) {
            case 1: {
                mediaOutputType = "audio";
                break;
            }
            case 2: {
                mediaOutputType = "video";
                break;
            }
            case 3: {
                mediaOutputType = "img";
                break;
            }
            case 4: {
                mediaOutputType = "text";
            }
        }
        this.out.print("\t\t\t\t<" + mediaOutputType + " ");
        this.out.print("src=\"" + srcURL + "\"");
        if (mediaInfo.getRegion().length() > 0) {
            this.out.print(" region=\"" + mediaInfo.getRegion() + "\"");
        }
        if (mediaInfo.getBegin() > 0.0) {
            this.out.print(" begin=\"" + mediaInfo.getBegin() + "\"");
        }
        if (mediaInfo.getEnd() > 0.0) {
            this.out.print(" end=\"" + mediaInfo.getEnd() + "\"");
        }
        if (mediaInfo.getDuration() > 0.0) {
            this.out.print(" dur=\"" + mediaInfo.getDuration() + "\"");
        }
        if (mediaInfo.getRepeatDuration() > 0.0) {
            this.out.print(" repeatDur=\"" + mediaInfo.getRepeatDuration() + "\"");
        }
        if (mediaInfo.getRepeatCount() > 0.0) {
            this.out.print(" repeatCount=\"" + mediaInfo.getRepeatCount() + "\"");
        }
        if (mediaInfo.getClipBegin() > 0.0) {
            this.out.print(" clipBegin=\"" + mediaInfo.getClipBegin() + "\"");
        }
        if (mediaInfo.getClipEnd() > 0.0) {
            this.out.print(" clipEnd=\"" + mediaInfo.getClipEnd() + "\"");
        }
        if (mediaInfo.getFill().length() > 0) {
            this.out.print(" fill=\"" + mediaInfo.getFill() + "\"");
        }
        this.out.print("/>\n");
    }

    @Override
    public void mediaTextBlockBegin(MediaTextBlock mediaTextBlock) {
        this.out.print("\t\t\t\t<smilText");
        if (mediaTextBlock.getRegion().length() > 0) {
            this.out.print(" region=\"" + mediaTextBlock.getRegion() + "\"");
        }
        if (mediaTextBlock.getBegin() > 0.0) {
            this.out.print(" begin=\"" + mediaTextBlock.getBegin() + "\"");
        }
        if (mediaTextBlock.getEnd() > 0.0) {
            this.out.print(" end=\"" + mediaTextBlock.getEnd() + "\"");
        }
        if (mediaTextBlock.getDuration() > 0.0) {
            this.out.print(" dur=\"" + (int)mediaTextBlock.getDuration() + "s\"");
        }
        if (mediaTextBlock.getRepeatDuration() > 0.0) {
            this.out.print(" repeatDur=\"" + mediaTextBlock.getRepeatDuration() + "\"");
        }
        if (mediaTextBlock.getRepeatCount() > 0.0) {
            this.out.print(" repeatCount=\"" + mediaTextBlock.getRepeatCount() + "\"");
        }
        if (mediaTextBlock.getClipBegin() > 0.0) {
            this.out.print(" clipBegin=\"" + mediaTextBlock.getClipBegin() + "\"");
        }
        if (mediaTextBlock.getClipEnd() > 0.0) {
            this.out.print(" clipEnd=\"" + mediaTextBlock.getClipEnd() + "\"");
        }
        if (mediaTextBlock.getFontFamily().length() > 0) {
            this.out.print(" textFontFamily=\"" + mediaTextBlock.getFontFamily() + "\"");
        }
        if (mediaTextBlock.getFontSize().length() > 0) {
            this.out.print(" textFontSize=\"" + mediaTextBlock.getFontSize() + "\"");
        }
        if (mediaTextBlock.getFontColor().length() > 0) {
            this.out.print(" textColor=\"#" + mediaTextBlock.getFontColor() + "\"");
        }
        if (mediaTextBlock.getFontBkgnColor().length() > 0) {
            this.out.print(" textBackgroundColor=\"#" + mediaTextBlock.getFontBkgnColor() + "\"");
        }
        if (mediaTextBlock.getTextMode().length() > 0) {
            this.out.print(" textMode=\"" + mediaTextBlock.getTextMode() + "\"");
        }
        if (mediaTextBlock.getTextWritingMode().length() > 0) {
            this.out.print(" textWritingMode=\"" + mediaTextBlock.getTextWritingMode() + "\"");
        }
        this.out.print(">\n\t\t\t\t\t");
    }

    @Override
    public void mediaTextBlockEnd(MediaTextBlock mediaTextBlock) {
        this.out.print("\n");
        this.out.print("\t\t\t\t</smilText>\n");
    }

    @Override
    public void mediaTextBegin(MediaText mediaText) {
        String text = mediaText.getMediaText();
        this.out.print(this.xmlEscapeString(text, false, false));
    }

    @Override
    public void coordinationParBegin(CoordinationPar coordinationPar) {
        if (!this.mySession.getPlatformSettings().getVxml().equals("2.0") && !this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.out.print("<par");
            if (coordinationPar.getEndSync().length() > 0) {
                this.out.print(" endsync=\"" + coordinationPar.getEndSync() + "\"");
            }
            this.out.print(">\n");
        } else {
            this.mySession.throwRTException("<par> tag requires project to be VXML 2.1 + IVVR compatible or higher");
        }
    }

    @Override
    public void coordinationParEnd(CoordinationPar coordinationPar) {
        if (!this.mySession.getPlatformSettings().getVxml().equals("2.0") && !this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.out.print("</par>\n");
        } else {
            this.mySession.throwRTException("<par> tag requires project to be VXML 2.1 + IVVR compatible or higher");
        }
    }

    @Override
    public void coordinationSeqBegin(CoordinationSeq coordinationSeq) {
        if (!this.mySession.getPlatformSettings().getVxml().equals("2.0") && !this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.out.print("\t\t\t<seq>\n");
        } else {
            this.mySession.throwRTException("<seq> tag requires project to be VXML 2.1 + IVVR compatible or higher");
        }
    }

    @Override
    public void coordinationSeqEnd(CoordinationSeq coordinationSeq) {
        if (!this.mySession.getPlatformSettings().getVxml().equals("2.0") && !this.mySession.getPlatformSettings().getVxml().equals("2.1")) {
            this.out.print("\t\t\t</seq>\n");
        } else {
            this.mySession.throwRTException("<seq> tag requires project to be VXML 2.1 + IVVR compatible or higher");
        }
    }

    @Override
    public void emailBegin(EmailInfo emailInfo) {
    }

    @Override
    public void smsBegin(SMSInfo smsInfo) {
    }
}

