/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.ade.common.utils.io.IO;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimeGrammar;
import com.avaya.sce.runtime.internal.GrammarFinder;
import com.avaya.sce.runtime.tracking.ReportInfo;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.PlatformSettings;
import com.avaya.sce.runtimecommon.SCERT;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Grammar
implements IRuntimeGrammar {
    private static final String EXTRNGRAMVAR = "DDVAR_";
    private String fileName = null;
    private String mode = null;
    private String builtinMode;
    private String type = null;
    private String options = null;
    private String weight = null;
    private boolean builtin = false;
    private String rootLanguage;
    private String compatibility = null;
    private String mediaType = "application/srgs+xml";
    protected SCESession mySession;
    private boolean external = false;
    private boolean enabled = true;
    private ArrayList<String> colIds = new ArrayList();
    private boolean doNotEncodeQueryString = false;
    private String languageLabel;

    @Override
    public final void generate(IOutputGenerator generator) {
        this.mySession = generator.getMySession();
        if (!this.enabled) {
            return;
        }
        generator.grammarBegin(this);
        generator.grammarEnd(this);
    }

    private String getToken(String value) {
        int start = -1;
        int end = -1;
        String token = null;
        start = value.indexOf(37);
        if (start != -1 && (end = value.indexOf(37, start + 1)) != -1) {
            token = value.substring(start, end + 1);
        }
        return token;
    }

    private String resolveParameters(String value) {
        String token = null;
        while ((token = this.getToken(value)) != null) {
            String paramValue = null;
            String paramName = token.substring(1, token.length() - 1);
            if (paramName.equals("runtime-ASR")) {
                paramValue = this.mySession.getPlatformSettings().getASR();
            } else if (paramName.equals("runtime-Platform")) {
                paramValue = this.mySession.getPlatformSettings().getPlatform();
            } else if (paramName.startsWith(EXTRNGRAMVAR)) {
                String varName = paramName.substring(EXTRNGRAMVAR.length());
                IVariableField field = this.mySession.getVariableField(new VariableName(varName));
                paramValue = field.getStringValue();
            }
            value = value.replaceAll(token, paramValue);
        }
        return value;
    }

    public String getURL() {
        if (this.isExternal()) {
            ServletContext context = this.mySession.getServlet().getServletContext();
            String className = this.getClass().getName();
            String uri = context.getInitParameter(className);
            uri = this.resolveParameters(uri);
            try {
                URL url = new URL(new URL(this.mySession.getRequestCopyURL()), uri);
                return url.toString();
            }
            catch (Exception e) {
                ReportInfo.alarm("Error", "Error constructing url for external grammar :" + uri, e, this.mySession);
                return uri;
            }
        }
        String name = IO.getSimpleName((String)this.getFileName());
        String rtAsr = this.mySession.getPlatformSettings().getASR();
        String rtGenType = (String)SCERT.ASR_TYPES_MAP.get(rtAsr);
        if (this.mode.equals("dtmf")) {
            PlatformSettings.DTMFMode dtmfMode = this.mySession.getPlatformSettings().getDTMFNative();
            if (dtmfMode == PlatformSettings.DTMFMode.LOCAL_SRGS_LITERALS) {
                rtGenType = "SRGS-Literals";
            } else if (dtmfMode == PlatformSettings.DTMFMode.LOCAL_SRGS_SISR) {
                rtGenType = "SRGS-SISR";
            }
        }
        String rtAsrExt = (String)SCERT.ASR_FILE_TYPES_MAP.get(rtGenType);
        name = name + "-" + rtAsrExt + "." + "grxml";
        if (this.languageLabel == null) {
            this.languageLabel = this.mySession.getCurrentLanguage();
        }
        name = GrammarFinder.getGrammarFinder(this.languageLabel).resolveResourceName(name);
        URL url = this.mySession.getFileURL(name);
        return url.toString();
    }

    public final void setCompatibility(String value) {
        this.compatibility = value;
    }

    @Override
    public final String getCompatibility() {
        return this.compatibility;
    }

    public final String getWeight() {
        return this.weight;
    }

    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public final void setWeight(String weight) {
        this.weight = weight;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    public String getOptions() {
        return this.options;
    }

    public String getType() {
        return this.type;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public void setBuiltin(boolean builtin) {
        this.builtin = builtin;
    }

    public String getRootLanguage() {
        return this.rootLanguage;
    }

    public void setRootLanguage(String rootLanguage) {
        this.rootLanguage = rootLanguage;
    }

    public String getBuiltinMode() {
        return this.builtinMode;
    }

    public void setBuiltinMode(String builtinMode) {
        this.builtinMode = builtinMode;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getMediaType() {
        String mt = this.resolveParameters(this.mediaType);
        return mt;
    }

    public void setMediaType(String mediaType) {
        this.mediaType = mediaType;
    }

    @Override
    public void setSession(SCESession session) {
        this.mySession = session;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean external) {
        this.external = external;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void updateGrammar(SCESession mySession) {
    }

    @Override
    public List<String> getColumnIds() {
        return this.colIds;
    }

    public void addColName(String value) {
        this.colIds.add(value);
    }

    public ArrayList<String> getColIds() {
        return this.colIds;
    }

    public void setColIds(ArrayList<String> colIds) {
        this.colIds = colIds;
    }

    public boolean doNotEncodeQueryString() {
        return this.doNotEncodeQueryString;
    }

    public void setDoNotEncodeQueryString(boolean doNotEncodeQueryString) {
        this.doNotEncodeQueryString = doNotEncodeQueryString;
    }

    public void setLanguageLabel(String languageLabel) {
        this.languageLabel = languageLabel;
    }
}

