/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.internal;

import com.avaya.sce.runtime.Email;
import com.avaya.sce.runtime.internal.ItemFinder;
import com.avaya.sce.runtime.internal.ResourceFinder;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;

public class EmailFinder
extends ResourceFinder {
    public static final String TYPE = "EMAIL";

    public static EmailFinder getEmailFinder(String language) {
        return (EmailFinder)ItemFinder.getFinder(TYPE, language);
    }

    public static Email load(String name, String language, SCESession mySession) {
        Email email = null;
        if (name != null) {
            try {
                email = (Email)EmailFinder.getEmailFinder(language).getInstance(name);
                email.setSession(mySession);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error instantiating email", e);
            }
        }
        return email;
    }

    public EmailFinder(String appLanguage) {
        super(appLanguage);
    }

    protected String resolveName(String simpleName) {
        StringBuilder className = new StringBuilder(100);
        className.append(this.appLanguage);
        className.append(".");
        className.append("email");
        className.append(".");
        className.append(simpleName);
        return className.toString();
    }

    public String resolveResourceName(String simpleName) {
        StringBuilder itemName = new StringBuilder(100);
        itemName.append("/");
        itemName.append("data");
        itemName.append("/");
        itemName.append(this.appLanguage);
        itemName.append("/");
        itemName.append("email");
        itemName.append("/");
        itemName.append(simpleName);
        return itemName.toString();
    }
}

