/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.varoperations;

import com.avaya.sce.runtime.varoperations.AssignmentOperation;
import com.avaya.sce.runtimecommon.ICollection;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.util.Stack;

public class CaptureLastNodeInfo
extends AssignmentOperation {
    private static final String APP_ROOT = "/AppRoot";
    private final VariableName varName;
    private final int numberToCapture;
    private final boolean makeCollection;

    public CaptureLastNodeInfo(String varName) {
        this(varName, 1, false);
    }

    public CaptureLastNodeInfo(String varName, int numberToCapture, boolean makeCollection) {
        this.varName = new VariableName(varName);
        if (makeCollection && this.varName.getFieldName() != null) {
            throw new IllegalArgumentException("CaptureLastNodeInfo only supports creating a collection with simple variables.");
        }
        this.numberToCapture = numberToCapture;
        this.makeCollection = makeCollection;
    }

    public void evaluate(IRuntimeSession mySession) {
        if (!(mySession instanceof SCESession)) {
            throw new IllegalArgumentException("This assignment operation only works with SCESession objects.");
        }
        SCESession sceSession = (SCESession)mySession;
        boolean rootInline = sceSession.getRuntimePropertyEnabled("xmlrootinline");
        Stack callStack = new Stack();
        callStack.addAll(sceSession.getCallStack());
        try {
            IVariableField field;
            IVariable variable = sceSession.getVariable(this.varName.getVarName());
            if (variable == null) {
                sceSession.throwRTException("Variable \"" + this.varName + "\" does not exist in the application.");
            }
            if (variable.isSimpleVariable()) {
                field = variable.getSimpleVariable();
            } else {
                if (this.makeCollection) {
                    sceSession.throwRTException("CaptureLastNodeInfo does not support creating collections for complex variables.");
                }
                if ((field = variable.getComplexVariable().getField(this.varName.getFieldName())) == null) {
                    sceSession.throwRTException("Variable \"" + this.varName + "\" does not contain the field \"" + this.varName.getFieldName() + "\"");
                }
            }
            callStack.pop();
            if (this.numberToCapture == 1) {
                if (!rootInline) {
                    callStack.pop();
                }
                if (sceSession.isDDTraceEnabled()) {
                    sceSession.getTraceOutput().writeln(1, "Capturing last node information to variable [" + this.varName.toString() + "]");
                }
                String lastForm = (String)callStack.pop();
                field.setValue(lastForm);
            } else {
                int size = this.numberToCapture;
                if (size <= 0) {
                    size = callStack.size();
                }
                ICollection collection = null;
                if (this.makeCollection) {
                    collection = variable.addCollection();
                    if (sceSession.isDDTraceEnabled()) {
                        sceSession.getTraceOutput().writeln(1, "Capturing last node information to variable [" + this.varName.toString() + "].  Creating a collection to store the results.");
                    }
                } else if (sceSession.isDDTraceEnabled()) {
                    sceSession.getTraceOutput().writeln(1, "Capturing last node information to variable [" + this.varName.toString() + "].  Nodes will be stored to a delimited string.");
                }
                int count = 0;
                while (!callStack.isEmpty() && count < size) {
                    String lastForm = (String)callStack.pop();
                    if (lastForm.endsWith(APP_ROOT)) continue;
                    if (this.makeCollection) {
                        field.setValue(lastForm);
                        collection.append();
                    } else if (count == 0) {
                        field.setValue(lastForm);
                    } else {
                        String tmp = field.getStringValue();
                        field.setValue(tmp + "|" + lastForm);
                    }
                    ++count;
                }
                if (this.makeCollection) {
                    collection.reset();
                    collection.next();
                }
            }
        }
        catch (Exception e) {
            sceSession.throwRTException("Error determining last form", e);
        }
    }
}

