/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.commons.beanutils.DefaultIntrospectionContext;

public class DefaultIntrospectionContextTestCase
extends TestCase {
    private static final String PROP = "foo";
    private DefaultIntrospectionContext context;

    protected void setUp() throws Exception {
        super.setUp();
        this.context = new DefaultIntrospectionContext(((Object)((Object)this)).getClass());
    }

    private static PropertyDescriptor createDescriptor(String propName) {
        try {
            return new PropertyDescriptor(propName, DefaultIntrospectionContextTestCase.class, null, null);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Unexpected exception: " + e);
        }
    }

    public void testInit() {
        DefaultIntrospectionContextTestCase.assertEquals((String)"Wrong current class", ((Object)((Object)this)).getClass(), (Object)this.context.getTargetClass());
        DefaultIntrospectionContextTestCase.assertTrue((String)"Got property names", (boolean)this.context.propertyNames().isEmpty());
    }

    public void testAddPropertyDescriptor() {
        PropertyDescriptor desc = DefaultIntrospectionContextTestCase.createDescriptor(PROP);
        this.context.addPropertyDescriptor(desc);
        DefaultIntrospectionContextTestCase.assertTrue((String)"Property not found", (boolean)this.context.hasProperty(PROP));
        DefaultIntrospectionContextTestCase.assertSame((String)"Wrong descriptor", (Object)desc, (Object)this.context.getPropertyDescriptor(PROP));
    }

    public void testAddPropertyDescriptorNull() {
        try {
            this.context.addPropertyDescriptor(null);
            DefaultIntrospectionContextTestCase.fail((String)"Could add null descriptor!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddPropertyDescriptors() {
        int count = 4;
        PropertyDescriptor[] descs = new PropertyDescriptor[4];
        HashSet<PropertyDescriptor> descSet = new HashSet<PropertyDescriptor>();
        for (int i = 0; i < 4; ++i) {
            descs[i] = DefaultIntrospectionContextTestCase.createDescriptor(PROP + i);
            descSet.add(descs[i]);
        }
        this.context.addPropertyDescriptors(descs);
        PropertyDescriptor d = DefaultIntrospectionContextTestCase.createDescriptor(PROP);
        this.context.addPropertyDescriptor(d);
        descSet.add(d);
        Set names = this.context.propertyNames();
        DefaultIntrospectionContextTestCase.assertEquals((String)"Wrong number of property names", (int)5, (int)names.size());
        DefaultIntrospectionContextTestCase.assertTrue((String)"Property not found: foo", (boolean)names.contains(PROP));
        for (int i = 0; i < 4; ++i) {
            DefaultIntrospectionContextTestCase.assertTrue((String)("Property not found: " + PROP + i), (boolean)names.contains(PROP + i));
        }
        PropertyDescriptor[] addedDescs = this.context.getPropertyDescriptors();
        DefaultIntrospectionContextTestCase.assertEquals((String)"Wrong number of added descriptors", (int)5, (int)addedDescs.length);
        for (PropertyDescriptor pd : addedDescs) {
            DefaultIntrospectionContextTestCase.assertTrue((String)("Unexpected descriptor: " + pd), (boolean)descSet.remove(pd));
        }
    }

    public void testAddPropertyDescriptorsNull() {
        try {
            this.context.addPropertyDescriptors(null);
            DefaultIntrospectionContextTestCase.fail((String)"Could add a null array with descriptors!");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testHasPropertyFalse() {
        DefaultIntrospectionContextTestCase.assertFalse((String)"Wrong result (1)", (boolean)this.context.hasProperty(PROP));
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTestCase.createDescriptor(PROP));
        DefaultIntrospectionContextTestCase.assertFalse((String)"Wrong result (2)", (boolean)this.context.hasProperty("other"));
    }

    public void testGetPropertyDescriptorUnknown() {
        DefaultIntrospectionContextTestCase.assertNull((String)"Got a property (1)", (Object)this.context.getPropertyDescriptor(PROP));
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTestCase.createDescriptor(PROP));
        DefaultIntrospectionContextTestCase.assertNull((String)"Got a property (2)", (Object)this.context.getPropertyDescriptor("other"));
    }

    public void testPropertyNamesModify() {
        Set names = this.context.propertyNames();
        try {
            names.add(PROP);
            DefaultIntrospectionContextTestCase.fail((String)"Could modify property names set!");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testRemovePropertyDescriptor() {
        this.context.addPropertyDescriptor(DefaultIntrospectionContextTestCase.createDescriptor(PROP));
        this.context.removePropertyDescriptor(PROP);
        DefaultIntrospectionContextTestCase.assertTrue((String)"Got property names", (boolean)this.context.propertyNames().isEmpty());
        DefaultIntrospectionContextTestCase.assertEquals((String)"Got descriptors", (int)0, (int)this.context.getPropertyDescriptors().length);
    }
}

