/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.util.Comparator;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira339TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira339TestCase.class);

    public Jira339TestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Jira339TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira339TestCase.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_339_BeanUtilsBean_setProperty() {
        TestBean bean = new TestBean();
        try {
            BeanUtils.setProperty((Object)bean, (String)"comparator", null);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed: " + t.getMessage()), t);
            Jira339TestCase.fail((String)("Threw exception: " + t));
        }
        Jira339TestCase.assertNull((String)"TestBean comparator should be null", bean.getComparator());
    }

    public void testIssue_BEANUTILS_331_BeanUtilsBean_populate() {
        TestBean bean = new TestBean();
        try {
            HashMap<String, Object> properties = new HashMap<String, Object>();
            properties.put("comparator", null);
            BeanUtils.populate((Object)bean, properties);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed: " + t.getMessage()), t);
            Jira339TestCase.fail((String)("Threw exception: " + t));
        }
        Jira339TestCase.assertNull((String)"TestBean comparator should be null", bean.getComparator());
    }

    public static class TestBean {
        private Comparator<?> comparator;

        public Comparator<?> getComparator() {
            return this.comparator;
        }

        public void setComparator(Comparator<?> comparator) {
            this.comparator = comparator;
        }
    }
}

