/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.converters.ArrayConverter;
import org.apache.commons.beanutils.converters.StringConverter;

public class Jira359TestCase
extends TestCase {
    public Jira359TestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Jira359TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira359TestCase.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBeanUtilsSetProperty_CustomConvertStringToArray_WithColonValue() throws Exception {
        ArrayConverter converter = new ArrayConverter(String[].class, (Converter)new StringConverter());
        converter.setAllowedChars(new char[]{'.', '-', ':'});
        BeanUtilsBean utils = new BeanUtilsBean();
        utils.getConvertUtils().register((Converter)converter, String[].class);
        SimplePojoData simplePojo = new SimplePojoData();
        utils.setProperty((Object)simplePojo, "jcrMixinTypes", (Object)"mix:rereferencible,mix:simple");
        this.showArray("Custom WithColonValue", simplePojo.getJcrMixinTypes());
        Jira359TestCase.assertEquals((String)"array size", (int)2, (int)simplePojo.getJcrMixinTypes().length);
        Jira359TestCase.assertEquals((String)"mix:rereferencible", (String)simplePojo.getJcrMixinTypes()[0]);
        Jira359TestCase.assertEquals((String)"mix:simple", (String)simplePojo.getJcrMixinTypes()[1]);
    }

    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithColonValue() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mix:rereferencible,mix:simple");
        this.showArray("Default WithColonValue", simplePojo.getJcrMixinTypes());
        Jira359TestCase.assertEquals((String)"array size", (int)4, (int)simplePojo.getJcrMixinTypes().length);
        Jira359TestCase.assertEquals((String)"mix", (String)simplePojo.getJcrMixinTypes()[0]);
        Jira359TestCase.assertEquals((String)"rereferencible", (String)simplePojo.getJcrMixinTypes()[1]);
        Jira359TestCase.assertEquals((String)"mix", (String)simplePojo.getJcrMixinTypes()[2]);
        Jira359TestCase.assertEquals((String)"simple", (String)simplePojo.getJcrMixinTypes()[3]);
    }

    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithoutColonValue() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mixrereferencible,mixsimple");
        this.showArray("Default WithoutColonValue", simplePojo.getJcrMixinTypes());
        Jira359TestCase.assertEquals((String)"array size", (int)2, (int)simplePojo.getJcrMixinTypes().length);
        Jira359TestCase.assertEquals((String)"mixrereferencible", (String)simplePojo.getJcrMixinTypes()[0]);
        Jira359TestCase.assertEquals((String)"mixsimple", (String)simplePojo.getJcrMixinTypes()[1]);
    }

    public void testBeanUtilsSetProperty_DefaultConvertStringToArray_WithoutColonValueAndNocoma() throws Exception {
        SimplePojoData simplePojo = new SimplePojoData();
        BeanUtils.setProperty((Object)simplePojo, (String)"jcrMixinTypes", (Object)"mixrereferencible");
        this.showArray("Default WithoutColonAndNocoma", simplePojo.getJcrMixinTypes());
        Jira359TestCase.assertEquals((String)"array size", (int)1, (int)simplePojo.getJcrMixinTypes().length);
        Jira359TestCase.assertEquals((String)"mixrereferencible", (String)simplePojo.getJcrMixinTypes()[0]);
    }

    private void showArray(String text, String[] array) {
        if (array == null) {
            System.out.println(text + " array is null");
        } else {
            System.out.println(text + " array length=" + array.length);
            for (int i = 0; i < array.length; ++i) {
                System.out.println(text + " array[" + i + "]=" + array[i]);
            }
        }
    }

    public static class SimplePojoData {
        private String[] jcrMixinTypes = new String[1];

        public String[] getJcrMixinTypes() {
            return this.jcrMixinTypes;
        }

        public void setJcrMixinTypes(String[] mixinTypes) {
            this.jcrMixinTypes = mixinTypes;
        }
    }
}

