/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.bugs;

import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.bugs.other.Jira61BeanFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Jira61TestCase
extends TestCase {
    private final Log log = LogFactory.getLog(Jira61TestCase.class);
    private Jira61BeanFactory.TestBean testBean;
    private WrapDynaBean wrapDynaBean;

    public Jira61TestCase(String name) {
        super(name);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)Jira61TestCase.suite());
    }

    public static Test suite() {
        return new TestSuite(Jira61TestCase.class);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.testBean = Jira61BeanFactory.createBean();
        PropertyUtils.getPropertyDescriptor((Object)this.testBean, (String)"mappedReadOnly");
        PropertyUtils.getPropertyDescriptor((Object)this.testBean, (String)"mappedWriteOnly");
        this.wrapDynaBean = new WrapDynaBean((Object)this.testBean);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"simpleReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isReadable(bean, \"simpleReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"simpleWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isReadable(bean, \"simpleWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"simpleReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isWriteable(bean, \"simpleReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"simpleWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isWriteable(bean, \"simpleWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable_Indexed() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"indexedReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isReadable(bean, \"indexedReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"indexedWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isReadable(bean, \"indexedWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isReadable_Mapped() {
        boolean result = false;
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"mappedReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isReadable(bean, \"mappedReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isReadable((Object)this.wrapDynaBean, (String)"mappedWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isReadable(bean, \"mappedWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable_Indexed() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"indexedReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isWriteable(bean, \"indexedReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"indexedWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isWriteable(bean, \"indexedWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_isWriteable_Mapped() {
        boolean result = false;
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"mappedReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)("PropertyUtils.isWriteable(bean, \"mappedReadOnly\") returned " + result), (boolean)result);
        try {
            result = PropertyUtils.isWriteable((Object)this.wrapDynaBean, (String)"mappedWriteOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("PropertyUtils.isWriteable(bean, \"mappedWriteOnly\") returned " + result), (boolean)result);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty() {
        boolean threwIllegalArgumentException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"simpleReadOnly");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"simpleReadOnly", (Object)this.testBean.getSimpleReadOnly(), (Object)result);
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"simpleWriteOnly");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("Expected IllegalArgumentException but returned '" + result + "'"), (boolean)threwIllegalArgumentException);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty() {
        boolean threwIllegalArgumentException = false;
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"simpleReadOnly", (Object)"READONLY-SIMPLE-BAR");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)"Expected IllegalArgumentException", (boolean)threwIllegalArgumentException);
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"simpleWriteOnly", (Object)"SIMPLE-BAR");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("simpleWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"simpleWriteOnly", (String)this.testBean.getSimpleReadOnly(), (String)"SIMPLE-BAR");
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty_Indexed() {
        boolean threwIllegalArgumentException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"indexedReadOnly[0]");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"indexedReadOnly", (Object)this.testBean.getIndexedReadOnly(0), (Object)result);
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"indexedWriteOnly[0]");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("Expected IllegalArgumentException but returned '" + result + "'"), (boolean)threwIllegalArgumentException);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty_Indexed() {
        boolean threwIllegalArgumentException = false;
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"indexedReadOnly[0]", (Object)"READONLY-INDEXED-BAR");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)"Expected IllegalArgumentException", (boolean)threwIllegalArgumentException);
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"indexedWriteOnly[0]", (Object)"INDEXED-BAR");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("indexedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"indexedWriteOnly", (String)this.testBean.getIndexedReadOnly(0), (String)"INDEXED-BAR");
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_getProperty_Mapped() {
        boolean threwIllegalArgumentException = false;
        Object result = null;
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"mappedReadOnly(foo-key)");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"mappedReadOnly", (Object)this.testBean.getMappedReadOnly("foo-key"), (Object)result);
        try {
            result = PropertyUtils.getProperty((Object)this.wrapDynaBean, (String)"mappedWriteOnly(foo-key)");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("Expected IllegalArgumentException but returned '" + result + "'"), (boolean)threwIllegalArgumentException);
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_setProperty_Mapped() {
        boolean threwIllegalArgumentException = false;
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"mappedReadOnly(foo-key)", (Object)"READONLY-MAPPED-BAR");
        }
        catch (IllegalArgumentException ex) {
            threwIllegalArgumentException = true;
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedReadOnly Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)"Expected IllegalArgumentException", (boolean)threwIllegalArgumentException);
        try {
            PropertyUtils.setProperty((Object)this.wrapDynaBean, (String)"mappedWriteOnly(foo-key)", (Object)"MAPPED-BAR");
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("mappedWriteOnly Threw exception: " + t));
        }
        Jira61TestCase.assertEquals((String)"mappedWriteOnly", (String)this.testBean.getMappedReadOnly("foo-key"), (String)"MAPPED-BAR");
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_copyProperties_to_WrapDynaBean() {
        String value = "copied simpleReadOnly";
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("simpleReadOnly", "copied simpleReadOnly");
        try {
            PropertyUtils.copyProperties((Object)this.wrapDynaBean, source);
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("copyProperties Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)"Target value='copied simpleReadOnly'", (boolean)"copied simpleReadOnly".equals(this.testBean.getSimpleReadOnly()));
    }

    public void testIssue_BEANUTILS_61_PropertyUtils_copyProperties_from_WrapDynaBean() {
        String value = "ORIG TARGET VALUE";
        Jira61BeanFactory.TestBean targetBean = Jira61BeanFactory.createBean();
        targetBean.setSimpleWriteOnly("ORIG TARGET VALUE");
        try {
            PropertyUtils.copyProperties((Object)targetBean, (Object)this.wrapDynaBean);
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("copyProperties Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("Target value='" + targetBean.getSimpleReadOnly() + "'"), (boolean)"ORIG TARGET VALUE".equals(targetBean.getSimpleReadOnly()));
    }

    public void testIssue_BEANUTILS_61_BeanUtils_copyProperties_to_WrapDynaBean() {
        String value = "copied simpleReadOnly";
        HashMap<String, String> source = new HashMap<String, String>();
        source.put("simpleReadOnly", "copied simpleReadOnly");
        try {
            BeanUtils.copyProperties((Object)this.wrapDynaBean, source);
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("copyProperties Threw exception: " + t));
        }
        Jira61TestCase.assertFalse((String)"Target value='copied simpleReadOnly'", (boolean)"copied simpleReadOnly".equals(this.testBean.getSimpleReadOnly()));
    }

    public void testIssue_BEANUTILS_61_BeanUtils_copyProperties_from_WrapDynaBean() {
        String value = "ORIG TARGET VALUE";
        Jira61BeanFactory.TestBean targetBean = Jira61BeanFactory.createBean();
        targetBean.setSimpleWriteOnly("ORIG TARGET VALUE");
        try {
            BeanUtils.copyProperties((Object)targetBean, (Object)this.wrapDynaBean);
        }
        catch (Throwable t) {
            this.log.error((Object)("ERROR " + t), t);
            Jira61TestCase.fail((String)("copyProperties Threw exception: " + t));
        }
        Jira61TestCase.assertTrue((String)("Target value='" + targetBean.getSimpleReadOnly() + "'"), (boolean)"ORIG TARGET VALUE".equals(targetBean.getSimpleReadOnly()));
    }
}

