/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils.locale;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.apache.commons.beanutils.TestBean;
import org.apache.commons.beanutils.locale.LocaleBeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocaleBeanUtilsTestCase
extends TestCase {
    private static Log log = LogFactory.getLog(LocaleBeanUtilsTestCase.class);

    public LocaleBeanUtilsTestCase(String name) {
        super(name);
    }

    public void setUp() {
    }

    public static Test suite() {
        return new TestSuite(LocaleBeanUtilsTestCase.class);
    }

    public void tearDown() {
    }

    public void testSetNestedPropertySimple() {
        TestBean bean = new TestBean();
        bean.getNested().setIntProperty(5);
        LocaleBeanUtilsTestCase.assertEquals((String)"Initial value 5", (int)5, (int)bean.getNested().getIntProperty());
        try {
            LocaleBeanUtils.setProperty((Object)bean, (String)"nested.intProperty", (Object)"123", null);
        }
        catch (Throwable t) {
            log.error((Object)t);
            LocaleBeanUtilsTestCase.fail((String)("Threw " + t));
        }
        LocaleBeanUtilsTestCase.assertEquals((String)"Check Set Value", (int)123, (int)bean.getNested().getIntProperty());
    }

    public void testSetNestedPropertyIndexed() {
        TestBean bean = new TestBean();
        bean.getNested().setIntIndexed(1, 51);
        LocaleBeanUtilsTestCase.assertEquals((String)"Initial value[1] 51", (int)51, (int)bean.getNested().getIntIndexed(1));
        try {
            LocaleBeanUtils.setProperty((Object)bean, (String)"nested.intIndexed[1]", (Object)"123", null);
        }
        catch (Throwable t) {
            log.error((Object)t);
            LocaleBeanUtilsTestCase.fail((String)("Threw " + t));
        }
        LocaleBeanUtilsTestCase.assertEquals((String)"Check Set Value", (int)123, (int)bean.getNested().getIntIndexed(1));
    }
}

