/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.tuple;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.lang3.tuple.MutablePair;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class MutablePairTest {
    @Test
    public void testBasic() {
        MutablePair pair = new MutablePair((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        MutablePair pair2 = new MutablePair(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testDefault() {
        MutablePair pair = new MutablePair();
        Assertions.assertNull((Object)pair.getLeft());
        Assertions.assertNull((Object)pair.getRight());
    }

    @Test
    public void testMutate() {
        MutablePair pair = new MutablePair((Object)0, (Object)"foo");
        pair.setLeft((Object)42);
        pair.setRight((Object)"bar");
        Assertions.assertEquals((int)42, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"bar", (Object)pair.getRight());
    }

    @Test
    public void testPairOf() {
        MutablePair pair = MutablePair.of((Object)0, (Object)"foo");
        Assertions.assertEquals((int)0, (int)((Integer)pair.getLeft()));
        Assertions.assertEquals((Object)"foo", (Object)pair.getRight());
        MutablePair pair2 = MutablePair.of(null, (Object)"bar");
        Assertions.assertNull((Object)pair2.getLeft());
        Assertions.assertEquals((Object)"bar", (Object)pair2.getRight());
    }

    @Test
    public void testEquals() {
        Assertions.assertEquals((Object)MutablePair.of(null, (Object)"foo"), (Object)MutablePair.of(null, (Object)"foo"));
        Assertions.assertNotEquals((Object)MutablePair.of((Object)"foo", (Object)0), (Object)MutablePair.of((Object)"foo", null));
        Assertions.assertNotEquals((Object)MutablePair.of((Object)"foo", (Object)"bar"), (Object)MutablePair.of((Object)"xyz", (Object)"bar"));
        MutablePair p = MutablePair.of((Object)"foo", (Object)"bar");
        Assertions.assertEquals((Object)p, (Object)p);
        Assertions.assertNotEquals((Object)p, (Object)new Object());
    }

    @Test
    public void testHashCode() {
        Assertions.assertEquals((int)MutablePair.of(null, (Object)"foo").hashCode(), (int)MutablePair.of(null, (Object)"foo").hashCode());
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)"(null,null)", (Object)MutablePair.of(null, null).toString());
        Assertions.assertEquals((Object)"(null,two)", (Object)MutablePair.of(null, (Object)"two").toString());
        Assertions.assertEquals((Object)"(one,null)", (Object)MutablePair.of((Object)"one", null).toString());
        Assertions.assertEquals((Object)"(one,two)", (Object)MutablePair.of((Object)"one", (Object)"two").toString());
    }

    @Test
    public void testSerialization() throws Exception {
        MutablePair origPair = MutablePair.of((Object)0, (Object)"foo");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(origPair);
        MutablePair deserializedPair = (MutablePair)new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray())).readObject();
        Assertions.assertEquals((Object)origPair, (Object)deserializedPair);
        Assertions.assertEquals((int)origPair.hashCode(), (int)deserializedPair.hashCode());
    }
}

