/*
 * Decompiled with CFR 0.152.
 */
package net.sf.log4jdbc.sql.jdbcapi;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.sf.log4jdbc.log.SpyLogDelegator;
import net.sf.log4jdbc.log.SpyLogFactory;
import net.sf.log4jdbc.sql.Spy;
import net.sf.log4jdbc.sql.jdbcapi.ConnectionSpy;
import net.sf.log4jdbc.sql.jdbcapi.DriverSpy;

public class DataSourceSpy
implements DataSource,
Spy {
    private DataSource realDataSource;
    private SpyLogDelegator log;

    public DataSourceSpy(DataSource realDataSource) {
        this.realDataSource = realDataSource;
        this.log = SpyLogFactory.getSpyLogDelegator();
    }

    public SpyLogDelegator getLogDelegator() {
        return this.log;
    }

    public void setLogDelegator(SpyLogDelegator spyLogDelegator) {
        this.log = spyLogDelegator;
    }

    protected void reportException(String methodCall, SQLException exception) {
        this.log.exceptionOccured(this, methodCall, exception, null, -1L);
    }

    private Object reportReturn(String methodCall, Object value) {
        this.log.methodReturned(this, methodCall, "");
        return value;
    }

    public Connection getConnection() throws SQLException {
        String methodCall = "getConnection()";
        long tstart = System.currentTimeMillis();
        try {
            Connection connection = this.realDataSource.getConnection();
            if (this.log.isJdbcLoggingEnabled()) {
                return (Connection)this.reportReturn(methodCall, new ConnectionSpy(connection, DriverSpy.getRdbmsSpecifics(connection), System.currentTimeMillis() - tstart, this.log));
            }
            return connection;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public Connection getConnection(String username, String password) throws SQLException {
        String methodCall = "getConnection(" + username + ", password***)";
        long tstart = System.currentTimeMillis();
        try {
            Connection connection = this.realDataSource.getConnection(username, password);
            if (this.log.isJdbcLoggingEnabled()) {
                return (Connection)this.reportReturn(methodCall, new ConnectionSpy(connection, DriverSpy.getRdbmsSpecifics(connection), System.currentTimeMillis() - tstart, this.log));
            }
            return connection;
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public int getLoginTimeout() throws SQLException {
        String methodCall = "getLoginTimeout()";
        try {
            return (Integer)this.reportReturn(methodCall, this.realDataSource.getLoginTimeout());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        String methodCall = "getLogWriter()";
        try {
            return (PrintWriter)this.reportReturn(methodCall, this.realDataSource.getLogWriter());
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        String methodCall = "setLoginTimeout(" + seconds + ")";
        try {
            this.realDataSource.setLoginTimeout(seconds);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        String methodCall = "setLogWriter(" + out + ")";
        try {
            this.realDataSource.setLogWriter(out);
        }
        catch (SQLException s) {
            this.reportException(methodCall, s);
            throw s;
        }
    }

    public String getClassType() {
        return "DataSource";
    }

    public Integer getConnectionNumber() {
        return null;
    }
}

