/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime.tracking;

import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.IReportInfo;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;

public class ReportInfo
extends Trackable {
    private VariableName variableName;
    private String reason;
    private String transactionName;
    private String level;
    private String type;

    public ReportInfo(String type, String level, String transactionName, String reason, String variableName) {
        this.variableName = new VariableName(variableName);
        this.reason = reason;
        this.transactionName = transactionName;
        this.level = level;
        this.type = type;
    }

    public void trackItems(SCESession mySession) {
        IReportInfo writer = mySession.getReportOutput();
        StringBuffer sb = new StringBuffer();
        this.formatVariable(mySession, this.variableName, sb);
        writer.report(this.level, this.type, this.transactionName, this.reason, this.variableName.toString(), sb.toString());
    }

    public static void alarm(String level, String reason, Throwable e, SCESession mySession) {
        IReportInfo writer = mySession.getReportOutput();
        StringBuffer sb = new StringBuffer();
        sb.append(reason);
        sb.append("\r\n");
        Trackable.formatException(e, sb);
        writer.report(level, "In Progress", "", e.toString(), "Exception stack trace", sb.toString());
    }

    public static void alarm(String level, Throwable e, SCESession mySession) {
        IReportInfo writer = mySession.getReportOutput();
        StringBuffer sb = new StringBuffer();
        Trackable.formatException(e, sb);
        writer.report(level, "In Progress", "", e.toString(), "Exception stack trace", sb.toString());
    }

    public static void alarm(String level, String reason, SCESession mySession) {
        IReportInfo writer = mySession.getReportOutput();
        StringBuffer sb = new StringBuffer();
        sb.append(reason);
        writer.report(level, "In Progress", "", sb.toString(), "", "");
    }
}

