/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.AppServlet;
import com.avaya.sce.runtime.ComplexVariable;
import com.avaya.sce.runtime.Condition;
import com.avaya.sce.runtime.IPluggableExecutable;
import com.avaya.sce.runtime.Next;
import com.avaya.sce.runtime.SimpleVariable;
import com.avaya.sce.runtime.tracking.Trackable;
import com.avaya.sce.runtimecommon.IDataContext;
import com.avaya.sce.runtimecommon.IDebugging;
import com.avaya.sce.runtimecommon.IEvaluatable;
import com.avaya.sce.runtimecommon.IExecutable;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.debug.DebugInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public abstract class Data
extends AppServlet {
    private Next nextValue = null;

    public abstract boolean executeDataActions(SCESession var1) throws Exception;

    public abstract Next getNext(SCESession var1);

    public void setNext(Next next) {
        this.nextValue = next;
    }

    public Collection<VariableInfo> getLocalVariables() {
        return null;
    }

    @Override
    public final void handleRequest(SCESession mySession) throws IOException, ServletException {
        boolean branched = false;
        DataContext dataContext = new DataContext();
        try {
            Collection<VariableInfo> localVariable = this.getLocalVariables();
            if (localVariable != null) {
                for (VariableInfo varInfo : localVariable) {
                    dataContext.addVariable(varInfo);
                }
            }
            mySession.setDataContext((IDataContext)dataContext);
            branched = this.executeDataActions(mySession);
        }
        catch (Exception e) {
            dataContext.cleanup();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            StringBuffer sb = new StringBuffer();
            Trackable.formatException(e, sb);
            throw new ServletException(sb.toString());
        }
        if (!branched) {
            Next next = this.nextValue == null ? this.getNext(mySession) : this.nextValue;
            if (next == null) {
                mySession.throwRTException("Invalid Data Collection in form " + this.getName() + ", missing reference to next flow node");
            }
            if (mySession.isRunInDebug()) {
                String servletName;
                String projectName;
                block12: {
                    projectName = "";
                    servletName = "";
                    try {
                        HttpServletRequest request = mySession.getRequest();
                        projectName = request.getContextPath().substring(1);
                        servletName = request.getServletPath();
                        int index = servletName.lastIndexOf(47);
                        servletName = servletName.substring(index + 1);
                    }
                    catch (Exception e) {
                        if (!mySession.isDDTraceEnabled()) break block12;
                        mySession.getTraceOutput().writeln(3, "Unexpected context path [" + mySession.getRequest().getContextPath() + "]");
                    }
                }
                DebugInfo info = (DebugInfo)mySession.getProperty("com.avaya.sce.runtime.debuginfo");
                if (next instanceof IDebugging && info != null) {
                    info.checkBreakPoint(projectName, servletName, next.getDebugId(), "Next");
                }
            }
            dataContext.cleanup();
            this.forward(mySession, next.getNext());
        }
        dataContext.cleanup();
    }

    public boolean evaluateActions(Collection actions, SCESession mySession) throws Exception {
        String servletName;
        String projectName;
        block21: {
            projectName = "";
            servletName = "";
            try {
                HttpServletRequest request = mySession.getRequest();
                projectName = request.getContextPath().substring(1);
                servletName = request.getServletPath();
                int index = servletName.lastIndexOf(47);
                servletName = servletName.substring(index + 1);
            }
            catch (Exception e) {
                if (!mySession.isDDTraceEnabled()) break block21;
                mySession.getTraceOutput().writeln(3, "Unexpected context path [" + mySession.getRequest().getContextPath() + "]");
            }
        }
        DebugInfo info = null;
        if (mySession.isRunInDebug()) {
            info = (DebugInfo)mySession.getProperty("com.avaya.sce.runtime.debuginfo");
        }
        try {
            for (Object item : actions) {
                if (item instanceof IExecutable) {
                    IExecutable executable = (IExecutable)item;
                    if (executable instanceof IDebugging && info != null) {
                        info.checkBreakPoint(projectName, servletName, executable.getDebugId(), "Operation");
                    }
                    executable.execute();
                    continue;
                }
                if (item instanceof IPluggableExecutable) {
                    IPluggableExecutable pluggable = (IPluggableExecutable)item;
                    try {
                        LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)2, (String)("Executing IPluggableExecutable " + pluggable.getId() + " : " + pluggable.getTraceMessage()));
                        if (pluggable instanceof IDebugging && info != null) {
                            info.checkBreakPoint(projectName, servletName, pluggable.getDebugId(), "Pluggable Operation");
                        }
                        pluggable.execute((IRuntimeSession)mySession);
                    }
                    catch (Exception pex) {
                        mySession.throwRTException("Pluggable Data Connector [" + pluggable.getId() + "]", pex);
                    }
                    LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)2, (String)("Completed IPluggableExecutable " + pluggable.getId()));
                    continue;
                }
                if (item instanceof Next) {
                    Next next = (Next)((Object)item);
                    if (next instanceof IDebugging && info != null) {
                        info.checkBreakPoint(projectName, servletName, next.getDebugId(), "Next");
                    }
                    this.forward(mySession, next.getNext());
                    return true;
                }
                if (item instanceof IEvaluatable) {
                    IEvaluatable assignment = (IEvaluatable)item;
                    if (assignment instanceof IDebugging && info != null) {
                        info.checkBreakPoint(projectName, servletName, assignment.getDebugId(), "Assign");
                    }
                    assignment.evaluate((IRuntimeSession)mySession);
                    continue;
                }
                if (item instanceof Condition) {
                    Condition condition = (Condition)((Object)item);
                    if (condition instanceof IDebugging && info != null) {
                        info.checkBreakPoint(projectName, servletName, condition.getDebugId(), "Condition");
                    }
                    boolean result = condition.evaluate((IRuntimeSession)mySession);
                    LoggerUtil.writeTrace((IRuntimeSession)mySession, (int)2, (String)("Condition Evaluated to : " + result));
                    if (condition.getNext() == null || !result) continue;
                    this.forward(mySession, condition.getNext());
                    return true;
                }
                if (item instanceof Trackable) {
                    Trackable trackable = (Trackable)((Object)item);
                    if (trackable instanceof IDebugging && info != null) {
                        info.checkBreakPoint(projectName, servletName, trackable.getDebugId(), "Tracking");
                    }
                    trackable.trackItems(mySession);
                    continue;
                }
                mySession.throwRTException("Invalid Data Action in form " + this.getName());
            }
        }
        catch (SCERuntimeException e) {
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return false;
    }

    public static class VariableInfo {
        private String name;
        private String value;
        private String[] fields;
        private String[] values;
        private boolean isComplex;

        public VariableInfo(String name, String value) {
            if (name.indexOf("(L)") > -1) {
                int pos = name.indexOf("(L)");
                name = name.substring(0, pos);
            }
            this.name = name;
            this.value = value;
        }

        public VariableInfo(String name, String[] fields, String[] values) {
            if (name.indexOf("(L)") > -1) {
                int pos = name.indexOf("(L)");
                name = name.substring(0, pos);
            }
            this.name = name;
            this.fields = fields;
            this.values = values;
            this.isComplex = true;
        }

        public static VariableInfo createSimpleVariable(String name, String value) {
            return new VariableInfo(name, value);
        }

        public static VariableInfo createComplexVariable(String name, String[] fields, String[] values) {
            return new VariableInfo(name, fields, values);
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getFields() {
            return this.fields;
        }

        public String[] getValues() {
            return this.values;
        }

        public boolean isComplex() {
            return this.isComplex;
        }
    }

    public static class DataContext
    implements IDataContext {
        private Map<String, IVariable> localVariables = new HashMap<String, IVariable>();

        public void addVariable(VariableInfo variableInfo) {
            IVariable variable = null;
            variable = variableInfo.isComplex() ? ComplexVariable.createComplexVariable(variableInfo.getName(), variableInfo.getFields(), variableInfo.getValues(), null, null, false, false) : SimpleVariable.createSimpleVariable(variableInfo.getName(), variableInfo.getValue(), null, null, false, false);
            this.localVariables.put(variableInfo.getName(), variable);
        }

        public IVariable getVariable(String varName) {
            return this.localVariables.get(varName);
        }

        public Collection<String> getVariableNames() {
            ArrayList<String> names = new ArrayList<String>();
            Set<String> localNames = this.localVariables.keySet();
            for (String name : localNames) {
                names.add(name + "(L)");
            }
            return names;
        }

        public void cleanup() {
            this.localVariables.clear();
        }
    }
}

