/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.ade.common.utils.crypto.Crypto;
import com.avaya.sce.runtime.AppDocument;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IPostGenerator;
import com.avaya.sce.runtime.Link;
import com.avaya.sce.runtime.Root;
import com.avaya.sce.runtime.internal.FlowFinder;
import com.avaya.sce.runtime.perf.Performance;
import com.avaya.sce.runtime.textxml.OutputGeneratorHtml;
import com.avaya.sce.runtimecommon.IVariable;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.sce.runtimecommon.VariableName;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import javax.servlet.ServletContext;

public abstract class OutputGenerator
implements IOutputGenerator {
    public static final String USER_AGENT = "User-Agent";
    public static final String AVAYA_GENERATOR = "Avaya-Generator";
    public static final String HTML_BROWSER = "Mozilla";
    public static final String AVAYA_TEXT_BROWSER = "Avaya Text Browser/1.0";
    public static final String AVAYA_DATA = "Avaya-Data";
    public SCESession mySession;
    public PrintStream out;
    protected ByteArrayOutputStream bytes;
    private long start;
    protected boolean isSecureFetch = false;
    protected boolean inRoot = false;

    public static IOutputGenerator getInstance(SCESession mySession) {
        String agent = mySession.getRequest().getHeader(USER_AGENT);
        mySession.setProperty("___sageishtmlmode", (Object)new Boolean(false));
        if (agent.indexOf(AVAYA_DATA) != -1) {
            return new com.avaya.sce.runtime.data.OutputGenerator(mySession);
        }
        if (agent.indexOf(AVAYA_TEXT_BROWSER) != -1) {
            String generatorName = mySession.getRequest().getHeader(AVAYA_GENERATOR);
            try {
                DefaultGenerators gen = DefaultGenerators.valueOf(generatorName);
                switch (gen) {
                    case defaultsms: {
                        return new com.avaya.sce.runtime.textxml.OutputGenerator(mySession);
                    }
                    case defaultemail: {
                        return new com.avaya.sce.runtime.textxml.OutputGenerator(mySession);
                    }
                }
                throw new SCERuntimeException("Channel Type " + (Object)((Object)gen) + " not supported");
            }
            catch (IllegalArgumentException e1) {
                try {
                    Class<?> genClass = Class.forName(generatorName);
                    Constructor<?> constructor = genClass.getConstructor(SCESession.class);
                    return (IOutputGenerator)constructor.newInstance(mySession);
                }
                catch (Exception e2) {
                    throw new SCERuntimeException("Generator class " + generatorName + " not not found");
                }
            }
        }
        if (agent.indexOf(HTML_BROWSER) != -1) {
            ServletContext context = mySession.getServlet().getServletContext();
            String nature = context.getInitParameter("runtime-nature");
            if (nature.equalsIgnoreCase("speech")) {
                String showVXML = mySession.getRequest().getParameter("__Dialog__Designer__VXMLINHTML");
                if (showVXML != null && showVXML.equalsIgnoreCase("true")) {
                    return new com.avaya.sce.runtime.vxml.OutputGenerator(mySession);
                }
                mySession.setProperty("___sageishtmlmode", (Object)new Boolean(true));
                return new com.avaya.sce.runtime.html.OutputGenerator(mySession);
            }
            return new OutputGeneratorHtml(mySession);
        }
        return new com.avaya.sce.runtime.vxml.OutputGenerator(mySession);
    }

    public OutputGenerator(SCESession mySession) {
        this.mySession = mySession;
        this.bytes = new ByteArrayOutputStream(1024);
        try {
            this.out = new PrintStream((OutputStream)this.bytes, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            mySession.throwRTException("Error Unsupported Encoding", (Exception)e);
        }
        this.start = System.currentTimeMillis();
    }

    @Override
    public void setSecureFetch(boolean secure) {
        this.isSecureFetch = secure;
    }

    private void logBody(String body, Boolean isPrivate) {
        if (!this.mySession.getRuntimePropertyEnabled("localddtrace") || !this.mySession.getRuntimePropertyEnabled("showxml")) {
            return;
        }
        if (isPrivate.booleanValue()) {
            this.mySession.getTraceOutput().writeln(1, "*** VXML output skipped due to privacy ***");
            return;
        }
        String value = this.mySession.getRuntimeProperty("showxmlroot");
        if (value == null) {
            value = "once";
        }
        if (this.mySession.getCurrentLocationId().equalsIgnoreCase("AppRoot")) {
            if (value.equalsIgnoreCase("once")) {
                String p = "___sageroottraced" + this.mySession.getAppName();
                String s = (String)this.mySession.getProperty(p);
                if (s != null) {
                    return;
                }
                this.mySession.setProperty(p, (Object)p);
            } else if (value.equalsIgnoreCase("never")) {
                return;
            }
        }
        String myBody = new String(body);
        if (this.mySession.getRuntimePropertyEnabled("xmlrootinline") && (value.equalsIgnoreCase("once") || value.equalsIgnoreCase("never"))) {
            String p = "___sageroottraced" + this.mySession.getAppName();
            String s = (String)this.mySession.getProperty(p);
            if (s != null || value.equalsIgnoreCase("never")) {
                String metaMarker = ", Avaya\"/>";
                String endMarker = "Avaya Aura Orchestration Designer Root End\"/>";
                int index = myBody.indexOf(metaMarker);
                if (index != -1) {
                    String traceBody = myBody.substring(0, index += metaMarker.length() + 2);
                    index = myBody.indexOf(endMarker);
                    if (index != -1) {
                        myBody = traceBody = traceBody + myBody.substring(index += endMarker.length() + 2);
                    }
                }
            }
            this.mySession.setProperty(p, (Object)p);
        }
        int index = 1;
        int lineNo = 0;
        int last = 0;
        ByteArrayOutputStream lineNoBytes = new ByteArrayOutputStream(1024);
        PrintStream lineNoOut = null;
        try {
            lineNoOut = new PrintStream((OutputStream)lineNoBytes, false, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.mySession.throwRTException("Error Unsupported Encoding", (Exception)e);
        }
        myBody = myBody.replace('\r', ' ');
        myBody = myBody.replace('\n', '^');
        this.mySession.getTraceOutput().writeln(1, "*** Reply for [" + this.mySession.getRequestCopyURI() + "] ***");
        do {
            String line;
            if ((index = myBody.indexOf(94, last)) != -1) {
                line = lineNo + ":";
                line = line + myBody.substring(last, index);
                lineNoOut.println(line);
                last = index + 1;
            } else {
                line = lineNo + ":";
                line = line + myBody.substring(last);
                lineNoOut.println(line);
            }
            ++lineNo;
        } while (index != -1);
        try {
            this.mySession.getTraceOutput().writeln(1, lineNoBytes.toString("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            this.mySession.throwRTException("Error logging trace information", (Exception)e);
        }
    }

    @Override
    public final void reset() {
        try {
            this.out.close();
            this.bytes.close();
            this.bytes = new ByteArrayOutputStream();
            try {
                this.out = new PrintStream((OutputStream)this.bytes, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                this.mySession.throwRTException("Error Unsupported Encoding", (Exception)e);
            }
        }
        catch (IOException e) {
            this.mySession.throwRTException("Error resetting response", (Exception)e);
        }
    }

    @Override
    public final void send(AppDocument document) {
        try {
            long stop = System.currentTimeMillis();
            Performance.update("_avaya-page-gen|Page Generation", stop - this.start, this.mySession.getServlet().getServletName());
            this.out.close();
            this.bytes.close();
            Boolean isPrivateTrace = (Boolean)this.mySession.getProperty("___sagenovxmltrace");
            boolean isPrivate = isPrivateTrace == null ? false : isPrivateTrace;
            this.mySession.removeProperty("___sagenovxmltrace");
            if (this.mySession.getRuntimePropertyEnabled("forcevxmldisplayonsecure")) {
                isPrivate = false;
            }
            boolean skipLog = false;
            String noXml = (String)this.mySession.getProperty("___sageredirectnoxml");
            this.mySession.removeProperty("___sageredirectnoxml");
            if (noXml != null) {
                skipLog = true;
            }
            if (document != null && !this.mySession.isRequestStillValid(((Object)((Object)document)).getClass(), !this.mySession.getTOSFrame().isLocalCall() && this.mySession.getMessageType() == SCESession.MessageType.speech)) {
                if (!this.mySession.getTOSFrame().isLocalCall() && this.mySession.getMessageType() == SCESession.MessageType.speech) {
                    System.out.println("*** Abandoning thread sessionid [" + this.mySession.getSessionId() + "], reply not sent.");
                    System.err.println("*** Abandoning thread sessionid [" + this.mySession.getSessionId() + "], reply not sent.");
                    return;
                }
                skipLog = true;
            }
            this.setContentType(this.mySession.getResponse());
            PrintWriter output = this.mySession.getResponse().getWriter();
            int responseLength = this.bytes.size();
            String body = this.bytes.toString("UTF-8");
            if (!skipLog) {
                this.logBody(body, isPrivate);
            }
            if (document != null) {
                if (!document.isCached() || this.mySession.isForwardRedirect()) {
                    this.mySession.getResponse().setHeader("Cache-Control", "no-cache, no-store");
                    this.mySession.getResponse().setHeader("Expires", "-1");
                } else {
                    Enumeration e = this.mySession.getRequest().getHeaders("Cache-Control");
                    while (e.hasMoreElements()) {
                        String value = (String)e.nextElement();
                        if (this.mySession.getResponse().containsHeader("Cache-Control")) {
                            this.mySession.getResponse().addHeader("Cache-Control", value);
                            continue;
                        }
                        this.mySession.getResponse().setHeader("Cache-Control", value);
                    }
                }
            }
            URL reqURL = new URL(this.mySession.getRequestCopyURL());
            URL termURL = new URL(reqURL, "AvayaSessionTerminationServlet?___DDSESSIONID=" + this.mySession.getEncodedSessionId());
            this.mySession.getResponse().setHeader("TerminationURL", termURL.toString());
            this.mySession.getResponse().setContentLength(responseLength);
            this.mySession.getResponse().setHeader("Content-Length", Integer.toString(responseLength));
            output.print(body);
            if (!skipLog) {
                this.mySession.setForwardRedirect(false);
            }
        }
        catch (Exception e) {
            this.mySession.throwRTException("Send reply error", e);
        }
        try {
            this.out.close();
            this.bytes.close();
            this.mySession = null;
            this.out = null;
            this.bytes = null;
        }
        catch (IOException e) {
            this.mySession.throwRTException("Send reply closing streams", (Exception)e);
        }
    }

    @Override
    public SCESession getMySession() {
        return this.mySession;
    }

    private static String getVariableInternal(SCESession mySession, String name, IOutputGenerator.PrivacyKind privacyType) {
        Boolean isPrivate;
        String varValue;
        VariableName varName = new VariableName(name);
        IVariableField var = mySession.getVariableField(varName);
        if (var == null) {
            mySession.throwRTException("Variable " + name + " does not exist");
        }
        if ((varValue = var.getStringValue()) == null) {
            mySession.throwRTException("Variable " + name + " is not set");
        }
        if (varValue.equals("__DD_NULL")) {
            varValue = "";
        }
        if (privacyType == IOutputGenerator.PrivacyKind.LOG) {
            Boolean isPrivate2 = (Boolean)var.getAttribute("avaya.dd.private");
            if (isPrivate2.booleanValue()) {
                varValue = "*** value skipped due to privacy ***";
            }
        } else if (privacyType == IOutputGenerator.PrivacyKind.ENCRYPT && (isPrivate = (Boolean)var.getAttribute("avaya.dd.private")).booleanValue()) {
            try {
                varValue = "___AvayaEncrypted_" + new String(Crypto.encrypt((byte[])varValue.getBytes()));
            }
            catch (Exception e) {
                throw new SCERuntimeException((Throwable)e);
            }
        }
        return varValue;
    }

    @Override
    public String getVariable(String name) {
        return OutputGenerator.getVariableInternal(this.mySession, name, IOutputGenerator.PrivacyKind.NONE);
    }

    public static String getVariableWithPrivacy(String name, IOutputGenerator.PrivacyKind kind, SCESession mySession) {
        IVariable var = mySession.getVariable(name);
        VariableName varName = new VariableName(name);
        if (var == null) {
            mySession.throwRTException("Variable " + name + " does not exist");
        }
        if (var.isSimpleVariable()) {
            return OutputGenerator.getVariableInternal(mySession, name, kind);
        }
        if (varName.getFieldName() != null) {
            return OutputGenerator.getVariableInternal(mySession, name, kind);
        }
        String[] fieldNames = var.getComplexVariable().getFieldNames();
        String result = null;
        for (String fieldName : fieldNames) {
            result = result == null ? OutputGenerator.getVariableInternal(mySession, name + ":" + fieldName, kind) : result + "^" + OutputGenerator.getVariableInternal(mySession, name + ":" + fieldName, kind);
        }
        return result;
    }

    @Override
    public String getVariableWithPrivacy(String name, IOutputGenerator.PrivacyKind kind) {
        IVariable var = this.mySession.getVariable(name);
        VariableName varName = new VariableName(name);
        if (var == null) {
            this.mySession.throwRTException("Variable " + name + " does not exist");
        }
        if (var.isSimpleVariable()) {
            return OutputGenerator.getVariableInternal(this.mySession, name, kind);
        }
        if (varName.getFieldName() != null) {
            return OutputGenerator.getVariableInternal(this.mySession, name, kind);
        }
        String[] fieldNames = var.getComplexVariable().getFieldNames();
        String result = null;
        for (String fieldName : fieldNames) {
            result = result == null ? OutputGenerator.getVariableInternal(this.mySession, name + ":" + fieldName, kind) : result + "^" + OutputGenerator.getVariableInternal(this.mySession, name + ":" + fieldName, kind);
        }
        return result;
    }

    public void genAttr(String attr, String value) {
        this.genAttr(attr, value, false);
    }

    public void genAttr(String attr, String value, boolean force) {
        if (force) {
            this.out.print(" ");
            this.out.print(attr);
            this.out.print("=\"");
            if (value != null && value.length() > 0) {
                this.out.print(value);
            }
            this.out.print("\"");
        } else if (value != null && value.length() > 0) {
            this.out.print(" ");
            this.out.print(attr);
            this.out.print("=\"");
            this.out.print(value);
            this.out.print("\"");
        }
    }

    public void genAttr(String attr, boolean value) {
        if (value) {
            this.out.print(" ");
            this.out.print(attr);
            this.out.print("=\"true\"");
        } else {
            this.out.print(" ");
            this.out.print(attr);
            this.out.print("=\"false\"");
        }
    }

    protected void generateFetchAudio(AppDocument document) {
        if (document != null && document.getAutoFlush()) {
            URL url = this.mySession.getFileURL("/data/ddfetchAudio.wav");
            this.out.print("<property");
            this.genAttr("name", "fetchaudio");
            this.genAttr("value", url.toString());
            this.out.println(" />");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateRoot() {
        try {
            this.inRoot = true;
            Root root = (Root)((Object)FlowFinder.getFlowFinder(this.mySession.getCurrentLanguage()).getInstance("AppRoot"));
            this.generateFetchAudio(root);
            long start = System.currentTimeMillis();
            root.requestBegin(this.mySession);
            long stop = System.currentTimeMillis();
            Performance.update("_avaya-request-begin|Request Begin", stop - start, this.mySession.getServlet().getServletName());
            Collection links = root.getLinks(this.mySession);
            start = System.currentTimeMillis();
            root.updateLinks(links, this.mySession);
            stop = System.currentTimeMillis();
            Performance.update("_avaya-update-link|Update Link", stop - start, this.mySession.getServlet().getServletName());
            if (links != null) {
                for (Link link : links) {
                    if (!link.isEnabled()) continue;
                    link.generate(this);
                }
            }
            Collection events = root.getEvents(this.mySession);
            start = System.currentTimeMillis();
            root.updateEvents(events, this.mySession);
            stop = System.currentTimeMillis();
            Performance.update("_avaya-update-events|Update Events", stop - start, this.mySession.getServlet().getServletName());
            this.mySession.setProperty("dd.appdoc.completedevents", (Object)events);
            root.handleRequest(this, this.mySession);
            if (!this.mySession.getRuntimePropertyEnabled("xmlrootinline")) {
                ArrayList<IPostGenerator> postItems = AppDocument.getPostGen(this.mySession);
                for (IPostGenerator item : postItems) {
                    item.postGenerate(this);
                }
                postItems.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace(this.out);
            this.mySession.throwRTException("Error generating Root", e);
        }
        finally {
            this.inRoot = false;
        }
    }

    public static enum DefaultGenerators {
        defaultsms,
        defaultemail,
        defaultwebchat,
        defaultim;

    }
}

