/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.vp.admin.variables.runtime;

import com.avaya.ade.common.utils.xml.XML;
import com.avaya.sce.runtimecommon.IRuntimeSession;
import com.avaya.sce.runtimecommon.LoggerUtil;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.SCESession;
import com.avaya.vp.admin.variables.runtime.AdminParameter;
import com.avaya.vp.admin.variables.runtime.AppInstanceCache;
import com.avaya.vp.admin.variables.runtime.IClientProxy;
import com.avaya.vp.admin.variables.runtime.MockSession;
import com.avaya.vp.admin.variables.runtime.ParameterMetaInfo;
import com.avaya.vp.admin.variables.runtime.SimulatorClientProxy;
import com.avaya.vp.admin.variables.runtime.VPClientProxy;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class AdminVarCache {
    public static final String TIMESTAMP = "__VPVarAppDate";
    private static final String MODULAR_ADMINVAR_KEY = "modular_admin_var_hidden";
    private static AdminVarCache adminVarCache;
    private HashMap<String, AppInstanceCache> appInstances = new HashMap();
    private HashMap<String, ParameterMetaInfo> paramMetaInfo = new HashMap();
    public static IClientProxy paramService;

    private AdminVarCache() {
    }

    private void init(String appName, boolean isMainApp, Date timeStamp, IRuntimeSession session) {
        String moduleName;
        HashMap moduleParams;
        HashMap modules;
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: Timestamp is different; Load parameters....");
        IClientProxy proxy = null;
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("AdminVarCache:init: Module? " + !isMainApp));
        if (isMainApp) {
            if (session instanceof SCESession) {
                if (((SCESession)session).getPlatformSettings().getPlatform().equals("Desktop")) {
                    LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: loading simulation data...");
                    proxy = new SimulatorClientProxy(session);
                } else if (((SCESession)session).getPlatformSettings().getPlatform().equals("Voice Portal") || ((SCESession)session).getPlatformSettings().getPlatform().equals("Experience Portal")) {
                    LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: load data from the Voice Portal/Experience Portal platform");
                    proxy = new VPClientProxy(appName, (SCESession)session);
                } else {
                    LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: platform not supported for admin variables.");
                }
            } else if (session instanceof MockSession) {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: loading unit test data...");
                if (paramService != null) {
                    proxy = paramService;
                }
            }
        } else if (session instanceof SCESession && ((SCESession)session).getPlatformSettings().getPlatform().equals("Desktop")) {
            boolean loadModuleProfData = false;
            modules = (HashMap)((SCESession)session).getProperty(MODULAR_ADMINVAR_KEY);
            if (modules == null) {
                loadModuleProfData = true;
            }
            if (modules != null && (moduleParams = (HashMap)modules.get(moduleName = this.getPhysicalAppName(session))) == null) {
                loadModuleProfData = true;
            }
            if (loadModuleProfData) {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: loading simulation data from module profile...");
                proxy = new SimulatorClientProxy(session);
            }
        }
        HashMap appParams = new HashMap();
        if (proxy != null) {
            HashMap<String, String> proxyParams = proxy.getParams(appName);
            if (proxyParams.size() > 0) {
                HashMap<String, HashMap<String, String>> modules2 = new HashMap<String, HashMap<String, String>>();
                for (Map.Entry<String, String> entry : proxyParams.entrySet()) {
                    if (entry.getKey().indexOf(".") < 0) {
                        appParams.put(entry.getKey(), entry.getValue());
                        continue;
                    }
                    int pos = entry.getKey().indexOf(".");
                    if (pos <= -1) continue;
                    String moduleName2 = entry.getKey().substring(0, pos);
                    String varName = entry.getKey().substring(pos + 1);
                    HashMap<String, String> moduleParams2 = (HashMap<String, String>)modules2.get(moduleName2);
                    if (moduleParams2 == null) {
                        moduleParams2 = new HashMap<String, String>();
                        modules2.put(moduleName2, moduleParams2);
                    }
                    moduleParams2.put(varName, entry.getValue());
                }
                if (modules2.size() > 0) {
                    LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("Dump module var cache: " + modules2));
                    if (session instanceof SCESession) {
                        ((SCESession)session).setProperty(MODULAR_ADMINVAR_KEY, modules2);
                    } else if (session instanceof MockSession) {
                        ((MockSession)session).setProperty(MODULAR_ADMINVAR_KEY, modules2);
                    }
                }
            } else {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: no data comes back from proxy.");
            }
        } else if (isMainApp) {
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: No data loaded.");
        } else {
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: Load data from module...");
            modules = null;
            try {
                if (session instanceof SCESession) {
                    modules = (HashMap)((SCESession)session).getProperty(MODULAR_ADMINVAR_KEY);
                } else if (session instanceof MockSession) {
                    modules = (HashMap)((MockSession)session).getProperty(MODULAR_ADMINVAR_KEY);
                }
            }
            catch (Exception ex) {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)4, (String)"AdminVarCache:init: modular data has been hampered.");
            }
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("Modules: " + modules));
            moduleName = this.getPhysicalAppName(session);
            if (modules != null && (moduleParams = (HashMap)modules.get(moduleName)) != null) {
                appParams = (HashMap)moduleParams.clone();
            }
        }
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("app params: " + appParams));
        HashMap<String, AdminParameter> paramCache = this.getAppInstanceCache(appName).getParamCache();
        if (appParams.size() > 0) {
            paramCache.clear();
            this.storeAppInstanceCache(new AppInstanceCache(appName, timeStamp, paramCache));
        }
        for (Map.Entry entry : appParams.entrySet()) {
            String paramName = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (this.paramMetaInfo.get(paramName) == null) {
                LoggerUtil.writeTrace((IRuntimeSession)session, (int)3, (String)("AdminVarCache:init: parameter " + paramName + " is not defined in the application but loaded from platform."));
            } else {
                String typeRemote;
                ParameterMetaInfo parameterInfo = this.paramMetaInfo.get(paramName);
                String typeInApp = parameterInfo.getType().getType();
                if (proxy != null && (typeRemote = proxy.getType(paramName)) != null && !typeInApp.equals(typeRemote)) {
                    LoggerUtil.writeTrace((IRuntimeSession)session, (int)3, (String)("AdminVarCache:init: parameter " + paramName + " type \"" + typeRemote + "\" from plateform and type \"" + typeInApp + "\" from the application are not the same."));
                }
            }
            LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("load param: " + paramName));
            AdminParameter parameter = new AdminParameter(paramName, value);
            paramCache.put((String)entry.getKey(), parameter);
        }
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)"AdminVarCache:init: Finish loading.");
    }

    public String getValue(IRuntimeSession session, String paramName) {
        String appName = AdminVarCache.getAppName(session);
        LoggerUtil.writeTrace((IRuntimeSession)session, (int)1, (String)("get param for app: " + appName));
        HashMap<String, AdminParameter> paramCache = this.getAppInstanceCache(appName).getParamCache();
        AdminParameter adminParam = paramCache.get(paramName);
        if (adminParam == null) {
            ParameterMetaInfo metaInfo = this.paramMetaInfo.get(paramName);
            if (metaInfo != null) {
                return metaInfo.getDefaultValue();
            }
            return "";
        }
        return adminParam.getValue();
    }

    private void loadMetaInfo(InputStream inputStream) {
        this.paramMetaInfo.clear();
        try {
            Document doc = XML.getDocument((InputStream)inputStream);
            NodeList nodeList = doc.getElementsByTagName("PageletField");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                ParameterMetaInfo metaInfo = new ParameterMetaInfo(nodeList.item(i));
                this.paramMetaInfo.put(metaInfo.getName(), metaInfo);
            }
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error loading meta info" + e);
        }
    }

    private AppInstanceCache getAppInstanceCache(String appName) {
        AppInstanceCache cache = this.appInstances.get(appName);
        if (cache == null) {
            cache = new AppInstanceCache(appName, null, new HashMap<String, AdminParameter>());
        }
        return cache;
    }

    private void storeAppInstanceCache(AppInstanceCache cache) {
        this.appInstances.put(cache.getAppName(), cache);
    }

    public static synchronized void loadAdminMetaInfo(InputStream inputStream) {
        AdminVarCache.getAdminVarCache().loadMetaInfo(inputStream);
    }

    public static synchronized void loadAdminVarCache(String vpAppName, boolean isMainApp, Date timeStamp, IRuntimeSession session) {
        AdminVarCache.getAdminVarCache();
        Date cacheTimeStamp = null;
        AppInstanceCache appCache = adminVarCache.getAppInstanceCache(vpAppName);
        if (appCache != null) {
            cacheTimeStamp = appCache.getTimeStamp();
        }
        if (cacheTimeStamp == null || cacheTimeStamp.compareTo(timeStamp) != 0) {
            adminVarCache.init(vpAppName, isMainApp, timeStamp, session);
        }
    }

    public static synchronized AdminVarCache getAdminVarCache() {
        if (adminVarCache == null) {
            adminVarCache = new AdminVarCache();
        }
        return adminVarCache;
    }

    public static String getAppName(boolean mainApp, IRuntimeSession session) {
        if (session instanceof SCESession) {
            SCESession sceSession = (SCESession)session;
            if (mainApp) {
                String appName = sceSession.getRequest().getParameter("__VPappname");
                if (appName == null) {
                    appName = sceSession.getAppName().substring(1);
                }
                sceSession.setProperty("__VPappname", (Object)appName);
                return appName;
            }
            return (String)sceSession.getProperty("__VPappname");
        }
        if (session instanceof MockSession) {
            return ((MockSession)session).getAppName();
        }
        return "NO_APPNAME";
    }

    public static String getAppName(IRuntimeSession session) {
        if (session instanceof SCESession) {
            SCESession sceSession = (SCESession)session;
            return (String)sceSession.getProperty("__VPappname");
        }
        return ((MockSession)session).getAppName();
    }

    public static String getTimeStamp(boolean mainApp, IRuntimeSession session) {
        if (session instanceof SCESession) {
            SCESession sceSession = (SCESession)session;
            String dateString = sceSession.getRequest().getParameter(TIMESTAMP);
            if (mainApp) {
                if (dateString == null) {
                    dateString = "" + new Date().getTime();
                }
                sceSession.setProperty(TIMESTAMP, (Object)dateString);
                return dateString;
            }
            dateString = (String)sceSession.getProperty(TIMESTAMP);
            if (dateString == null) {
                dateString = "" + new Date().getTime();
            }
            return dateString;
        }
        if (session instanceof MockSession) {
            return ((MockSession)session).getTimeStamp();
        }
        return null;
    }

    private String getPhysicalAppName(IRuntimeSession session) {
        if (session instanceof SCESession) {
            SCESession sceSession = (SCESession)session;
            return sceSession.getAppName().substring(1);
        }
        if (session instanceof MockSession) {
            return ((MockSession)session).getAppName();
        }
        return null;
    }

    public static void reset() {
        adminVarCache = null;
    }
}

