/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.Media;
import com.avaya.sce.runtime.MediaElement;
import com.avaya.sce.runtime.internal.MediaFinder;
import com.avaya.sce.runtimecommon.IVariableField;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import com.avaya.sce.runtimecommon.VariableName;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;

public class MediaInfo
extends MediaElement {
    public static final int MEDIA_ELEMENT = 1;
    public static final int MEDIA_VARIABLE = 2;
    Media mediaObject = null;
    int mediaVar = 1;
    String mediaName = "";
    String region = "";
    double begin = 0.0;
    double end = 0.0;
    double duration = 0.0;
    double repeatDuration = 0.0;
    double repeatCount = 0.0;
    double clipBegin = 0.0;
    double clipEnd = 0.0;
    String fill = "";

    public MediaInfo(int mediaVar, String mediaName, String region, double begin, double end, double duration, double repeatDuration, double repeatCount, double clipBegin, double clipEnd, String fill) {
        super(11, "");
        this.mediaVar = mediaVar;
        this.mediaName = mediaName;
        this.region = region;
        this.begin = begin;
        this.end = end;
        this.duration = duration;
        this.repeatDuration = repeatDuration;
        this.repeatCount = repeatCount;
        this.clipBegin = clipBegin;
        this.clipEnd = clipEnd;
        this.fill = fill;
    }

    public void generate(IOutputGenerator generator) {
        generator.mediaBegin(this);
    }

    private Media getMediaObject() {
        Media media;
        if (this.mediaObject != null) {
            return this.mediaObject;
        }
        String mName = this.getMediaName();
        if (this.mediaVar == 2) {
            IVariableField var = this.mySession.getVariableField(new VariableName(mName));
            mName = var.getStringValue();
        }
        try {
            media = MediaFinder.load(mName, this.mySession.getCurrentLanguage());
        }
        catch (Exception e) {
            throw new SCERuntimeException("Error instantiating media:" + mName, e);
        }
        return media;
    }

    public String getMediaURL() {
        if (this.mediaVar == 1 || this.mediaVar == 2) {
            String name;
            Media media = this.getMediaObject();
            String sMediaType = "";
            switch (media.getMediaType()) {
                case 1: {
                    sMediaType = "audio";
                    break;
                }
                case 2: {
                    sMediaType = "video";
                    break;
                }
                case 3: {
                    sMediaType = "images";
                    break;
                }
                case 4: {
                    sMediaType = "text";
                }
            }
            if (media.getMediaContextParam() != null && media.getMediaContextParam().length() > 0) {
                String url = this.getURLBase(media.getMediaContextParam());
                if (!url.endsWith("/")) {
                    url = url + "/";
                }
                url = url + media.getMediaFilename();
                return url;
            }
            try {
                name = MediaFinder.getMediaFinder(this.mySession.getCurrentLanguage()).resolveResourceName(media.getMediaFilename(), sMediaType);
            }
            catch (Exception e) {
                throw new SCERuntimeException("Error resolving media file:" + media.getMediaFilename(), e);
            }
            URL url = this.mySession.getFileURL(name);
            return url.toString();
        }
        return null;
    }

    private String getURLBase(String contextURL) {
        if (contextURL == null) {
            throw new SCERuntimeException("Context parameter name not set for phraseset external phrase URL base.");
        }
        if (this.mySession == null) {
            throw new SCERuntimeException("Invalid session");
        }
        HttpServlet servlet = this.mySession.getServlet();
        if (servlet == null) {
            throw new SCERuntimeException("Invalid servlet returned from session!");
        }
        ServletContext context = servlet.getServletContext();
        if (context == null) {
            throw new SCERuntimeException("Invalid servlet context returned from servlet!");
        }
        String urlBase = context.getInitParameter(contextURL);
        if (urlBase == null || urlBase.length() == 0) {
            throw new SCERuntimeException("No url base found for media in the web.xml");
        }
        return urlBase;
    }

    public int getMediaType() {
        Media media = this.getMediaObject();
        return media.getMediaType();
    }

    public String hookGetMediaURL(String srcURL) {
        Media media = this.getMediaObject();
        media.setSession(this.mySession);
        return media.hookGetMediaURL(srcURL);
    }

    public int hookGetMediaType(int mediaType, String srcURL) {
        Media media = this.getMediaObject();
        media.setSession(this.mySession);
        return media.hookGetMediaType(mediaType, srcURL);
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public String getRegion() {
        return this.region;
    }

    public double getBegin() {
        return this.begin;
    }

    public double getEnd() {
        return this.end;
    }

    public double getDuration() {
        return this.duration;
    }

    public double getRepeatDuration() {
        return this.repeatDuration;
    }

    public double getRepeatCount() {
        return this.repeatCount;
    }

    public double getClipBegin() {
        return this.clipBegin;
    }

    public double getClipEnd() {
        return this.clipEnd;
    }

    public String getFill() {
        return this.fill;
    }
}

