/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.GrammarItem;
import com.avaya.sce.runtime.IGrammarRule;
import com.avaya.sce.runtimecommon.SCERuntimeException;
import java.util.ArrayList;
import java.util.HashMap;

public class GrammarRule
implements IGrammarRule {
    ArrayList<GrammarItem> items = new ArrayList();
    String id = null;
    String repeat = "-1";
    String compatibility = "SRGS-Literals";
    String mode = "voice";
    private static final String[] NAMES = new String[]{"abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this ", "break", "double", "implements", "protected", "throw ", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "export", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "var", "true", "false", "function", "import", "in", "with", "null"};
    private static final HashMap<String, String> NAMES_TABLE = new HashMap();

    public GrammarRule() {
        this.id = "rule" + (int)(Math.random() * 1.0E7);
    }

    public GrammarRule(String id) {
        if (NAMES_TABLE.get(id) != null) {
            throw new SCERuntimeException("Invalid grammar slot name");
        }
        this.id = id;
    }

    public GrammarRule(String id, String repeat) {
        if (NAMES_TABLE.get(id) != null) {
            throw new SCERuntimeException("Invalid grammar slot name");
        }
        this.id = id;
        this.repeat = repeat;
    }

    public void add(GrammarItem item) {
        this.items.add(item);
    }

    private void appendTagInit(StringBuffer sb) {
        if (this.compatibility.equals("Nuance OSR")) {
            sb.append("<tag>atag=''</tag>");
        }
        if (this.compatibility.equals("SRGS-SISR")) {
            sb.append("<tag>out='';</tag>");
        }
        if (this.compatibility.equals("IBM")) {
            sb.append("<tag>$=''</tag>");
        }
        if (this.compatibility.equals("SRGS-Literals")) {
            // empty if block
        }
    }

    private void appendTagConcatenate(StringBuffer sb, String colId) {
        if (this.compatibility.equals("Nuance OSR")) {
            sb.append("<item repeat=\"" + this.repeat + "\"><ruleref uri=\"#" + colId + "\"/><tag>atag+=" + colId + ".atag</tag></item>");
        }
        if (this.compatibility.equals("SRGS-SISR")) {
            sb.append("<item repeat=\"" + this.repeat + "\"><ruleref uri=\"#" + colId + "\"/><tag>out+=rules." + colId + "</tag></item>");
        }
        if (this.compatibility.equals("IBM")) {
            sb.append("<item repeat=\"" + this.repeat + "\"><ruleref uri=\"#" + colId + "\"/><tag>$+=$" + colId + "</tag></item>");
        }
        if (this.compatibility.equals("SRGS-Literals")) {
            sb.append("<item><item repeat=\"" + this.repeat + "\"><ruleref uri=\"#" + colId + "\"/></item></item>");
        }
    }

    public String toString(int i) {
        StringBuffer sb = new StringBuffer();
        String colId = this.getId();
        if (!this.repeat.equals("-1") && this.repeat.length() > 0) {
            sb.append("<rule id=\"" + colId + "\" scope=\"private\">");
            this.appendTagInit(sb);
            colId = colId + "repeat";
            this.appendTagConcatenate(sb, colId);
            sb.append("</rule>");
        }
        sb.append("<rule id=\"" + colId + "\" scope=\"private\">");
        this.appendTagInit(sb);
        sb.append("<one-of>");
        for (int j = 0; j < this.items.size(); ++j) {
            GrammarItem item = this.items.get(j);
            sb.append(item.toString(i));
        }
        sb.append("</one-of>");
        sb.append("</rule>");
        return sb.toString();
    }

    public void setCompatibility(String string) {
        this.compatibility = string;
        for (int j = 0; j < this.items.size(); ++j) {
            GrammarItem item = this.items.get(j);
            item.setCompatibility(string);
        }
    }

    public void setMode(String string) {
        this.mode = string;
        for (int j = 0; j < this.items.size(); ++j) {
            GrammarItem item = this.items.get(j);
            item.setMode(string);
        }
    }

    public String getCompatibility() {
        return this.compatibility;
    }

    public String getMode() {
        return this.mode;
    }

    public void setId(String id) {
        if (NAMES_TABLE.get(id) != null) {
            throw new SCERuntimeException("Invalid grammar slot name");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    static {
        for (String str : NAMES) {
            NAMES_TABLE.put(str, str);
        }
    }
}

