/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.sce.runtime;

import com.avaya.sce.runtime.IGenerator;
import com.avaya.sce.runtime.IOutputGenerator;
import com.avaya.sce.runtime.IRuntimePrompt;
import com.avaya.sce.runtime.Parameter;
import com.avaya.sce.runtime.Prompt;
import com.avaya.sce.runtime.PromptRefInfo;
import com.avaya.sce.runtime.internal.PromptFinder;
import com.avaya.sce.runtime.perf.Performance;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformObject
implements IGenerator {
    String name;
    String classId;
    String data;
    String type;
    String archive;
    String codeBase;
    String codeType;
    Collection<Parameter> params;
    Collection<String> shadowVariables;
    Collection promptNames;

    public PlatformObject(String name, String classId, String data, String type, String archive, String codeBase, String codeType, Collection promptNames) {
        this.name = name;
        this.classId = classId;
        this.data = data;
        this.type = type;
        this.archive = archive;
        this.codeBase = codeBase;
        this.codeType = codeType;
        this.promptNames = promptNames;
        this.params = new ArrayList<Parameter>();
        this.shadowVariables = new ArrayList<String>();
    }

    @Override
    public void generate(IOutputGenerator generator) {
        ArrayList<IRuntimePrompt> prompts = new ArrayList<IRuntimePrompt>();
        if (this.promptNames != null) {
            for (Object promptInfo : this.promptNames) {
                String promptName = "";
                String language = "";
                if (promptInfo instanceof String) {
                    promptName = (String)promptInfo;
                } else {
                    promptName = ((PromptRefInfo)promptInfo).getName();
                    language = ((PromptRefInfo)promptInfo).getLanguage();
                }
                IRuntimePrompt prompt = PromptFinder.load(promptName, language, generator.getMySession());
                prompts.add(prompt);
                long start = System.currentTimeMillis();
                prompt.updatePrompt(generator.getMySession());
                long stop = System.currentTimeMillis();
                Performance.update("_avaya-update-prompt|Update Prompt", stop - start, generator.getMySession().getServlet().getServletName());
                Prompt p = (Prompt)prompt;
                p.setFormPrompt(true);
            }
        }
        generator.platformObjectBegin(this, prompts);
        for (int i = 0; i < prompts.size(); ++i) {
            Prompt prompt = (Prompt)prompts.get(i);
            prompt.generate(generator);
        }
        generator.platformObjectEnd(this);
    }

    public String getClassId() {
        return this.classId;
    }

    public String getName() {
        return this.name;
    }

    public void addParam(String name, String value, int mode) {
        this.params.add(new Parameter(name, value, mode));
    }

    public Collection<Parameter> getParams() {
        return this.params;
    }

    public void addShadowVariable(String name) {
        this.shadowVariables.add(name);
    }

    public Collection<String> getShadowVariables() {
        return this.shadowVariables;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getCodeBase() {
        return this.codeBase;
    }

    public String getCodeType() {
        return this.codeType;
    }

    public String getData() {
        return this.data;
    }

    public String getType() {
        return this.type;
    }

    public Collection getPromptNames() {
        return this.promptNames;
    }

    public void setPromptNames(Collection promptNames) {
        this.promptNames = promptNames;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setClassId(String classId) {
        this.classId = classId;
    }

    public void setCodeBase(String codeBase) {
        this.codeBase = codeBase;
    }

    public void setCodeType(String codeType) {
        this.codeType = codeType;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParams(Collection<Parameter> params) {
        this.params = params;
    }

    public void setShadowVariables(Collection<String> shadowVariables) {
        this.shadowVariables = shadowVariables;
    }

    public void setType(String type) {
        this.type = type;
    }
}

