/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.IndexedTestBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.beanutils.bugs.other.Jira492IndexedListsSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class IndexedPropertyTestCase {
    private IndexedTestBean bean = null;
    private BeanUtilsBean beanUtilsBean;
    private PropertyUtilsBean propertyUtilsBean;
    private String[] testArray;
    private String[] newArray;
    private List<String> testList;
    private List<Object> newList;
    private ArrayList<Object> arrayList;

    @Before
    public void setUp() {
        this.beanUtilsBean = new BeanUtilsBean();
        this.propertyUtilsBean = this.beanUtilsBean.getPropertyUtils();
        this.testArray = new String[]{"array-0", "array-1", "array-2"};
        this.newArray = new String[]{"newArray-0", "newArray-1", "newArray-2"};
        this.testList = new ArrayList<String>();
        this.testList.add("list-0");
        this.testList.add("list-1");
        this.testList.add("list-2");
        this.newList = new ArrayList<Object>();
        this.newList.add("newList-0");
        this.newList.add("newList-1");
        this.newList.add("newList-2");
        this.arrayList = new ArrayList();
        this.arrayList.add("arrayList-0");
        this.arrayList.add("arrayList-1");
        this.arrayList.add("arrayList-2");
        this.bean = new IndexedTestBean();
        this.bean.setStringArray(this.testArray);
        this.bean.setStringList(this.testList);
        this.bean.setArrayList(this.arrayList);
    }

    @After
    public void tearDown() {
        this.bean = null;
    }

    @Test
    public void testArrayIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assert.assertNotNull((String)"No Array Descriptor", (Object)descriptor);
        Assert.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
        Assert.assertEquals((String)"PropertDescriptor Type invalid", this.testArray.getClass(), descriptor.getPropertyType());
    }

    @Test
    public void testListIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assert.assertNotNull((String)"No List Descriptor", (Object)descriptor);
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            Assert.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
        }
        Assert.assertEquals((String)"PropertDescriptor Type invalid", List.class, descriptor.getPropertyType());
    }

    @Test
    public void testArrayListIndexedPropertyDescriptor() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assert.assertNotNull((String)"No ArrayList Descriptor", (Object)descriptor);
        if (Jira492IndexedListsSupport.supportsIndexedLists()) {
            Assert.assertEquals((String)"Not IndexedPropertyDescriptor", IndexedPropertyDescriptor.class, descriptor.getClass());
        }
        Assert.assertEquals((String)"PropertDescriptor Type invalid", ArrayList.class, descriptor.getPropertyType());
    }

    @Test
    public void testArrayReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assert.assertNotNull((String)"No Array Read Method", (Object)descriptor.getReadMethod());
    }

    @Test
    public void testArrayWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assert.assertNotNull((String)"No Array Write Method", (Object)descriptor.getWriteMethod());
    }

    @Test
    public void testArrayIndexedReadMethod() throws Exception {
        IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assert.assertNotNull((String)"No Array Indexed Read Method", (Object)descriptor.getIndexedReadMethod());
    }

    @Test
    public void testArrayIndexedWriteMethod() throws Exception {
        IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringArray");
        Assert.assertNotNull((String)"No Array Indexed Write Method", (Object)descriptor.getIndexedWriteMethod());
    }

    @Test
    public void testListReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assert.assertNotNull((String)"No List Read Method", (Object)descriptor.getReadMethod());
    }

    @Test
    public void testListWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assert.assertNotNull((String)"No List Write Method", (Object)descriptor.getWriteMethod());
    }

    @Test
    public void testListIndexedReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assert.assertNotNull((String)"stringList descriptor not found", (Object)descriptor);
        Assume.assumeTrue((String)"JDK does not support index bean properties on java.util.List", (boolean)Jira492IndexedListsSupport.supportsIndexedLists());
        Assert.assertNotNull((String)"No List Indexed Read Method", (Object)((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod());
    }

    @Test
    public void testListIndexedWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "stringList");
        Assert.assertNotNull((String)"stringList descriptor not found", (Object)descriptor);
        Assume.assumeTrue((String)"JDK does not support index bean properties on java.util.List", (boolean)Jira492IndexedListsSupport.supportsIndexedLists());
        Assert.assertNotNull((String)"No List Indexed Write Method", (Object)((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod());
    }

    @Test
    public void testArrayListReadMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assert.assertNotNull((String)"No ArrayList Read Method", (Object)descriptor.getReadMethod());
    }

    @Test
    public void testArrayListWriteMethod() throws Exception {
        PropertyDescriptor descriptor = this.propertyUtilsBean.getPropertyDescriptor((Object)this.bean, "arrayList");
        Assert.assertNotNull((String)"No ArrayList Write Method", (Object)descriptor.getWriteMethod());
    }

    @Test
    public void testGetArray() throws Exception {
        Assert.assertEquals((Object)this.testArray, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringArray"));
    }

    @Test
    public void testGetArrayAsString() throws Exception {
        Assert.assertEquals((Object)"array-0", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray"));
    }

    @Test
    public void testGetArrayItemA() throws Exception {
        Assert.assertEquals((Object)"array-1", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringArray[1]"));
    }

    @Test
    public void testGetArrayItemB() throws Exception {
        Assert.assertEquals((Object)"array-1", (Object)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringArray", 1));
    }

    @Test
    public void testGetList() throws Exception {
        Assert.assertEquals(this.testList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "stringList"));
    }

    @Test
    public void testGetListAsString() throws Exception {
        Assert.assertEquals((Object)"list-0", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringList"));
    }

    @Test
    public void testGetListItemA() throws Exception {
        Assert.assertEquals((Object)"list-1", (Object)this.beanUtilsBean.getProperty((Object)this.bean, "stringList[1]"));
    }

    @Test
    public void testGetListItemB() throws Exception {
        Assert.assertEquals((Object)"list-1", (Object)this.beanUtilsBean.getIndexedProperty((Object)this.bean, "stringList", 1));
    }

    @Test
    public void testSetArray() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringArray", (Object)this.newArray);
        String[] value = this.bean.getStringArray();
        Assert.assertEquals((String)"Type is different", this.newArray.getClass(), value.getClass());
        String[] array = value;
        Assert.assertEquals((String)"Array Length is different", (long)this.newArray.length, (long)array.length);
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((String)("Element " + i + " is different"), (Object)this.newArray[i], (Object)array[i]);
        }
    }

    @Test
    public void testSetArrayItemA() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringArray[1]", (Object)"modified-1");
        Assert.assertEquals((Object)"modified-1", (Object)this.bean.getStringArray(1));
    }

    @Test
    public void testSetArrayItemB() throws Exception {
        this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringArray", 1, (Object)"modified-1");
        Assert.assertEquals((Object)"modified-1", (Object)this.bean.getStringArray(1));
    }

    @Test
    public void testSetList() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringList", this.newList);
        List<String> value = this.bean.getStringList();
        Assert.assertEquals((String)"Type is different", this.newList.getClass(), value.getClass());
        List<String> list = value;
        Assert.assertEquals((String)"List size is different", (long)this.newList.size(), (long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((String)("Element " + i + " is different"), (Object)this.newList.get(i), (Object)list.get(i));
        }
    }

    @Test
    public void testSetListItemA() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "stringList[1]", (Object)"modified-1");
        Assert.assertEquals((Object)"modified-1", (Object)this.bean.getStringList(1));
    }

    @Test
    public void testSetListItemB() throws Exception {
        this.propertyUtilsBean.setIndexedProperty((Object)this.bean, "stringList", 1, (Object)"modified-1");
        Assert.assertEquals((Object)"modified-1", (Object)this.bean.getStringList(1));
    }

    @Test
    public void testGetArrayList() throws Exception {
        Assert.assertEquals(this.arrayList, (Object)this.propertyUtilsBean.getProperty((Object)this.bean, "arrayList"));
    }

    @Test
    public void testSetArrayList() throws Exception {
        this.beanUtilsBean.setProperty((Object)this.bean, "arrayList", this.newList);
        ArrayList<Object> value = this.bean.getArrayList();
        Assert.assertEquals((String)"Type is different", this.newList.getClass(), value.getClass());
        List list = value;
        Assert.assertEquals((String)"List size is different", (long)this.newList.size(), (long)list.size());
        for (int i = 0; i < list.size(); ++i) {
            Assert.assertEquals((String)("Element " + i + " is different"), (Object)this.newList.get(i), list.get(i));
        }
    }
}

