/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.Flat3Map;

public class MapPerformance {
    private static final int RUNS = 20000000;

    public static void main(String[] args) {
        MapPerformance.testAll();
    }

    private static void testAll() {
        DummyMap<String, String> dummyMap = new DummyMap<String, String>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Flat3Map flatMap = new Flat3Map(hashMap);
        System.out.println(flatMap);
        MapPerformance.test(dummyMap, "         Dummy ");
        MapPerformance.test(dummyMap, "         Dummy ");
        MapPerformance.test(dummyMap, "         Dummy ");
        MapPerformance.test((Map<String, String>)flatMap, "         Flat3 ");
        MapPerformance.test(hashMap, "       HashMap ");
        MapPerformance.test((Map<String, String>)flatMap, "         Flat3 ");
        MapPerformance.test((Map<String, String>)flatMap, "         Flat3 ");
        MapPerformance.test((Map<String, String>)flatMap, "         Flat3 ");
        MapPerformance.test(hashMap, "       HashMap ");
        MapPerformance.test(hashMap, "       HashMap ");
        MapPerformance.test(hashMap, "       HashMap ");
    }

    private static void test(Map<String, String> map, String name) {
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        for (int i = 20000000; i > 0; --i) {
            map.put("Alpha", "A");
            map.put("Beta", "B");
            map.put("Beta", "C");
            map.put("Gamma", "D");
            map.put("Delta", "E");
            map.clear();
        }
        end = System.currentTimeMillis();
        System.out.println(name + (end - start));
    }

    private static class DummyMap<K, V>
    implements Map<K, V> {
        private DummyMap() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return null;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Set<K> keySet() {
            return null;
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Collection<V> values() {
            return null;
        }
    }
}

