/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.junit;

import java.util.Locale;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SetDefaultLocaleTestRule
implements TestRule {
    private final Locale locale;

    public SetDefaultLocaleTestRule(Locale locale) {
        this.locale = locale;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                Locale savedLocale = Locale.getDefault();
                Locale.setDefault(SetDefaultLocaleTestRule.this.getLocale());
                try {
                    base.evaluate();
                }
                finally {
                    Locale.setDefault(savedLocale);
                }
            }
        };
    }

    public Locale getLocale() {
        return this.locale;
    }
}

